/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table.simpletable;

import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.DITASimpleTableDocumentTypeHelper;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.SimpleTableConstants;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertColumnOperation
extends InsertColumnOperationBase
implements SimpleTableConstants,
InsertTableCellsContentConstants {
    private ArgumentDescriptor[] arguments;
    protected String cellContent;

    public InsertColumnOperation() {
        this(new DITASimpleTableDocumentTypeHelper());
        ArgumentDescriptor[] superArgs = super.getArguments();
        if (superArgs != null) {
            this.arguments = Arrays.copyOf(superArgs, superArgs.length + 1);
            this.arguments[superArgs.length] = CELL_FRAGMENT_ARGUMENT;
        } else {
            this.arguments = CELL_FRAGMENT_ARGUMENT_IN_ARRAY;
        }
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object cellFragmentObj = args.getArgumentValue("cellFragment");
        if (cellFragmentObj instanceof String) {
            this.cellContent = (String)cellFragmentObj;
        }
        if ("".equals(this.cellContent)) {
            this.cellContent = null;
        }
        super.doOperationInternal(authorAccess, args);
    }

    protected InsertColumnOperation(AuthorTableHelper documentTypeHelper) {
        super(documentTypeHelper);
    }

    @Override
    protected String getCellElementName(AuthorElement rowElement, int newColumnIndex) {
        String cellElementName = null;
        String rowName = rowElement.getLocalName();
        if ("strow".equals(rowName) || "sthead".equals(rowName)) {
            cellElementName = "stentry";
        } else if ("chrow".equals(rowName)) {
            cellElementName = InsertColumnOperation.getCellName(rowElement, new String[]{"choption", "chdesc"}, newColumnIndex);
        } else if ("chhead".equals(rowName)) {
            cellElementName = InsertColumnOperation.getCellName(rowElement, new String[]{"choptionhd", "chdeschd"}, newColumnIndex);
        } else if ("property".equals(rowName)) {
            cellElementName = InsertColumnOperation.getCellName(rowElement, new String[]{"proptype", "propvalue", "propdesc"}, newColumnIndex);
        } else if ("prophead".equals(rowName)) {
            cellElementName = InsertColumnOperation.getCellName(rowElement, new String[]{"proptypehd", "propvaluehd", "propdeschd"}, newColumnIndex);
        }
        return cellElementName;
    }

    private static String getCellName(AuthorElement rowElement, String[] possibleValues, int newColumnIndex) {
        String nextCellName = null;
        int cellIdx = 0;
        List children = rowElement.getContentNodes();
        if (!children.isEmpty()) {
            for (AuthorNode child : children) {
                if (child.getType() != 0) continue;
                String cellName = ((AuthorElement)child).getLocalName();
                if (cellIdx == newColumnIndex - 1) {
                    for (int i = 0; i < possibleValues.length; ++i) {
                        if (!possibleValues[i].equals(cellName) || i >= possibleValues.length - 1) continue;
                        nextCellName = possibleValues[i + 1];
                        break;
                    }
                } else if (nextCellName != null && cellName.equals(nextCellName)) {
                    nextCellName = null;
                    break;
                }
                ++cellIdx;
            }
        } else {
            nextCellName = possibleValues[0];
        }
        return nextCellName;
    }

    @Override
    protected String getDefaultContentForEmptyCells() {
        return this.cellContent;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement tableElem, int newColumnIndex, TableColumnSpecificationInformation columnSpecification, String namespace, int noOfColumnsToBeInserted) throws AuthorOperationException {
        super.updateColumnCellsSpan(authorAccess, tableSupport, tableElem, newColumnIndex, columnSpecification, namespace, noOfColumnsToBeInserted);
        if ("choicetable".equals(tableElem.getLocalName())) {
            return;
        }
        AttrValue relColWidth = tableElem.getAttribute("relcolwidth");
        if (relColWidth != null) {
            int i;
            String currentValue = relColWidth.getValue();
            boolean updatedValue = false;
            int valuesCounter = 0;
            StringBuilder newValue = new StringBuilder();
            StringTokenizer st = new StringTokenizer(currentValue);
            while (st.hasMoreElements()) {
                for (i = 0; i < noOfColumnsToBeInserted; ++i) {
                    if (valuesCounter != newColumnIndex) continue;
                    updatedValue = true;
                    newValue.append("1* ");
                }
                newValue.append(st.nextToken());
                if (st.hasMoreElements()) {
                    newValue.append(" ");
                }
                ++valuesCounter;
            }
            for (i = 0; i < noOfColumnsToBeInserted; ++i) {
                if (valuesCounter != newColumnIndex) continue;
                newValue.append(" 1*");
                updatedValue = true;
            }
            if (updatedValue) {
                authorAccess.getDocumentController().setAttribute("relcolwidth", new AttrValue(newValue.toString()), tableElem);
            }
        }
    }
}

