/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.topic.table.simpletable;

import java.util.StringTokenizer;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.operations.DeleteColumnOperationBase;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.DITASimpleTableDocumentTypeHelper;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.SimpleTableConstants;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class DeleteColumnOperation
extends DeleteColumnOperationBase
implements SimpleTableConstants {
    public DeleteColumnOperation() {
        super(new DITASimpleTableDocumentTypeHelper());
    }

    @Override
    protected void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider spanProvider, AuthorElement cell, int colStartIndex, int colEndIndex) throws AuthorOperationException {
    }

    @Override
    protected void updateAppliableColWidthsNumber(AuthorAccess authorAccess, AuthorElement tableElem, int deletedColumnIndex) {
        super.updateAppliableColWidthsNumber(authorAccess, tableElem, deletedColumnIndex);
        AttrValue relColWidth = tableElem.getAttribute("relcolwidth");
        if (relColWidth != null) {
            String currentValue = relColWidth.getValue();
            boolean updatedValue = false;
            int valuesCounter = 0;
            StringBuilder newValue = new StringBuilder();
            StringTokenizer st = new StringTokenizer(currentValue);
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                if (valuesCounter == deletedColumnIndex) {
                    updatedValue = true;
                    ++valuesCounter;
                    if (st.hasMoreElements() || newValue.length() <= 0) continue;
                    newValue.deleteCharAt(newValue.length() - 1);
                    continue;
                }
                newValue.append(token);
                ++valuesCounter;
                if (!st.hasMoreElements()) continue;
                newValue.append(" ");
            }
            if (updatedValue) {
                authorAccess.getDocumentController().setAttribute("relcolwidth", new AttrValue(newValue.toString()), tableElem);
            }
        }
    }

    @Override
    protected boolean canDeleteColumn() {
        AttrValue classAttr;
        boolean canDeleteColumn = true;
        if (this.tableElem != null && (classAttr = this.tableElem.getAttribute("class")) != null && classAttr.getValue().contains(" task/choicetable ")) {
            canDeleteColumn = false;
        }
        return canDeleteColumn;
    }
}

