/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.topicref;

import java.text.MessageFormat;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.topic.ref.ExpandableTopicrefCounter;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=true)
@WebappRestSafe
abstract class HeavyViewModeOperation
implements AuthorOperation {
    static final String ARGUMENT_KEY = "state";
    static final String ARGUMENT_ENABLE_VALUE = "enabled";
    static final String ARGUMENT_DISABLE_VALUE = "disabled";

    HeavyViewModeOperation() {
    }

    public final void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        boolean enable = ARGUMENT_ENABLE_VALUE.equals(args.getArgumentValue(ARGUMENT_KEY));
        this.doOperation(authorAccess, enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doOperation(AuthorAccess authorAccess, boolean enable) throws AuthorOperationException {
        ExpandableTopicrefCounter topicrefCounter = new ExpandableTopicrefCounter(authorAccess);
        int refsLimit = ExpandableTopicrefCounter.getTopicRefsLimit();
        int referencesToExpand = topicrefCounter.getNumberOfReferencesToExpand();
        if (enable && referencesToExpand > refsLimit) {
            HeavyViewModeOperation.showError(authorAccess, referencesToExpand, refsLimit);
        } else {
            boolean isModified = authorAccess.getEditorAccess().isModified();
            try {
                this.doOperationInternal(authorAccess, enable);
                this.setPseudoclass(authorAccess, enable);
            }
            finally {
                if (!isModified) {
                    authorAccess.getEditorAccess().setModified(isModified);
                }
            }
        }
    }

    protected void setPseudoclass(AuthorAccess authorAccess, boolean enable) {
        AuthorDocumentController ctrl = authorAccess.getDocumentController();
        AuthorElement root = ctrl.getAuthorDocumentNode().getRootElement();
        if (enable) {
            ctrl.setPseudoClassUndoable(this.getPseudoclass(), root);
        } else {
            ctrl.removePseudoClassUndoable(this.getPseudoclass(), root);
        }
    }

    abstract String getPseudoclass();

    abstract void doOperationInternal(AuthorAccess var1, boolean var2) throws AuthorOperationException;

    private static void showError(AuthorAccess authorAccess, int refsFound, int refsLimit) {
        String cannotEnableMessage = authorAccess.getAuthorResourceBundle().getMessage("CANNOT_SHOW_VIEW_MODE_MSGA");
        cannotEnableMessage = MessageFormat.format(cannotEnableMessage, refsLimit);
        String currentRefsCountMessage = authorAccess.getAuthorResourceBundle().getMessage("CANNOT_SHOW_VIEW_MODE_MSGB");
        currentRefsCountMessage = MessageFormat.format(currentRefsCountMessage, refsFound);
        authorAccess.getWorkspaceAccess().showErrorMessage(cannotEnableMessage + "\n" + currentRefsCountMessage);
    }

    public ArgumentDescriptor[] getArguments() {
        ArgumentDescriptor descriptor = new ArgumentDescriptor(ARGUMENT_KEY, 3, "This argument dictates the goal of the invocation. Use 'enabled' to expanded references.", new String[]{ARGUMENT_ENABLE_VALUE, ARGUMENT_DISABLE_VALUE}, ARGUMENT_ENABLE_VALUE);
        return new ArgumentDescriptor[]{descriptor};
    }
}

