/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map.table;

import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.dita.map.table.ECDITARelTableCustomizer;
import ro.sync.ecss.extensions.dita.map.table.SADITARelTableCustomizer;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertTableOperation
implements AuthorOperation,
InsertTableOperationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InsertTableOperation.class.getName());
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{AbstractTableOperation.TABLE_INFO_ARGUMENT_DESCRIPTOR};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object tableInfoObj = args.getArgumentValue("table_info");
        TableInfo tableInfo = tableInfoObj != null ? new TableInfo((Map)tableInfoObj, 0) : null;
        this.insertTable(null, false, authorAccess, null, null, tableInfo);
    }

    private void addRelTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper) throws AuthorOperationException {
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            tableXMLFragment.append("<relrow>");
            for (int j = 0; j < tableInfo.getColumnsNumber(); ++j) {
                if (fragments != null) {
                    String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, "relcell", i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    continue;
                }
                tableXMLFragment.append("<relcell></relcell>");
            }
            tableXMLFragment.append("</relrow>");
        }
    }

    private static void addRelTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        if (tableInfo.isGenerateHeader()) {
            tableXMLFragment.append("<relheader>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<relcolspec/>");
            }
            tableXMLFragment.append("</relheader>");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert a DITA map relationship table";
    }

    @Override
    public void insertTable(AuthorDocumentFragment[] fragments, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        int offsetToInsert;
        StringBuilder tableXMLFragment;
        block13: {
            if (tableInfo == null) {
                Platform platform;
                int rowsCount = -1;
                int columnsCount = -1;
                if (fragments != null) {
                    rowsCount = fragments.length;
                    columnsCount = 1;
                }
                if (Platform.STANDALONE == (platform = authorAccess.getWorkspaceAccess().getPlatform())) {
                    tableInfo = SADITARelTableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount);
                } else if (Platform.ECLIPSE == platform) {
                    tableInfo = ECDITARelTableCustomizer.getInstance().customizeTable(authorAccess, rowsCount, columnsCount);
                }
            }
            if (tableInfo != null) {
                int caretOffset;
                tableXMLFragment = new StringBuilder();
                if (tableInfo.getTitle() == null || tableInfo.getTitle().trim().length() == 0) {
                    tableXMLFragment.append("<reltable>");
                } else {
                    tableXMLFragment.append("<reltable>").append("<title>").append(authorAccess.getXMLUtilAccess().escapeTextValue(tableInfo.getTitle())).append("</title>");
                }
                InsertTableOperation.addRelTableHeader(tableXMLFragment, tableInfo);
                this.addRelTableBody(tableXMLFragment, tableInfo, fragments, cellsFragments, authorAccess, namespace, tableHelper);
                tableXMLFragment.append("</reltable>");
                offsetToInsert = caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                try {
                    AuthorElement currentElement;
                    AttrValue classAttribute;
                    String classAttributeValue;
                    AuthorNode currentNode = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
                    if (!(currentNode instanceof AuthorElement) || (classAttributeValue = (classAttribute = (currentElement = (AuthorElement)currentNode).getAttribute("class")).getValue()).contains(" map/map ")) break block13;
                    while (currentElement.getParentElement() != null) {
                        AuthorElement parentElement = (AuthorElement)currentElement.getParentElement();
                        classAttribute = parentElement.getAttribute("class");
                        classAttributeValue = classAttribute.getValue();
                        if (classAttributeValue.contains(" map/map ")) {
                            offsetToInsert = currentElement.getEndOffset() + 1;
                            break;
                        }
                        currentElement = parentElement;
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new AuthorOperationStoppedByUserException("Cancelled by user");
            }
        }
        SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(tableXMLFragment.toString(), offsetToInsert);
        TableOperationsUtil.placeCaretInFirstCell(authorAccess, tableInfo, authorAccess.getDocumentController(), result);
    }
}

