/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.map;

import com.google.common.annotations.VisibleForTesting;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.AuthorListener;
import ro.sync.ecss.extensions.api.AuthorListenerAdapter;
import ro.sync.ecss.extensions.api.AuthorPreloadProcessor;
import ro.sync.ecss.extensions.api.AuthorPseudoClassController;
import ro.sync.ecss.extensions.api.DocumentContentDeletedEvent;
import ro.sync.ecss.extensions.api.DocumentContentInsertedEvent;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
class DITAMapVariableDetector
extends AuthorListenerAdapter
implements AuthorExtensionStateListener,
AuthorPreloadProcessor {
    @VisibleForTesting
    static final String DITA_VARIABLE_PSEUDOCLASS = "-oxy-dita-variable";
    private AuthorDocumentController controller;

    DITAMapVariableDetector() {
    }

    private boolean isDITAVariable(AuthorNode candidate) {
        AuthorElement keyword;
        AuthorElement keywords;
        AuthorElement topicmeta;
        boolean isVariable = false;
        if (DITAMapVariableDetector.isElementWithName(candidate, "keydef") && (topicmeta = DITAMapVariableDetector.getSingleChild(candidate, "topicmeta")) != null && (keywords = DITAMapVariableDetector.getSingleChild((AuthorNode)topicmeta, "keywords")) != null && (keyword = DITAMapVariableDetector.getSingleChild((AuthorNode)keywords, "keyword")) != null) {
            isVariable = true;
        }
        return isVariable;
    }

    private static AuthorElement getSingleChild(AuthorNode candidate, String childLocalName) {
        AuthorElement childCandidate;
        AuthorElement[] childrenWithName;
        AuthorElement singleChild = null;
        if (candidate.getType() == 0 && (childrenWithName = ((AuthorElement)candidate).getElementsByLocalName(childLocalName)).length > 0 && (childCandidate = childrenWithName[0]).getStartOffset() == candidate.getStartOffset() + 1 && childCandidate.getEndOffset() == candidate.getEndOffset() - 1 && childCandidate.getType() == 0) {
            singleChild = childCandidate;
        }
        return singleChild;
    }

    private static boolean isElementWithName(AuthorNode candidate, String localName) {
        return candidate.getType() == 0 && localName.equals(((AuthorElement)candidate).getLocalName());
    }

    private void updatePseudoClass(AuthorNode node) {
        if (node != null && node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            if (this.isDITAVariable(node)) {
                this.controller.setPseudoClass(DITA_VARIABLE_PSEUDOCLASS, element);
            } else {
                this.controller.removePseudoClass(DITA_VARIABLE_PSEUDOCLASS, element);
            }
        }
    }

    private void updatePseudoClassBelow(AuthorNode node, int depth) {
        this.updatePseudoClass(node);
        if (depth == 0) {
            return;
        }
        if (node instanceof AuthorParentNode) {
            for (AuthorNode child : ((AuthorParentNode)node).getContentNodes()) {
                this.updatePseudoClassBelow(child, depth - 1);
            }
        }
    }

    private void updatePseudoClassAbove(AuthorNode node, int count) {
        this.updatePseudoClass(node);
        if (count == 0) {
            return;
        }
        AuthorNode parent = node.getParent();
        if (parent != null) {
            this.updatePseudoClassAbove(parent, count - 1);
        }
    }

    public void authorNodeNameChanged(AuthorNode node) {
        this.updatePseudoClassAbove(node, 3);
        this.updatePseudoClassBelow(node, 3);
    }

    public void authorNodeStructureChanged(AuthorNode node) {
        this.updatePseudoClassAbove(node, 2);
        this.updatePseudoClassBelow(node, Integer.MAX_VALUE);
    }

    public void documentChanged(AuthorDocument oldDocument, AuthorDocument newDocument) {
        this.updatePseudoClassBelow((AuthorNode)newDocument, Integer.MAX_VALUE);
    }

    public void contentDeleted(DocumentContentDeletedEvent e) {
        this.updatePseudoClassAbove(e.getParentNode(), 2);
    }

    public void contentInserted(DocumentContentInsertedEvent e) {
        AuthorNode parentNode;
        this.updatePseudoClassAbove(e.getParentNode(), 2);
        if ((e.getType() == 132 || e.getType() == 133) && (parentNode = e.getParentNode()) instanceof AuthorParentNode) {
            AuthorParentNode authorParentNode = (AuthorParentNode)parentNode;
            int startOffset = e.getOffset();
            int endOffset = startOffset + e.getLength() + 1;
            for (AuthorNode child : authorParentNode.getContentNodes()) {
                if (startOffset > child.getStartOffset() || child.getEndOffset() > endOffset) continue;
                this.updatePseudoClassBelow(child, Integer.MAX_VALUE);
            }
        }
    }

    public void doctypeChanged() {
        this.updatePseudoClassBelow((AuthorNode)this.controller.getAuthorDocumentNode(), Integer.MAX_VALUE);
    }

    public String getDescription() {
        return "DITA variable definition detector";
    }

    public void activated(AuthorAccess authorAccess) {
        this.controller = authorAccess.getDocumentController();
        if (this.controller != null) {
            this.controller.addAuthorListener((AuthorListener)this);
        }
    }

    public void deactivated(AuthorAccess authorAccess) {
        if (this.controller != null) {
            this.controller.removeAuthorListener((AuthorListener)this);
        }
    }

    public void documentAboutToBeLoaded(AuthorDocument document, AuthorPseudoClassController pseudoClassController) {
        this.updatePseudoClassDirectlyBelow((AuthorNode)document, pseudoClassController);
    }

    private void updatePseudoClassDirectlyBelow(AuthorNode node, AuthorPseudoClassController pseudoClassController) {
        if (node != null && node.getType() == 0) {
            AuthorElement element = (AuthorElement)node;
            if (this.isDITAVariable(node)) {
                pseudoClassController.setPseudoClass(DITA_VARIABLE_PSEUDOCLASS, element);
            } else {
                pseudoClassController.removePseudoClass(DITA_VARIABLE_PSEUDOCLASS, element);
            }
        }
        if (node instanceof AuthorParentNode) {
            for (AuthorNode child : ((AuthorParentNode)node).getContentNodes()) {
                this.updatePseudoClassDirectlyBelow(child, pseudoClassController);
            }
        }
    }
}

