/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita.conref;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ErrorResolverContextInfo;
import ro.sync.ecss.extensions.api.ReferenceErrorResolver;
import ro.sync.ecss.extensions.api.ReferenceErrorResolverExt;
import ro.sync.ecss.extensions.api.ReferenceResolverException;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.dita.conref.DITAFilteringContentHandler;
import ro.sync.xml.parser.SecureXMLReader;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAXMLReaderWrapper
implements XMLReader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DITAXMLReaderWrapper.class.getName());
    private XMLReader xmlReader;
    private DITAFilteringContentHandler filteringContentHandler;
    private boolean isKeyReference;
    private String systemId;

    public DITAXMLReaderWrapper(XMLReader xmlReader, String[] topicPath, String[] endTopicPath, String sourceClass, boolean isKeyReference) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader = xmlReader;
        this.isKeyReference = isKeyReference;
        this.filteringContentHandler = new DITAFilteringContentHandler(topicPath, endTopicPath, sourceClass, isKeyReference);
        xmlReader.setContentHandler(this.filteringContentHandler);
        xmlReader.setFeature("http://apache.org/xml/features/xinclude", false);
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this.filteringContentHandler);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.filteringContentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.xmlReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.xmlReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.xmlReader.getErrorHandler();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.filteringContentHandler;
        }
        return this.xmlReader.getProperty(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        try {
            if (input != null) {
                this.systemId = input.getSystemId();
            }
            SecureXMLReader.parse((XMLReader)this.xmlReader, (InputSource)input);
        }
        catch (Exception ex) {
            this.processParserException(ex);
        }
    }

    private void processParserException(Exception ex) {
        Object originalMsg = ex.getMessage();
        String message = originalMsg;
        boolean presentInResults = true;
        if (ex instanceof FileNotFoundException) {
            message = "Target file not found";
            originalMsg = "Error while parsing reference because: " + ex.getMessage();
            if (this.systemId != null && this.systemId.startsWith("file:")) {
                presentInResults = false;
            }
        }
        ReferenceResolverException exception = new ReferenceResolverException(message, (String)originalMsg, presentInResults, true);
        if (!this.isKeyReference) {
            ReferenceErrorResolverExt ditaConrefResolver = new ReferenceErrorResolverExt(){

                public void resolveError(ErrorResolverContextInfo contextInfo) {
                    AuthorAccess authorAccess = contextInfo.getAuthorAccess();
                    AuthorNode errorNode = contextInfo.getContextNode();
                    if (errorNode != null) {
                        try {
                            authorAccess.getEditorAccess().setCaretPosition(errorNode.getStartOffset() + 1);
                            DITAAccess.addEditReference((AuthorAccess)authorAccess);
                        }
                        catch (AuthorOperationException e) {
                            LOGGER.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
            exception.setErrorResolver((ReferenceErrorResolver)ditaConrefResolver);
        }
        exception.initCause((Throwable)ex);
        throw exception;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.filteringContentHandler.setContentHandler(handler);
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.xmlReader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.xmlReader.setEntityResolver(resolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.xmlReader.setErrorHandler(handler);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setFeature(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.filteringContentHandler.setLexicalHandler((LexicalHandler)value);
        } else {
            this.xmlReader.setProperty(name, value);
        }
    }
}

