/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaAwareEditingHandlerAdapter;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.Content;
import ro.sync.ecss.extensions.api.InvalidEditException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorDocumentProvider;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorNodeUtil;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResultsImpl;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITASchemaAwareEditingHandler
extends AuthorSchemaAwareEditingHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger((String)DITASchemaAwareEditingHandler.class.getName());
    private static final String ROOT = "<root/>";
    private static final String PARAGRAPH_ELEMENT_NAME = "p";
    private static final String CLASS_ATTR = "class";
    private static final String DESC_CLASS = "topic/desc";
    private static final String XREF_CLASS = "topic/xref";
    private static final String RELATED_LINKS_CLASS = "topic/related-links";
    private static final String LINK_CLASS = "topic/link";
    private static final String LINKTEXT_CLASS = "topic/linktext";
    private static final String LINKPOOL_CLASS = "topic/linkpool";
    private static final String LINKLIST_CLASS = "topic/linklist";
    private static final String STEPS_CLASS = "task/steps";
    private static final String STEP_CLASS = "task/step";
    private static final String STEPS_UNORDERED_CLASS = "task/steps-unordered";
    private static final String SIMPLE_TABLE_CLASS = "topic/simpletable";
    private static final String SIMPLE_TABLE_ROW_CLASS = "topic/strow";
    private static final String SIMPLE_TABLE_ENTRY_CLASS = "topic/stentry";
    private static final String REL_TABLE_CLASS = "map/reltable";
    private static final String REL_TABLE_ROW_CLASS = "map/relrow";
    private static final String REL_TABLE_ENTRY_CLASS = "map/relcell";
    private static final String TABLE_HEAD_CLASS = "topic/thead";
    private static final String TABLE_BODY_CLASS = "topic/tbody";
    private static final String CALS_TABLE_ROW_CLASS = "topic/row";
    private static final String CALS_TABLE_ENTRY_CLASS = "topic/entry";
    private static final String CMD_CLASS = "task/cmd";
    private static final String TOPIC_CLASS = "topic/topic";
    private static final String TITLE_CLASS = "topic/title";
    private static final String PARAGRAPH_CLASS = "topic/p";
    private static final String TITLEALTS_CLASS = "topic/titlealts";
    private static final String NAVTITLE_CLASS = "topic/navtitle";
    private static final String SEARCHTITLE_CLASS = "topic/searchtitle";
    private static final String BODY_ELEMENT = "topic/body";
    private static final String MATHML_NS = "http://www.w3.org/1998/Math/MathML";
    private static final Set<QName> GENERAL_BAD = new HashSet<QName>(Arrays.asList(new QName("draft-comment"), new QName("fn"), new QName("xref"), new QName("object"), new QName("abstract")));

    public boolean handleTyping(int offset, char ch, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleTyping = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (!authorSchemaManager.isLearnSchema() && !authorSchemaManager.hasLoadingErrors() && authorSchemaManager.getAuthorSchemaAwareOptions().isEnableSmartTyping()) {
            try {
                AuthorDocumentFragment characterFragment = authorAccess.getDocumentController().createNewDocumentTextFragment(String.valueOf(ch));
                handleTyping = this.handleInsertionEvent(offset, new AuthorDocumentFragment[]{characterFragment}, authorAccess, true);
            }
            catch (AuthorOperationException e) {
                throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), (Throwable)e, false);
            }
        }
        return handleTyping;
    }

    public boolean handleTypingFallback(int offset, char ch, AuthorAccess authorAccess) throws InvalidEditException {
        return this.handleInsertContent(offset, String.valueOf(ch), authorAccess);
    }

    private boolean handleInsertContent(int offset, String content, AuthorAccess authorAccess) throws InvalidEditException {
        boolean handleEvent = false;
        try {
            AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
            WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
            if (context != null) {
                ArrayList<String> elementsToInsert = new ArrayList<String>();
                String elementName = this.getElementName(authorSchemaManager, context, PARAGRAPH_CLASS, false);
                if (elementName == null) {
                    boolean isTopic;
                    AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(offset);
                    if (nodeAtOffset != null && (isTopic = DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtOffset, TOPIC_CLASS))) {
                        WhatElementsCanGoHereContext clone;
                        String bodyElementName;
                        boolean bodyExists = false;
                        AuthorElement topicNode = (AuthorElement)nodeAtOffset;
                        List contentNodes = topicNode.getContentNodes();
                        for (int i = 0; i < contentNodes.size(); ++i) {
                            AuthorNode authorNode = (AuthorNode)contentNodes.get(i);
                            boolean isBody = DITASchemaAwareEditingHandler.isElementWithClassParticle(authorNode, BODY_ELEMENT);
                            if (!isBody) continue;
                            bodyExists = true;
                            int startOffset = authorNode.getStartOffset() + 1;
                            int endOffset = authorNode.getEndOffset();
                            if (offset != startOffset - 1 && offset != endOffset + 1) continue;
                            int candidateOffset = startOffset - offset > 0 ? startOffset : endOffset;
                            context = authorSchemaManager.createWhatElementsCanGoHereContext(candidateOffset);
                            elementName = this.getElementName(authorSchemaManager, context, PARAGRAPH_CLASS, false);
                            if (elementName == null) break;
                            elementsToInsert.add(elementName);
                            offset = candidateOffset;
                            break;
                        }
                        if (!bodyExists && (bodyElementName = this.getElementName(authorSchemaManager, clone = (WhatElementsCanGoHereContext)context.clone(), BODY_ELEMENT, false)) != null) {
                            DITASchemaAwareEditingHandler.pushContextElement(clone, bodyElementName);
                            String p = this.getElementName(authorSchemaManager, clone, PARAGRAPH_CLASS, false);
                            if (p != null) {
                                elementsToInsert.add(bodyElementName);
                                elementsToInsert.add(p);
                            }
                        }
                    }
                } else {
                    elementsToInsert.add(elementName);
                }
                if (!elementsToInsert.isEmpty()) {
                    StringBuilder xmlFragment = new StringBuilder();
                    DITASchemaAwareEditingHandler.createFragment(elementsToInsert.iterator(), xmlFragment);
                    boolean canInsertRow = authorSchemaManager.canInsertDocumentFragments(new AuthorDocumentFragment[]{authorAccess.getDocumentController().createNewDocumentFragmentInContext(xmlFragment.toString(), offset)}, context, (short)4);
                    logger.debug("fragment: {} can insert {}", (Object)xmlFragment, (Object)canInsertRow);
                    if (canInsertRow) {
                        authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
                        authorAccess.getDocumentController().insertText(offset + elementsToInsert.size(), content);
                        this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
                        ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)(offset + elementsToInsert.size()));
                        handleEvent = true;
                    } else {
                        logger.debug("Fragments cannot be inserted in a para element.");
                    }
                } else {
                    logger.debug("Fragments cannot be inserted in a para element.");
                }
            }
        }
        catch (BadLocationException | AuthorOperationException e) {
            throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), e, false);
        }
        return handleEvent;
    }

    private static void createFragment(Iterator<String> iterator, StringBuilder xmlFragment) {
        if (iterator.hasNext()) {
            String next = iterator.next();
            xmlFragment.append("<");
            xmlFragment.append(next);
            xmlFragment.append(">");
            DITASchemaAwareEditingHandler.createFragment(iterator, xmlFragment);
            xmlFragment.append("</");
            xmlFragment.append(next);
            xmlFragment.append(">");
        }
    }

    public boolean handlePasteFragment(int offset, AuthorDocumentFragment[] fragmentsToInsert, int actionId, AuthorAccess authorAccess) throws InvalidEditException {
        boolean validResult;
        boolean handleInsertionEvent = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        if (!(authorSchemaManager.isLearnSchema() || authorSchemaManager.hasLoadingErrors() || !authorSchemaManager.getAuthorSchemaAwareOptions().isEnableSmartPaste() || (handleInsertionEvent = this.handleInsertionEvent(offset, fragmentsToInsert, authorAccess, false)) || (validResult = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4)))) {
            boolean onlyText = true;
            StringBuilder text = new StringBuilder();
            for (AuthorDocumentFragment authorDocumentFragment : fragmentsToInsert) {
                if (authorDocumentFragment.containsSimpleText() && authorDocumentFragment.getContentNodes().isEmpty()) {
                    Content fragContent = authorDocumentFragment.getContent();
                    try {
                        text.append(fragContent.getString(0, fragContent.getLength()));
                    }
                    catch (BadLocationException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                onlyText = false;
                break;
            }
            if (onlyText) {
                handleInsertionEvent = this.handleInsertContent(offset, text.toString(), authorAccess);
            }
        }
        return handleInsertionEvent;
    }

    AuthorDocumentFragment convertXrefToLink(AuthorDocumentFragment xrefsFragment, CIElement linkElement, AuthorDocumentController ctrl, int offsetInsideRelatedLinks) throws BadLocationException, AuthorOperationException {
        AuthorDocumentFragment toReturn = null;
        String xmlFragment = ctrl.serializeFragmentToXML(xrefsFragment);
        xrefsFragment = ctrl.createNewDocumentFragmentInContext(xmlFragment, offsetInsideRelatedLinks);
        WhatElementsCanGoHereContext relatedLinksContext = ctrl.getAuthorSchemaManager().createWhatElementsCanGoHereContext(offsetInsideRelatedLinks);
        List linkAcceptedAttrs = linkElement.getAttributes();
        Content xrefsFragContent = xrefsFragment.getContent();
        List xrefs = xrefsFragment.getContentNodes();
        for (AuthorNode xrefNode : xrefs) {
            AuthorElement xrefEl = (AuthorElement)xrefNode;
            int attributesCount = xrefEl.getAttributesCount();
            HashSet<String> attrsToRemove = new HashSet<String>();
            for (int i = 0; i < attributesCount; ++i) {
                String attributeAtIndex = xrefEl.getAttributeAtIndex(i);
                if (DITASchemaAwareEditingHandler.acceptsAttr(linkAcceptedAttrs, attributeAtIndex)) continue;
                attrsToRemove.add(attributeAtIndex);
            }
            attrsToRemove.forEach(arg_0 -> ((AuthorElement)xrefEl).removeAttribute(arg_0));
            boolean foundFirstDesc = false;
            List xrefContentNodes = xrefEl.getContentNodes();
            Iterator iterator = xrefContentNodes.iterator();
            while (iterator.hasNext()) {
                AuthorNode node = (AuthorNode)iterator.next();
                if (!DITASchemaAwareEditingHandler.isElementWithClassParticle(node, DESC_CLASS) || foundFirstDesc) {
                    xrefsFragContent.remove(node.getStartOffset(), node.getEndOffset() - node.getStartOffset() + 1);
                    iterator.remove();
                    continue;
                }
                if (!DITASchemaAwareEditingHandler.isElementWithClassParticle(node, DESC_CLASS)) continue;
                foundFirstDesc = true;
            }
            Object linkLabel = "";
            if (xrefContentNodes.isEmpty()) {
                linkLabel = xrefEl.getTextContent();
                if (!((String)linkLabel).isEmpty()) {
                    xrefsFragContent.remove(xrefEl.getStartOffset() + 1, xrefEl.getEndOffset());
                }
            } else {
                AuthorNode descNode = (AuthorNode)xrefEl.getContentNodes().get(0);
                if (xrefEl.getStartOffset() + 1 < descNode.getStartOffset()) {
                    linkLabel = (String)linkLabel + xrefsFragContent.getString(xrefEl.getStartOffset() + 1, descNode.getStartOffset() - xrefEl.getStartOffset() - 1);
                    xrefsFragContent.remove(xrefEl.getStartOffset() + 1, descNode.getStartOffset() - xrefEl.getStartOffset() - 1);
                }
                if (descNode.getEndOffset() + 1 < xrefEl.getEndOffset()) {
                    linkLabel = (String)linkLabel + xrefsFragContent.getString(descNode.getEndOffset() + 1, xrefEl.getEndOffset() - descNode.getEndOffset() - 1);
                    xrefsFragContent.remove(descNode.getEndOffset() + 1, xrefEl.getEndOffset() - descNode.getEndOffset() - 1);
                }
            }
            xrefEl.setName(linkElement.getName());
            String classValue = null;
            for (CIAttribute attr : linkAcceptedAttrs) {
                if (!CLASS_ATTR.equals(attr.getName())) continue;
                classValue = attr.getDefaultValue();
                break;
            }
            if (classValue != null) {
                xrefEl.setAttribute(CLASS_ATTR, new AttrValue(classValue, classValue, false));
            }
            if (((String)linkLabel).isEmpty()) {
                toReturn = xrefsFragment;
                continue;
            }
            int insertionOffset = xrefNode.getStartOffset() + 1;
            String marker = "__MARKER__";
            xrefsFragContent.insertChars(insertionOffset, marker.toCharArray(), 0, marker.length());
            String serializedFragment = ctrl.serializeFragmentToXML(xrefsFragment);
            DITASchemaAwareEditingHandler.pushContextElement(relatedLinksContext, linkElement.getName());
            CIElement linktextElement = this.getElement(ctrl.getAuthorSchemaManager(), relatedLinksContext, LINKTEXT_CLASS, false);
            String replacement = "<" + linktextElement.getName() + ">" + (String)linkLabel + "</" + linktextElement.getName() + ">";
            serializedFragment = serializedFragment.replace(marker, replacement);
            toReturn = ctrl.createNewDocumentFragmentInContext(serializedFragment, offsetInsideRelatedLinks);
        }
        return toReturn;
    }

    private static boolean acceptsAttr(List<CIAttribute> acceptedAttrs, String attributeName) {
        boolean toRet = false;
        for (CIAttribute attr : acceptedAttrs) {
            if (!attr.getName().equals(attributeName)) continue;
            toRet = true;
            break;
        }
        return toRet;
    }

    private boolean handleInsertionEvent(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, boolean isTypingEvent) throws InvalidEditException {
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        boolean handleEvent = false;
        try {
            AuthorNode nodeAtInsertionOffset = authorAccess.getDocumentController().getNodeAtOffset(offset);
            logger.debug("nodeAtInsertionOffset {}", (Object)nodeAtInsertionOffset);
            boolean onlyXrefs = this.onlyXrefs(fragmentsToInsert);
            if (onlyXrefs) {
                handleEvent = this.handleXrefsInsertionEvent(offset, nodeAtInsertionOffset, fragmentsToInsert, authorAccess);
            } else if (DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, TOPIC_CLASS)) {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionEventInTopic(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, STEPS_CLASS) || DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, STEPS_UNORDERED_CLASS)) {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionEventInSteps(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, STEP_CLASS) && nodeAtInsertionOffset.getStartOffset() + 1 == nodeAtInsertionOffset.getEndOffset()) {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionEventInStep(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, TABLE_BODY_CLASS) || DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, TABLE_HEAD_CLASS) || DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, SIMPLE_TABLE_CLASS) || DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, REL_TABLE_CLASS)) {
                boolean canInsertFragments;
                if (offset != nodeAtInsertionOffset.getEndOffset() && !(canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4))) {
                    handleEvent = this.handleInvalidInsertionEventInTable(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, TITLEALTS_CLASS)) {
                boolean canInsertFragments = authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, offset, (short)4);
                if (!canInsertFragments) {
                    handleEvent = this.handleInvalidInsertionInTitlealts(offset, fragmentsToInsert, authorAccess, authorSchemaManager);
                }
            } else if (DITASchemaAwareEditingHandler.isRelatedLinkElement(nodeAtInsertionOffset)) {
                handleEvent = this.handleInsertionEventInRelatedLink(offset, nodeAtInsertionOffset, fragmentsToInsert, authorAccess);
            }
        }
        catch (BadLocationException | AuthorOperationException e) {
            throw new InvalidEditException(e.getMessage(), "Invalid typing event: " + e.getMessage(), e, false);
        }
        return handleEvent;
    }

    private boolean handleInsertionEventInRelatedLink(int offset, AuthorNode linkNode, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess) throws BadLocationException, AuthorOperationException {
        WhatElementsCanGoHereContext context;
        String linkTextEl;
        boolean handleEvent = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        AuthorElement element = (AuthorElement)linkNode;
        for (AuthorNode chNode : element.getContentNodes()) {
            if (!DITASchemaAwareEditingHandler.isRelatedLinkText(chNode)) continue;
            offset = chNode.getStartOffset() + 1;
            handleEvent = this.handleInsertElementsInternal(offset, fragmentsToInsert, authorAccess, authorSchemaManager, authorSchemaManager.createWhatElementsCanGoHereContext(offset), new LinkedList<String>());
            break;
        }
        if (!handleEvent && (linkTextEl = this.getElementName(authorSchemaManager, context = authorSchemaManager.createWhatElementsCanGoHereContext(offset), LINKTEXT_CLASS, false)) != null) {
            LinkedList<String> elements = new LinkedList<String>();
            DITASchemaAwareEditingHandler.pushContextElement(context, linkTextEl, elements);
            handleEvent = this.handleInsertElementsInternal(offset, fragmentsToInsert, authorAccess, authorSchemaManager, context, elements);
        }
        return handleEvent;
    }

    private boolean handleXrefsInsertionEvent(int offset, AuthorNode nodeAtInsertionOffset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess) {
        boolean handleEvent = false;
        logger.debug("only XREFs");
        try {
            WhatElementsCanGoHereContext context;
            AuthorSchemaManager authorSchemaManager;
            CIElement linkElement;
            AuthorElement rootElement;
            if (nodeAtInsertionOffset.getType() == 2 && (rootElement = ((AuthorDocument)nodeAtInsertionOffset).getRootElement()).getEndOffset() < offset) {
                offset = rootElement.getEndOffset();
                nodeAtInsertionOffset = rootElement;
                logger.debug("Out of root element ");
            }
            AuthorNode relatedLinksNode = null;
            AuthorDocumentController ctrl = authorAccess.getDocumentController();
            if (DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, TOPIC_CLASS)) {
                AuthorNode candidate = ctrl.getNodeAtOffset(offset - 1);
                logger.debug("Candidate : {}", (Object)candidate);
                while (DITASchemaAwareEditingHandler.isElementWithClassParticle(candidate, TOPIC_CLASS)) {
                    List contentNodes = ((AuthorElement)candidate).getContentNodes();
                    AuthorNode lastChild = (AuthorNode)contentNodes.get(contentNodes.size() - 1);
                    if (lastChild == null) continue;
                    candidate = lastChild;
                }
                if (candidate != nodeAtInsertionOffset) {
                    List children = ((AuthorParentNode)nodeAtInsertionOffset).getContentNodes();
                    int childIndex = AuthorNodeUtil.getChildIndex((int)candidate.getEndOffset(), (List)children);
                    while (childIndex >= 0 && authorAccess.getEditorAccess().getStyles(candidate).isInvisible()) {
                        candidate = (AuthorNode)children.get(--childIndex);
                    }
                    logger.debug("Final Candidate : {}", (Object)candidate);
                    if (candidate != null && DITASchemaAwareEditingHandler.isElementWithClassParticle(candidate, RELATED_LINKS_CLASS)) {
                        relatedLinksNode = candidate;
                    }
                }
            } else if (DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, RELATED_LINKS_CLASS) || DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, LINKPOOL_CLASS) || DITASchemaAwareEditingHandler.isElementWithClassParticle(nodeAtInsertionOffset, LINKLIST_CLASS)) {
                relatedLinksNode = nodeAtInsertionOffset;
            }
            if (relatedLinksNode != null && (linkElement = this.getElement(authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager(), context = authorSchemaManager.createWhatElementsCanGoHereContext(relatedLinksNode.getStartOffset() + 1), LINK_CLASS, false)) != null) {
                for (int i = 0; i < fragmentsToInsert.length; ++i) {
                    fragmentsToInsert[i] = this.convertXrefToLink(fragmentsToInsert[i], linkElement, ctrl, relatedLinksNode.getStartOffset() + 1);
                }
                int[] offsets = new int[fragmentsToInsert.length];
                for (int i = 0; i < offsets.length; ++i) {
                    offsets[i] = relatedLinksNode.equals(nodeAtInsertionOffset) ? authorAccess.getEditorAccess().getCaretOffset() : relatedLinksNode.getEndOffset();
                }
                ctrl.insertMultipleFragments((AuthorElement)relatedLinksNode, fragmentsToInsert, offsets);
                handleEvent = true;
            }
        }
        catch (BadLocationException | AuthorOperationException ex) {
            logger.debug((Object)ex, ex);
        }
        return handleEvent;
    }

    private static boolean isRelatedLinkElement(AuthorNode node) {
        AuthorElement element;
        AttrValue classVal;
        String clazz = "";
        if (node.getType() == 0 && (classVal = (element = (AuthorElement)node).getAttribute(CLASS_ATTR)) != null) {
            clazz = classVal.getValue();
        }
        return DITAAccess.getInheritanceType((String)clazz, (String)"- topic/link ") == 2;
    }

    private static boolean isRelatedLinkText(AuthorNode node) {
        AuthorElement element;
        AttrValue classVal;
        String clazz = "";
        if (node.getType() == 0 && (classVal = (element = (AuthorElement)node).getAttribute(CLASS_ATTR)) != null) {
            clazz = classVal.getValue();
        }
        return DITAAccess.getInheritanceType((String)clazz, (String)"- topic/linktext ") == 2;
    }

    private boolean onlyXrefs(AuthorDocumentFragment[] fragments) {
        boolean toRet = false;
        block0: for (int i = 0; i < fragments.length; ++i) {
            List contentNodes = fragments[i].getContentNodes();
            for (AuthorNode authorNode : contentNodes) {
                toRet = DITASchemaAwareEditingHandler.isElementWithClassParticle(authorNode, XREF_CLASS);
                if (toRet) continue;
                break block0;
            }
        }
        return toRet;
    }

    private boolean handleInvalidInsertionInTitlealts(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws AuthorOperationException, BadLocationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        String navtitleElementName = this.getElementName(authorSchemaManager, context, NAVTITLE_CLASS, true);
        if (navtitleElementName != null) {
            handleEvent = this.tryInsertContentInElement(offset, fragmentsToInsert, authorAccess, authorSchemaManager, context, navtitleElementName);
        } else {
            logger.debug("Could not insert navtitle in topic according to schema.");
            String searchtitleElementName = this.getElementName(authorSchemaManager, context, SEARCHTITLE_CLASS, true);
            if (searchtitleElementName != null) {
                handleEvent = this.tryInsertContentInElement(offset, fragmentsToInsert, authorAccess, authorSchemaManager, context, searchtitleElementName);
            } else {
                logger.debug("Could not insert searchtitle in topic according to schema.");
            }
        }
        return handleEvent;
    }

    private boolean tryInsertContentInElement(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager, WhatElementsCanGoHereContext context, String elementName) throws AuthorOperationException, BadLocationException {
        LinkedList<String> elements = new LinkedList<String>();
        DITASchemaAwareEditingHandler.pushContextElement(context, elementName, elements);
        return this.handleInsertElementsInternal(offset, fragmentsToInsert, authorAccess, authorSchemaManager, context, elements);
    }

    private boolean handleInvalidInsertionEventInTopic(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        AuthorElement topicElement = (AuthorElement)authorAccess.getDocumentController().getNodeAtOffset(offset);
        if (topicElement.getStartOffset() + 1 == topicElement.getEndOffset()) {
            WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
            String titleElementName = this.getElementName(authorSchemaManager, context, TITLE_CLASS, false);
            if (titleElementName != null) {
                LinkedList<String> elements = new LinkedList<String>();
                DITASchemaAwareEditingHandler.pushContextElement(context, titleElementName, elements);
                handleEvent = this.handleInsertElementsInternal(offset, fragmentsToInsert, authorAccess, authorSchemaManager, context, elements);
            } else {
                logger.debug("Could not insert title in topic according to schema.");
            }
        }
        return handleEvent;
    }

    private String getElementName(AuthorSchemaManager schemaManager, WhatElementsCanGoHereContext context, String elementClass, boolean isElementsSearchStrict) {
        String toReturn = null;
        CIElement element = this.getElement(schemaManager, context, elementClass, isElementsSearchStrict);
        if (element != null) {
            toReturn = element.getName();
        }
        return toReturn;
    }

    CIElement getElement(AuthorSchemaManager schemaManager, WhatElementsCanGoHereContext context, String elementClass, boolean isElementsSearchStrict) {
        List childrenElements;
        CIElement element = null;
        List list = childrenElements = isElementsSearchStrict ? schemaManager.whatElementsCanGoHere(context) : schemaManager.getChildrenElements(context);
        if (childrenElements != null) {
            for (CIElement ciElement : childrenElements) {
                List attributes = ciElement.getAttributesWithDefaultValues();
                if (attributes != null) {
                    for (CIAttribute ciAttribute : attributes) {
                        if (!ciAttribute.getName().equals(CLASS_ATTR)) continue;
                        if (ciAttribute.getDefaultValue() == null || !ciAttribute.getDefaultValue().contains(" " + elementClass + " ")) break;
                        element = ciElement;
                        break;
                    }
                }
                if (element == null) continue;
                break;
            }
        }
        return element;
    }

    private boolean deriveContextWithElements(WhatElementsCanGoHereContext context, AuthorSchemaManager authorSchemaManager, String[] elements, LinkedList<String> elementsToAdd) {
        boolean derived = true;
        for (String element : elements) {
            String elementName = this.getElementName(authorSchemaManager, context, element, false);
            if (elementName == null) {
                logger.debug("Cannot insert " + element + " in step according to schema");
                derived = false;
                break;
            }
            DITASchemaAwareEditingHandler.pushContextElement(context, elementName, elementsToAdd);
        }
        return derived;
    }

    private boolean handleInvalidInsertionEventInSteps(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent;
        block5: {
            LinkedList<String> elementsToAdd;
            handleEvent = false;
            WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
            boolean wasContextDerivedSuccesfully = this.deriveContextWithElements(context, authorSchemaManager, new String[]{STEP_CLASS, CMD_CLASS}, elementsToAdd = new LinkedList<String>());
            if (wasContextDerivedSuccesfully && !(handleEvent = this.handleInsertElementsInternal(offset, fragmentsToInsert, authorAccess, authorSchemaManager, (WhatElementsCanGoHereContext)context.clone(), elementsToAdd)) && DITASchemaAwareEditingHandler.isOnlyParas(fragmentsToInsert)) {
                try {
                    AuthorDocumentProvider authorDocumentProvider = CommonAccess.createAuthorDocumentProvider(null, (Reader)new StringReader(ROOT), (boolean)false);
                    AuthorElement rootElement = authorDocumentProvider.getAuthorDocumentController().getAuthorDocumentNode().getRootElement();
                    AuthorDocumentController newCtrl = authorDocumentProvider.getAuthorDocumentController();
                    for (int i = 0; i < fragmentsToInsert.length; ++i) {
                        AuthorDocumentFragment current = fragmentsToInsert[i];
                        newCtrl.insertFragment(rootElement.getEndOffset(), current);
                    }
                    List paraNodes = rootElement.getContentNodes();
                    for (int i = paraNodes.size() - 1; i >= 0; --i) {
                        int endOffset;
                        int startOffset = ((AuthorNode)paraNodes.get(i)).getStartOffset() + 1;
                        if (startOffset > (endOffset = ((AuthorNode)paraNodes.get(i)).getEndOffset() - 1)) continue;
                        AuthorDocumentFragment docFragment = newCtrl.createDocumentFragment(startOffset, endOffset);
                        handleEvent = this.handleInsertElementsInternal(offset, new AuthorDocumentFragment[]{docFragment}, authorAccess, authorSchemaManager, (WhatElementsCanGoHereContext)context.clone(), elementsToAdd);
                    }
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        return handleEvent;
    }

    private static boolean isOnlyParas(AuthorDocumentFragment[] fragmentsToAnalyze) {
        boolean isOnlyParas;
        block5: {
            isOnlyParas = true;
            if (fragmentsToAnalyze != null && fragmentsToAnalyze.length > 0) {
                for (AuthorDocumentFragment fragment : fragmentsToAnalyze) {
                    if (fragment.containsSimpleText()) {
                        isOnlyParas = false;
                        break;
                    }
                    for (AuthorNode fragNode : fragment.getContentNodes()) {
                        if (PARAGRAPH_ELEMENT_NAME.equals(fragNode.getName())) continue;
                        isOnlyParas = false;
                        break block5;
                    }
                }
            } else {
                isOnlyParas = false;
            }
        }
        return isOnlyParas;
    }

    private boolean handleInsertElementsInternal(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager, WhatElementsCanGoHereContext context, LinkedList<String> elements) throws AuthorOperationException, BadLocationException {
        boolean handleEvent = false;
        StringBuilder xmlFragment = new StringBuilder();
        DITASchemaAwareEditingHandler.createFragment(elements.iterator(), xmlFragment);
        if (fragmentsToInsert == null) {
            fragmentsToInsert = new AuthorDocumentFragment[]{authorAccess.getDocumentController().createNewDocumentFragmentInContext(xmlFragment.toString(), offset)};
        }
        if (authorSchemaManager.canInsertDocumentFragments(fragmentsToInsert, context, (short)4)) {
            logger.debug("Insert {}", (Object)xmlFragment);
            authorAccess.getDocumentController().insertXMLFragment(xmlFragment.toString(), offset);
            int insertionOffset = -1;
            AuthorNode newNode = authorAccess.getDocumentController().getNodeAtOffset(offset + elements.size());
            for (int i = 0; i < fragmentsToInsert.length; ++i) {
                if (insertionOffset == -1) {
                    insertionOffset = newNode.getEndOffset();
                }
                authorAccess.getDocumentController().insertFragment(newNode.getEndOffset(), fragmentsToInsert[i]);
            }
            this.lastHandlerResult = new SchemaAwareHandlerResultsImpl("result.value.handle.insert.fragment.operation");
            ((SchemaAwareHandlerResultsImpl)this.lastHandlerResult).addResult("result.id.handle.insert.fragment.offset", (Object)insertionOffset);
            handleEvent = true;
        } else {
            logger.debug("Fragments cannot be inserted in a para element.");
        }
        return handleEvent;
    }

    private static void pushContextElement(WhatElementsCanGoHereContext context, String elementName) {
        DITASchemaAwareEditingHandler.pushContextElement(context, elementName, null);
    }

    private static void pushContextElement(WhatElementsCanGoHereContext context, String elementName, LinkedList<String> elements) {
        ContextElement contextElement = new ContextElement();
        contextElement.setQName(elementName);
        context.pushContextElement(contextElement, null);
        if (elements != null) {
            elements.add(elementName);
        }
    }

    private static boolean isElementWithClassParticle(AuthorNode node, String classParticle) {
        AuthorElement element;
        AttrValue classVal;
        boolean result = false;
        classParticle = classParticle.trim();
        if (node.getType() == 0 && (classVal = (element = (AuthorElement)node).getAttribute(CLASS_ATTR)) != null) {
            result = classVal.getValue().contains(" " + classParticle + " ");
        }
        return result;
    }

    private boolean handleInvalidInsertionEventInStep(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        boolean handleEvent = false;
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        String cmdElementName = this.getElementName(authorSchemaManager, context, CMD_CLASS, false);
        if (cmdElementName != null) {
            LinkedList<String> elements = new LinkedList<String>();
            DITASchemaAwareEditingHandler.pushContextElement(context, cmdElementName, elements);
            handleEvent = this.handleInsertElementsInternal(offset, fragmentsToInsert, authorAccess, authorSchemaManager, context, elements);
        } else {
            logger.debug("Cannot insert cmd in step according to schema");
        }
        return handleEvent;
    }

    private boolean handleInvalidInsertionEventInTable(int offset, AuthorDocumentFragment[] fragmentsToInsert, AuthorAccess authorAccess, AuthorSchemaManager authorSchemaManager) throws BadLocationException, AuthorOperationException {
        AuthorNode tablePart = authorAccess.getDocumentController().getNodeAtOffset(offset);
        if (offset == tablePart.getEndOffset()) {
            return false;
        }
        boolean isCALS = DITASchemaAwareEditingHandler.isElementWithClassParticle(tablePart, TABLE_BODY_CLASS) || DITASchemaAwareEditingHandler.isElementWithClassParticle(tablePart, TABLE_HEAD_CLASS);
        boolean isSimpletable = !isCALS && DITASchemaAwareEditingHandler.isElementWithClassParticle(tablePart, SIMPLE_TABLE_CLASS);
        WhatElementsCanGoHereContext context = authorSchemaManager.createWhatElementsCanGoHereContext(offset);
        String tableRowName = null;
        tableRowName = isCALS ? this.getElementName(authorSchemaManager, context, CALS_TABLE_ROW_CLASS, false) : (isSimpletable ? this.getElementName(authorSchemaManager, context, SIMPLE_TABLE_ROW_CLASS, false) : this.getElementName(authorSchemaManager, context, REL_TABLE_ROW_CLASS, false));
        boolean wasHandled = false;
        if (tableRowName != null) {
            boolean canInsertRow = authorSchemaManager.canInsertDocumentFragments(new AuthorDocumentFragment[]{authorAccess.getDocumentController().createNewDocumentFragmentInContext("<" + tableRowName + "/>", offset)}, context, (short)4);
            if (canInsertRow) {
                LinkedList<String> elements = new LinkedList<String>();
                DITASchemaAwareEditingHandler.pushContextElement(context, tableRowName, elements);
                String tableEntryName = null;
                tableEntryName = isCALS ? this.getElementName(authorSchemaManager, context, CALS_TABLE_ENTRY_CLASS, false) : (isSimpletable ? this.getElementName(authorSchemaManager, context, SIMPLE_TABLE_ENTRY_CLASS, false) : this.getElementName(authorSchemaManager, context, REL_TABLE_ENTRY_CLASS, false));
                if (tableEntryName != null) {
                    DITASchemaAwareEditingHandler.pushContextElement(context, tableEntryName, elements);
                    wasHandled = this.handleInsertElementsInternal(offset, fragmentsToInsert, authorAccess, authorSchemaManager, context, elements);
                } else {
                    logger.debug("Cannot insert table entry in row according to schema.");
                }
            }
        } else {
            logger.debug("Could not insert table row in table according to schema.");
        }
        return wasHandled;
    }

    public boolean changeElementsToMoveUpDown(List<AuthorNode> selectedElements) {
        AuthorNode parent;
        boolean elementsChanged = false;
        AuthorNode authorNode = selectedElements.get(0);
        if (DITASchemaAwareEditingHandler.isElementWithClassParticle(authorNode, TITLE_CLASS) && (parent = authorNode.getParent()) != null) {
            selectedElements.clear();
            selectedElements.add(parent);
            elementsChanged = true;
        }
        return elementsChanged;
    }

    public AuthorSchemaAwareEditingHandlerAdapter.WrapInAncestorsOptions getAncestorDetectionOptions() {
        return new AuthorSchemaAwareEditingHandlerAdapter.WrapInAncestorsOptions(){

            public Set<QName> getForbiddenParents(QName elementName, Collection<QName> possibleParents) {
                if (DITASchemaAwareEditingHandler.MATHML_NS.equals(elementName.getNamespaceURI()) && !"math".equals(elementName.getLocalPart())) {
                    HashSet<QName> forbidden = new HashSet<QName>();
                    for (QName qName : possibleParents) {
                        if (DITASchemaAwareEditingHandler.MATHML_NS.equals(qName.getNamespaceURI())) continue;
                        forbidden.add(qName);
                    }
                    return forbidden;
                }
                return GENERAL_BAD;
            }

            public Set<QName> getPreferredParents(QName elementName, Collection<QName> possibleParents) {
                HashSet<QName> prefs = new HashSet<QName>();
                if ("entry".equals(elementName.getLocalPart())) {
                    prefs.add(new QName("tbody"));
                } else {
                    prefs.add(new QName(DITASchemaAwareEditingHandler.PARAGRAPH_ELEMENT_NAME));
                }
                return prefs;
            }
        };
    }

    public boolean canBeReplaced(AuthorNode nodeToReplace) {
        boolean canReplace = true;
        if (nodeToReplace.getType() == 0) {
            AuthorElement authorElement = (AuthorElement)nodeToReplace;
            canReplace = authorElement.getAttribute("id") == null && authorElement.getAttribute("href") == null && authorElement.getAttribute("conref") == null && authorElement.getAttribute("conkeyref") == null && authorElement.getAttribute("keyref") == null;
        }
        return canReplace;
    }

    public QName getPreferredElement(AuthorDocumentController ctrl, int offset) {
        return new QName(PARAGRAPH_ELEMENT_NAME);
    }
}

