/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.net.URL;
import java.util.EnumMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.exml.workspace.api.node.customizer.BasicRenderingInformation;
import ro.sync.exml.workspace.api.node.customizer.NodeRendererCustomizerContext;
import ro.sync.exml.workspace.api.node.customizer.XMLNodeRendererCustomizer;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITANodeRendererCustomizer
extends XMLNodeRendererCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)DITANodeRendererCustomizer.class.getName());
    private static final EnumMap<DitaClass, String> classToIconPath = new EnumMap(DitaClass.class);

    private static String getImageURL(String path) {
        URL imageURL = DITANodeRendererCustomizer.class.getResource(path);
        if (imageURL != null) {
            return imageURL.toExternalForm();
        }
        logger.error(DITANodeRendererCustomizer.class.getName() + " - Image not found: " + path);
        return null;
    }

    public BasicRenderingInformation getRenderingInformation(NodeRendererCustomizerContext context) {
        BasicRenderingInformation renderingInfo = new BasicRenderingInformation();
        DitaClass ditaClass = this.getDITAClass(context);
        if (ditaClass != null) {
            String iconPath = classToIconPath.get((Object)ditaClass);
            renderingInfo.setIconPath(iconPath);
        }
        return renderingInfo;
    }

    private DitaClass getDITAClass(NodeRendererCustomizerContext context) {
        DitaClass ditaClass = null;
        String classValue = context.getAttributeValue("class");
        if (classValue != null && !"".equals(classValue.trim())) {
            ditaClass = this.getDitaClassForClassValue(classValue);
        }
        return ditaClass;
    }

    DitaClass getDitaClassForClassValue(String classValue) {
        DitaClass[] classes;
        for (DitaClass cls : classes = DitaClass.values()) {
            String substring;
            String value = cls.getValue();
            if (!classValue.contains(value) || (substring = classValue.substring(classValue.indexOf(value) + value.length() - 1)).trim().length() != 0 && !substring.contains(value)) continue;
            return cls;
        }
        return null;
    }

    public String getDescription() {
        return "DITA Node Renderer Customizer";
    }

    static {
        classToIconPath.put(DitaClass.TITLE_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTitle16.png"));
        String bodyImg = DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBody16.png");
        classToIconPath.put(DitaClass.TOPIC_BODY_CLASS, bodyImg);
        classToIconPath.put(DitaClass.TASK_BODY_CLASS, bodyImg);
        classToIconPath.put(DitaClass.CONCEPT_BODY_CLASS, bodyImg);
        classToIconPath.put(DitaClass.P_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementPara16.png"));
        classToIconPath.put(DitaClass.I_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementItalic16.png"));
        classToIconPath.put(DitaClass.B_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBold16.png"));
        classToIconPath.put(DitaClass.U_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUnderline16.png"));
        classToIconPath.put(DitaClass.IMAGE_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementImage16.png"));
        classToIconPath.put(DitaClass.XREF_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementXref16.png"));
        classToIconPath.put(DitaClass.LINK_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLink16.png"));
        String tableImg = DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTable16.png");
        classToIconPath.put(DitaClass.TABLE_CLASS, tableImg);
        classToIconPath.put(DitaClass.SIMPLE_TABLE_CLASS, tableImg);
        String tableHeadImg = DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTHead16.png");
        classToIconPath.put(DitaClass.THEAD_CLASS, tableHeadImg);
        classToIconPath.put(DitaClass.STHEAD_CLASS, tableHeadImg);
        classToIconPath.put(DitaClass.TBODY_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTBody16.png"));
        String tableRowImg = DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTr16.png");
        classToIconPath.put(DitaClass.ROW_CLASS, tableRowImg);
        classToIconPath.put(DitaClass.STROW_CLASS, tableRowImg);
        String tableCellImg = DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTd16.png");
        classToIconPath.put(DitaClass.ENTRY_CLASS, tableCellImg);
        classToIconPath.put(DitaClass.STENTRY_CLASS, tableCellImg);
        classToIconPath.put(DitaClass.UL_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementUl16.png"));
        String olImg = DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementOl16.png");
        classToIconPath.put(DitaClass.OL_CLASS, olImg);
        classToIconPath.put(DitaClass.STEPS_CLASS, olImg);
        String liImg = DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementLi16.png");
        classToIconPath.put(DitaClass.STEP_CLASS, liImg);
        classToIconPath.put(DitaClass.LI_CLASS, liImg);
        classToIconPath.put(DitaClass.BODY_DIV_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementDiv16.png"));
        classToIconPath.put(DitaClass.SECTION_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementSection16.png"));
        classToIconPath.put(DitaClass.TOPIC_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTopic16.png"));
        classToIconPath.put(DitaClass.MAP_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementMap16.png"));
        classToIconPath.put(DitaClass.BOOKMAP_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementBookmap16.png"));
        classToIconPath.put(DitaClass.TASK_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementTask16.png"));
        classToIconPath.put(DitaClass.CONCEPT_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementConcept16.png"));
        classToIconPath.put(DitaClass.INDEXTERM_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementIndexterm16.png"));
        classToIconPath.put(DitaClass.OBJECT_CLASS, DITANodeRendererCustomizer.getImageURL("/images/node-customizer/ElementMedia16.png"));
    }

    public static enum DitaClass {
        TITLE_CLASS(" topic/title "),
        TOPIC_BODY_CLASS(" topic/body "),
        CONCEPT_BODY_CLASS(" concept/conbody "),
        TASK_BODY_CLASS(" task/taskbody "),
        P_CLASS(" topic/p "),
        I_CLASS(" hi-d/i "),
        B_CLASS(" hi-d/b "),
        U_CLASS(" hi-d/u "),
        IMAGE_CLASS(" topic/image "),
        LINK_CLASS(" topic/link "),
        XREF_CLASS(" topic/xref "),
        TABLE_CLASS(" topic/table "),
        SIMPLE_TABLE_CLASS(" topic/simpletable "),
        THEAD_CLASS(" topic/thead "),
        STHEAD_CLASS(" topic/sthead "),
        TBODY_CLASS(" topic/tbody "),
        ROW_CLASS(" topic/row "),
        STROW_CLASS(" topic/strow "),
        ENTRY_CLASS(" topic/entry "),
        STENTRY_CLASS(" topic/stentry "),
        UL_CLASS(" topic/ul "),
        OL_CLASS(" topic/ol "),
        STEPS_CLASS(" task/steps "),
        STEP_CLASS(" task/step "),
        LI_CLASS(" topic/li "),
        BODY_DIV_CLASS(" topic/bodydiv "),
        SECTION_CLASS(" topic/section "),
        TOPIC_CLASS(" topic/topic "),
        MAP_CLASS(" map/map "),
        BOOKMAP_CLASS(" bookmap/bookmap "),
        TASK_CLASS(" task/task "),
        CONCEPT_CLASS(" concept/concept "),
        INDEXTERM_CLASS(" topic/indexterm "),
        OBJECT_CLASS(" topic/object ");

        private String value;

        private DitaClass(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

