/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.dita.ContextKeyManagerProvider;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.dita.DITAImposedReferenceType;
import ro.sync.ecss.dita.ImageInfo;
import ro.sync.ecss.dita.MediaInfo;
import ro.sync.ecss.dita.reference.keyref.KeyInfo;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExternalObjectInsertionHandler;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ReferenceType;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.MediaObjectsUtil;
import ro.sync.ecss.extensions.dita.DITAExternalObjectInsertionHandlerUtil;
import ro.sync.exml.workspace.api.util.UtilAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAExternalObjectInsertionHandler
extends AuthorExternalObjectInsertionHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)DITAExternalObjectInsertionHandler.class.getName());
    private static final String ONLY_TEXT_CONTENT_DITA_STYLESHEET_FILE = "resources/onlyTextContentDita.xsl";
    private static final String REMOVE_FOOTNOTE_FROM_CONTENT_STYLESHEET_FILE = "resources/removeFootnoteFromContent.xsl";
    private ContextKeyManagerProvider contextKeyManagerProvider;

    public DITAExternalObjectInsertionHandler() {
    }

    public DITAExternalObjectInsertionHandler(ContextKeyManagerProvider contextKeyManagerProvider) {
        this.contextKeyManagerProvider = contextKeyManagerProvider;
    }

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, List<ReferenceType> types, int source) throws AuthorOperationException {
        if (!urls.isEmpty()) {
            StringBuilder contentToInsert = new StringBuilder();
            URL base = DITAExternalObjectInsertionHandler.getBaseURLAtCaretPosition((AuthorAccess)authorAccess);
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode contextNode = null;
            try {
                contextNode = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            for (URL url : urls) {
                String toInsert;
                if (source == 8) {
                    DITAExternalObjectInsertionHandlerUtil.insertContentReference(this.contextKeyManagerProvider, authorAccess, url);
                    continue;
                }
                KeyInfo keyInfo = DITAExternalObjectInsertionHandlerUtil.detectKeyInfo(url, authorAccess.getEditorAccess().getEditorLocation());
                DITAImposedReferenceType imposedRefType = DITAAccess.detectInsertionType((URL)url);
                if (keyInfo != null) {
                    toInsert = null;
                    String keyName = keyInfo.getKeyName();
                    switch (imposedRefType) {
                        case VARIABLE: {
                            toInsert = DITAExternalObjectInsertionHandler.buildKeyrefFragment(Optional.ofNullable(DITAAccess.computeVariableKeyrefElementName((AuthorAccess)authorAccess)).orElse("ph"), keyName);
                            break;
                        }
                        case FIGURE: {
                            toInsert = DITAAccess.buildFigureKeyrefImageXMLToInsert((AuthorAccess)authorAccess, null, (String)keyName);
                            break;
                        }
                        case MEDIA: {
                            if (DITAAccess.isGenericMediaContent((KeyInfo)keyInfo)) {
                                toInsert = this.buildMediaReferenceFragment(authorAccess, base, keyInfo, contextNode);
                                break;
                            }
                            if (!DITAAccess.isKeyReferenceToImage((KeyInfo)keyInfo)) break;
                            toInsert = DITAExternalObjectInsertionHandler.buildKeyrefFragment(Optional.ofNullable(DITAAccess.computeVariableKeyrefElementName((AuthorAccess)authorAccess, (boolean)true)).orElse("image"), keyName);
                            break;
                        }
                        case XREF: {
                            toInsert = DITAExternalObjectInsertionHandler.buildKeyrefFragment(DITAAccess.getAutoInsertRefElementName((AuthorAccess)authorAccess, (int)caretOffset), keyName);
                            DITAExternalObjectInsertionHandler.createRelatedLinksSectionIfNeeded(authorAccess);
                            caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                            break;
                        }
                        default: {
                            logger.warn(String.format("Unable to insert key '%s' as '%s'.", keyName, imposedRefType));
                        }
                    }
                    if (toInsert == null) continue;
                    contentToInsert.append(toInsert);
                    continue;
                }
                toInsert = null;
                URL cleanURL = DITAExternalObjectInsertionHandler.removeOxyCustomQueryParams(url);
                boolean imageReference = DITAExternalObjectInsertionHandler.isImageReference(authorAccess, types.get(0), cleanURL);
                boolean mediaReference = MediaObjectsUtil.isMediaReference(cleanURL);
                String[] refData = DITAExternalObjectInsertionHandlerUtil.getReferenceAttributeNameAndValue(this.contextKeyManagerProvider, authorAccess, base, cleanURL, contextNode);
                switch (imposedRefType) {
                    case FIGURE: {
                        toInsert = DITAAccess.buildFigureHrefImageXMLToInsert((AuthorAccess)authorAccess, null, (String)refData[1]);
                        break;
                    }
                    case MEDIA: {
                        if (imageReference) {
                            toInsert = DITAAccess.computeImageReferenceXMLToInsert((AuthorAccess)authorAccess, (String)refData[0], (String)refData[1]);
                            break;
                        }
                        toInsert = this.buildMediaReferenceFragment(authorAccess, base, cleanURL, contextNode);
                        break;
                    }
                    case XREF: {
                        caretOffset = DITAExternalObjectInsertionHandler.insertAsReferenceWithUpdatedCaretOffset(authorAccess, cleanURL, types.get(0), contentToInsert, refData);
                        break;
                    }
                    case NOT_IMPOSED: {
                        if (imageReference) {
                            if (urls.size() == 1) {
                                DITAAccess.insertImage((AuthorAccess)authorAccess, (ImageInfo)new ImageInfo(refData[0], refData[1]));
                                break;
                            }
                            toInsert = DITAAccess.computeImageReferenceXMLToInsert((AuthorAccess)authorAccess, (String)refData[0], (String)refData[1]);
                            break;
                        }
                        if (mediaReference) {
                            toInsert = this.buildMediaReferenceFragment(authorAccess, base, cleanURL, contextNode);
                            break;
                        }
                        caretOffset = DITAExternalObjectInsertionHandler.insertAsReferenceWithUpdatedCaretOffset(authorAccess, cleanURL, types.get(0), contentToInsert, refData);
                        break;
                    }
                    default: {
                        logger.warn(String.format("Unable to insert resource '%s' as '%s'.", cleanURL, imposedRefType));
                    }
                }
                if (toInsert == null) continue;
                contentToInsert.append(toInsert);
            }
            if (contentToInsert.length() > 0) {
                authorAccess.getDocumentController().insertXMLFragmentSchemaAware(contentToInsert.toString(), caretOffset, true);
            }
        }
    }

    private static void addFormatAndScopeToLink(AuthorAccess authorAccess, StringBuilder contentToInsert, String referenceTag, URL url, ReferenceType type) {
        if (!"coderef".equals(referenceTag)) {
            contentToInsert.append(DITAAccess.computeFormatForURLPasteAndDnD((UtilAccess)authorAccess.getUtilAccess(), (URL)url, (ReferenceType)type));
        }
        URL base = DITAExternalObjectInsertionHandler.getBaseURLAtCaretPosition((AuthorAccess)authorAccess);
        contentToInsert.append(DITAAccess.computeLinkScope((URL)url, (URL)base));
    }

    private String buildMediaReferenceFragment(AuthorAccess authorAccess, URL base, URL keyHrefLocation, AuthorNode contextNode) {
        String outputClass = MediaObjectsUtil.detectOutputclass(keyHrefLocation.toExternalForm());
        return this.buildMediaFragmentInternal(authorAccess, base, outputClass, keyHrefLocation, contextNode);
    }

    private String buildMediaReferenceFragment(AuthorAccess authorAccess, URL base, KeyInfo key, AuthorNode contextNode) {
        String outputClass = DITAAccess.detectMediaObjectOutputclass((KeyInfo)key);
        URL hrefLocation = key.getHrefLocation();
        return this.buildMediaFragmentInternal(authorAccess, base, outputClass, hrefLocation, contextNode);
    }

    private String buildMediaFragmentInternal(AuthorAccess authorAccess, URL base, String outputClass, URL keyHrefLocation, AuthorNode contextNode) {
        boolean embeddedContent;
        String[] mediaRefData = DITAExternalObjectInsertionHandlerUtil.getMediaReferenceAttributeNameAndValue(this.contextKeyManagerProvider, authorAccess.getEditorAccess().getEditorLocation(), base, keyHrefLocation, contextNode);
        boolean bl = embeddedContent = keyHrefLocation != null && MediaObjectsUtil.isEmbeddedContent(keyHrefLocation.toExternalForm());
        if (!embeddedContent && mediaRefData[1] != null) {
            embeddedContent = MediaObjectsUtil.isEmbeddedContent(mediaRefData[1]);
        }
        MediaInfo media = new MediaInfo(mediaRefData[0].equals("data") ? mediaRefData[1] : null, mediaRefData[0].equals("datakeyref") ? mediaRefData[1] : null, null, null, null, null, outputClass, embeddedContent);
        return DITAAccess.computeMediaReferenceXMLToInsert((AuthorAccess)authorAccess, (MediaInfo)media);
    }

    private static void createRelatedLinksSectionIfNeeded(AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorElement rootElement = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        AttrValue clazz = rootElement.getAttribute("class");
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        if (clazz != null && clazz.getValue().contains(" topic/topic ") && Math.abs(rootElement.getEndOffset() - caretOffset) <= 1 && DITAExternalObjectInsertionHandler.shouldCreateRelatedLinksElement(rootElement)) {
            authorAccess.getDocumentController().insertXMLFragmentSchemaAware("<related-links></related-links>", caretOffset);
        }
    }

    private static boolean shouldCreateRelatedLinksElement(AuthorElement rootElement) {
        boolean shouldCreateRelatedLinksElement = true;
        List contentNodes = rootElement.getContentNodes();
        if (contentNodes != null) {
            for (int i = 0; i < contentNodes.size(); ++i) {
                AuthorElement elem;
                AttrValue elemClazz;
                AuthorNode node = (AuthorNode)contentNodes.get(i);
                if (node.getType() != 0 || (elemClazz = (elem = (AuthorElement)node).getAttribute("class")) == null || !elemClazz.getValue().contains(" topic/related-links ")) continue;
                shouldCreateRelatedLinksElement = false;
                break;
            }
        }
        return shouldCreateRelatedLinksElement;
    }

    private static boolean isImageReference(AuthorAccess authorAccess, ReferenceType type, URL url) {
        return type == ReferenceType.IMAGE_REFERENCE || type == null && authorAccess.getUtilAccess().isSupportedImageURL(url);
    }

    public void insertURLs(AuthorAccess authorAccess, List<URL> urls, int source) throws AuthorOperationException {
        List<Object> types = Collections.nCopies(urls.size(), null);
        this.insertURLs(authorAccess, urls, types, source);
    }

    protected String getImporterStylesheetFileName(AuthorAccess authorAccess) {
        return "xhtml2ditaDriver.xsl";
    }

    protected StreamSource getOnlyTextContentStylesheet(AuthorAccess authorAccess) {
        return this.getClassStylesheetResource(DITAExternalObjectInsertionHandler.class, ONLY_TEXT_CONTENT_DITA_STYLESHEET_FILE);
    }

    protected StreamSource getFilterContentOfOutputStylesheet() {
        return this.getClassStylesheetResource(DITAExternalObjectInsertionHandler.class, REMOVE_FOOTNOTE_FROM_CONTENT_STYLESHEET_FILE);
    }

    private static int insertAsReferenceWithUpdatedCaretOffset(AuthorAccess authorAccess, URL referenceURL, ReferenceType refType, StringBuilder contentToInsert, String[] refData) throws AuthorOperationException {
        DITAExternalObjectInsertionHandler.createRelatedLinksSectionIfNeeded(authorAccess);
        int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
        String referenceTag = DITAAccess.getAutoInsertRefElementName((AuthorAccess)authorAccess, (int)caretOffset);
        contentToInsert.append("<").append(referenceTag).append(" ").append(refData[0]);
        contentToInsert.append("=\"").append(authorAccess.getXMLUtilAccess().escapeAttributeValue(refData[1])).append("\"");
        DITAExternalObjectInsertionHandler.addFormatAndScopeToLink(authorAccess, contentToInsert, referenceTag, referenceURL, refType);
        contentToInsert.append("/>");
        return caretOffset;
    }

    private static URL removeOxyCustomQueryParams(URL url) {
        try {
            URLInfo info = URLUtil.getURLInfo((URL)url);
            return info.getURL(true, false, true);
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
    }

    private static String buildKeyrefFragment(String elementName, String keyName) {
        StringBuilder fragment = new StringBuilder();
        fragment.append("<").append(elementName).append(" keyref=\"").append(keyName).append("\"").append("/>").toString();
        return fragment.toString();
    }
}

