/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.util.Stack;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.link.Attr;
import ro.sync.ecss.extensions.api.link.ElementLocator;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAElementLocator
extends ElementLocator {
    private String topicId;
    private String elementId;
    private Stack elementStack = new Stack();

    public DITAElementLocator(String link) {
        super(link);
        String[] tokens = link.split("/");
        this.topicId = tokens[0];
        this.elementId = tokens[1];
    }

    public void endElement(String uri, String localName, String name) {
        if (!this.elementStack.isEmpty()) {
            this.elementStack.pop();
        }
    }

    public boolean startElement(String uri, String localName, String name, Attr[] atts) {
        boolean toReturn = false;
        String idAttribute = DITAElementLocator.getIdValue(atts);
        boolean isTopic = DITAElementLocator.isTopic(atts);
        if (!isTopic && this.elementId.equals(idAttribute)) {
            int length = this.elementStack.size();
            for (int i = length - 1; i >= 0; --i) {
                Attr[] elAttrs = (Attr[])this.elementStack.get(i);
                if (i == length - 1 && DITAElementLocator.hasConrefAttributes(elAttrs)) break;
                if (!DITAElementLocator.isTopic(elAttrs)) continue;
                if ((!"FIRST_TOPIC_ID".equals(this.topicId) || this.getNumberOfNestedTopics() != 1) && !".".equals(this.topicId) && !this.topicId.equals(DITAElementLocator.getIdValue(elAttrs))) break;
                toReturn = true;
                break;
            }
        }
        this.elementStack.push(atts);
        return toReturn;
    }

    private static boolean isTopic(Attr[] atts) {
        boolean isTopic = false;
        for (int i = 0; i < atts.length; ++i) {
            if (!"class".equals(DITAElementLocator.getLocalName(atts[i].getQName()))) continue;
            isTopic = atts[i].getValue().contains(" topic/topic ");
            break;
        }
        return isTopic;
    }

    private static boolean hasConrefAttributes(Attr[] atts) {
        boolean hasConref = false;
        for (int i = 0; i < atts.length; ++i) {
            String localName = DITAElementLocator.getLocalName(atts[i].getQName());
            if (!"conref".equals(localName) && !"conkeyref".equals(localName)) continue;
            hasConref = true;
            break;
        }
        return hasConref;
    }

    private static String getIdValue(Attr[] atts) {
        String id = null;
        for (int i = 0; i < atts.length; ++i) {
            if (!"id".equals(DITAElementLocator.getLocalName(atts[i].getQName()))) continue;
            id = atts[i].getValue();
            break;
        }
        return id;
    }

    private static String getLocalName(String qName) {
        int idx;
        String local = qName;
        if (qName != null && (idx = qName.lastIndexOf(58)) != -1) {
            local = qName.substring(idx + 1);
        }
        return local;
    }

    private int getNumberOfNestedTopics() {
        int cnt = 0;
        int length = this.elementStack.size();
        for (int i = length - 1; i >= 0; --i) {
            Attr[] elAttrs = (Attr[])this.elementStack.get(i);
            if (!DITAElementLocator.isTopic(elAttrs)) continue;
            ++cnt;
        }
        return cnt;
    }
}

