/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.dita;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteColumnArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteRowArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableDeleteRowsArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableInsertColumnArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableInsertRowArguments;
import ro.sync.ecss.extensions.api.table.operations.AuthorTableOperationsHandler;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSTableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;
import ro.sync.ecss.extensions.dita.topic.table.DITATableDocumentTypeHelper;
import ro.sync.ecss.extensions.dita.topic.table.InsertTableOperation;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.DeleteColumnOperation;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.DeleteRowOperation;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.InsertColumnOperation;
import ro.sync.ecss.extensions.dita.topic.table.simpletable.InsertRowOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITAAuthorTableOperationsHandler
extends AuthorTableOperationsHandler {
    private InsertRowOperation insertRowSimpleTable = null;
    private InsertColumnOperation insertColumnSimpleTable = null;
    private ro.sync.ecss.extensions.commons.table.operations.cals.InsertRowOperation insertRowCALSTable = null;
    private ro.sync.ecss.extensions.commons.table.operations.cals.InsertColumnOperation insertColumnCALSTable = null;
    private DeleteColumnOperation deleteColumnSimpleTable = null;
    private ro.sync.ecss.extensions.commons.table.operations.cals.DeleteColumnOperation deleteColumnCALSTable = null;
    private DeleteRowOperation deleteRowSimpleTable = null;
    private ro.sync.ecss.extensions.commons.table.operations.cals.DeleteRowOperation deleteRowCALSTable = null;
    private InsertTableOperation insertTableOperation = null;
    private static final Logger logger = LoggerFactory.getLogger((String)DITAAuthorTableOperationsHandler.class.getName());

    public boolean handleInsertColumn(AuthorTableInsertColumnArguments tablePasteColumnArgs) throws AuthorOperationException {
        boolean handled = false;
        try {
            AuthorAccess authorAccess = tablePasteColumnArgs.getAuthorAccess();
            boolean simpleTable = DITAAuthorTableOperationsHandler.isSimpleTable(authorAccess, tablePasteColumnArgs.getInsertOffset());
            if (this.insertTableOperation == null) {
                this.insertTableOperation = new InsertTableOperation();
            }
            if (simpleTable) {
                if (this.insertRowSimpleTable == null) {
                    this.insertRowSimpleTable = new InsertRowOperation();
                }
                if (this.insertColumnSimpleTable == null) {
                    this.insertColumnSimpleTable = new InsertColumnOperation();
                }
                this.insertColumnSimpleTable.performInsertColumn(authorAccess, null, tablePasteColumnArgs.getColumnFragments(), tablePasteColumnArgs.getColumnSpecificationInformation(), tablePasteColumnArgs.areFragmentsWrappedInCells(), this.insertRowSimpleTable, this.insertTableOperation);
            } else {
                if (this.insertRowCALSTable == null) {
                    this.insertRowCALSTable = new ro.sync.ecss.extensions.commons.table.operations.cals.InsertRowOperation();
                }
                if (this.insertColumnCALSTable == null) {
                    this.insertColumnCALSTable = new ro.sync.ecss.extensions.commons.table.operations.cals.InsertColumnOperation();
                }
                this.insertColumnCALSTable.performInsertColumn(authorAccess, null, tablePasteColumnArgs.getColumnFragments(), tablePasteColumnArgs.getColumnSpecificationInformation(), tablePasteColumnArgs.areFragmentsWrappedInCells(), this.insertRowCALSTable, this.insertTableOperation);
            }
            handled = true;
        }
        catch (IllegalArgumentException | BadLocationException e) {
            logger.warn("Paste column failed.", (Throwable)e);
        }
        return handled;
    }

    public boolean handleDeleteColumn(AuthorTableDeleteColumnArguments arguments) throws AuthorOperationException {
        boolean handled = false;
        try {
            AuthorAccess authorAccess = arguments.getAuthorAccess();
            int tableOffset = -1;
            List intervals = arguments.getColumnCellsIntervals();
            if (intervals != null && !intervals.isEmpty()) {
                tableOffset = ((ContentInterval)intervals.get(0)).getEndOffset();
            }
            if (tableOffset >= 0) {
                boolean simpleTable = DITAAuthorTableOperationsHandler.isSimpleTable(authorAccess, tableOffset);
                if (simpleTable) {
                    if (this.deleteColumnSimpleTable == null) {
                        this.deleteColumnSimpleTable = new DeleteColumnOperation();
                    }
                    this.deleteColumnSimpleTable.performDeleteColumn(authorAccess, arguments.getColumnCellsIntervals(), false);
                } else {
                    if (this.deleteColumnCALSTable == null) {
                        this.deleteColumnCALSTable = new ro.sync.ecss.extensions.commons.table.operations.cals.DeleteColumnOperation();
                    }
                    this.deleteColumnCALSTable.performDeleteColumn(authorAccess, arguments.getColumnCellsIntervals(), false);
                }
                handled = true;
            }
        }
        catch (IllegalArgumentException | BadLocationException e) {
            logger.warn("Delete column failed.", (Throwable)e);
        }
        return handled;
    }

    private static boolean isSimpleTable(AuthorAccess authorAccess, int tableOffset) throws BadLocationException {
        boolean simpleTable = false;
        for (AuthorNode currentNode = authorAccess.getDocumentController().getNodeAtOffset(tableOffset); currentNode != authorAccess.getDocumentController().getAuthorDocumentNode(); currentNode = currentNode.getParent()) {
            String classValue;
            AuthorElement pasteElement;
            AttrValue classAttribute;
            if (!(currentNode instanceof AuthorElement) || (classAttribute = (pasteElement = (AuthorElement)currentNode).getAttribute("class")) == null || (classValue = classAttribute.getRawValue()) == null) continue;
            if (classValue.contains(" topic/strow ") || classValue.contains(" topic/sthead ") || classValue.contains(" topic/stentry ") || classValue.contains(" topic/simpletable ")) {
                simpleTable = true;
                break;
            }
            if (classValue.contains(" topic/row ") || classValue.contains(" topic/head ") || classValue.contains(" topic/entry ") || classValue.contains(" topic/table ")) break;
        }
        return simpleTable;
    }

    public boolean handleDeleteRow(AuthorTableDeleteRowArguments arguments) throws AuthorOperationException {
        boolean handled = false;
        if (arguments != null) {
            ArrayList<ContentInterval> contentIntervals = new ArrayList<ContentInterval>(1);
            contentIntervals.add(arguments.getRowInterval());
            handled = this.handleDeleteRows(arguments.getAuthorAccess(), contentIntervals);
        }
        return handled;
    }

    public boolean handleDeleteRows(AuthorTableDeleteRowsArguments arguments) throws AuthorOperationException {
        return this.handleDeleteRows(arguments.getAuthorAccess(), arguments.getContentIntervals());
    }

    private boolean handleDeleteRows(AuthorAccess authorAccess, List<ContentInterval> contentIntervals) throws AuthorOperationException {
        boolean handled = false;
        try {
            if (contentIntervals != null && !contentIntervals.isEmpty()) {
                ContentInterval contentInterval = contentIntervals.get(0);
                boolean simpleTable = DITAAuthorTableOperationsHandler.isSimpleTable(authorAccess, contentInterval.getStartOffset());
                if (simpleTable) {
                    if (this.deleteRowSimpleTable == null) {
                        this.deleteRowSimpleTable = new DeleteRowOperation();
                    }
                    this.deleteRowSimpleTable.performDeleteRows(authorAccess, contentIntervals);
                } else {
                    if (this.deleteRowCALSTable == null) {
                        this.deleteRowCALSTable = new ro.sync.ecss.extensions.commons.table.operations.cals.DeleteRowOperation();
                    }
                    this.deleteRowCALSTable.performDeleteRows(authorAccess, contentIntervals);
                }
            } else {
                throw new AuthorOperationException("The operation cannot be performed due to: wrong row content interval argument");
            }
            handled = true;
        }
        catch (IllegalArgumentException e) {
            logger.warn("Delete row failed.", (Throwable)e);
        }
        catch (BadLocationException e) {
            logger.warn("Delete row failed.", (Throwable)e);
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
        return handled;
    }

    public AuthorElement getTableElementContainingOffset(AuthorAccess access, int offset) {
        String[] tableClassValues = new String[]{" topic/simpletable ", " topic/table "};
        return TableOperationsUtil.getTableElementContainingOffset(offset, access, tableClassValues);
    }

    public TableColumnSpecificationInformation getColumnSpecification(AuthorAccess authorAccess, AuthorElement tableElement, int columnIndex) {
        CALSTableColumnSpecificationInformation colspecInfo = null;
        Boolean isSimpleTableElem = null;
        try {
            isSimpleTableElem = DITAAuthorTableOperationsHandler.isSimpleTable(authorAccess, tableElement.getStartOffset() + 1);
        }
        catch (BadLocationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (isSimpleTableElem != null && !isSimpleTableElem.booleanValue()) {
            CALSColSpec colSpec;
            CALSTableCellInfoProvider cellInfoProvider = new CALSTableCellInfoProvider(false);
            cellInfoProvider.init(tableElement);
            Set<CALSColSpec> colSpecs = cellInfoProvider.getColSpecs();
            if (colSpecs.size() > columnIndex && (colSpec = colSpecs.toArray(new CALSColSpec[0])[columnIndex]) != null) {
                colspecInfo = new CALSTableColumnSpecificationInformation(colSpec.getColWidth(), colSpec.getColumnName());
            }
        }
        return colspecInfo;
    }

    public void handleRemoveInvalidColNamesFromTableCells(AuthorAccess authorAccess, AuthorElement tableElement, List<AuthorElement> cells) {
        if (tableElement != null && cells != null && !cells.isEmpty()) {
            Boolean isSimpleTableElem = null;
            try {
                isSimpleTableElem = DITAAuthorTableOperationsHandler.isSimpleTable(authorAccess, tableElement.getStartOffset() + 1);
            }
            catch (BadLocationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (isSimpleTableElem != null && !isSimpleTableElem.booleanValue()) {
                TableOperationsUtil.removeInvalidColNamesFromCALSTableCells(authorAccess, tableElement, cells);
            }
        }
    }

    public boolean handleAttributeChange(AuthorAccess authorAccess, AuthorElement currentElement, String attributeName, AttrValue newValue) {
        return TableOperationsUtil.handleColumnSpecAttributeChange(authorAccess, new DITATableDocumentTypeHelper(), currentElement, attributeName, newValue);
    }

    public boolean handlePasteRows(AuthorTableInsertRowArguments arguments) throws AuthorOperationException {
        boolean handled = false;
        try {
            AuthorAccess authorAccess = arguments.getAuthorAccess();
            boolean simpleTable = DITAAuthorTableOperationsHandler.isSimpleTable(authorAccess, arguments.getInsertOffset());
            if (!simpleTable) {
                AuthorDocumentFragment[] rowsFragments = arguments.getRowFragments();
                CALSDocumentTypeHelper calsDocumentTypeHelper = new CALSDocumentTypeHelper();
                calsDocumentTypeHelper.limitRowSpan(rowsFragments);
                int nuOfRows = rowsFragments.length;
                int[] offsets = new int[nuOfRows];
                for (int i = 0; i < nuOfRows; ++i) {
                    offsets[i] = arguments.getInsertOffset();
                }
                authorAccess.getDocumentController().insertMultipleFragments(this.getTableElementContainingOffset(authorAccess, arguments.getInsertOffset()), rowsFragments, offsets);
                handled = true;
            }
        }
        catch (BadLocationException e) {
            logger.warn("Paste rows failed.", (Throwable)e);
        }
        return handled;
    }

    public boolean handleCreateTable(AuthorTableArguments arguments) throws AuthorOperationException {
        boolean handled = false;
        if (this.insertTableOperation == null) {
            this.insertTableOperation = new InsertTableOperation();
        }
        if (arguments != null) {
            AuthorAccess authorAccess = arguments.getAuthorAccess();
            int rows = arguments.getRows();
            int cols = arguments.getColumns();
            TableInfo tableInfo = new TableInfo(null, rows, cols, false, false, null, 1, null, null, null, null);
            this.insertTableOperation.insertTable(null, true, authorAccess, null, null, tableInfo);
            handled = true;
        }
        return handled;
    }
}

