/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class TableCustomizer {
    private static final Logger logger = LoggerFactory.getLogger((String)TableCustomizer.class.getName());
    private static final String TABLE_CUSTOMIZER_OPTIONS_KEY = "TABLE_CUSTOMIZER_OPTIONS";
    protected TableInfo tableInfo;

    public TableInfo customizeTable(AuthorAccess authorAccess) {
        return this.customizeTable(authorAccess, -1, -1);
    }

    public TableInfo customizeTable(AuthorAccess authorAccess, int predefinedRowsCount, int predefinedColumnsCount) {
        return this.customizeTable(authorAccess, predefinedRowsCount, predefinedColumnsCount, 0);
    }

    protected abstract TableInfo showCustomizeTableDialog(AuthorAccess var1, int var2, int var3, int var4);

    public TableInfo customizeTable(AuthorAccess authorAccess, int predefinedRowsCount, int predefinedColumnsCount, int defaultTableModel) {
        TableInfo newTableInfo;
        if (this.tableInfo == null) {
            String tableCustomizerOptions = authorAccess.getOptionsStorage().getOption(TABLE_CUSTOMIZER_OPTIONS_KEY, null);
            this.tableInfo = TableCustomizer.getTableInfoObject(tableCustomizerOptions);
        }
        if ((newTableInfo = this.showCustomizeTableDialog(authorAccess, predefinedRowsCount, predefinedColumnsCount, defaultTableModel)) != null) {
            int oldRowsCount = -1;
            int oldColumnsCount = -1;
            if (predefinedColumnsCount > 0 && predefinedRowsCount > 0 && predefinedRowsCount != newTableInfo.getRowsNumber() && predefinedColumnsCount != newTableInfo.getColumnsNumber()) {
                if (this.tableInfo != null) {
                    oldRowsCount = this.tableInfo.getRowsNumber();
                    oldColumnsCount = this.tableInfo.getColumnsNumber();
                } else {
                    oldRowsCount = 3;
                    oldColumnsCount = 2;
                }
                this.tableInfo = new TableInfo(newTableInfo.getTitle(), oldRowsCount, oldColumnsCount, newTableInfo.isGenerateHeader(), newTableInfo.isGenerateFooter(), newTableInfo.getFrame(), newTableInfo.getTableModel(), newTableInfo.getColumnsWidthsType(), newTableInfo.getRowsep(), newTableInfo.getColsep(), newTableInfo.getAlign());
            } else {
                this.tableInfo = newTableInfo;
            }
            String serializedTableInfo = this.serializeTableCustomizerOptions();
            if (serializedTableInfo != null) {
                authorAccess.getOptionsStorage().setOption(TABLE_CUSTOMIZER_OPTIONS_KEY, serializedTableInfo);
            }
        }
        return newTableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TableInfo getTableInfoObject(String tableCustomizerOptions) {
        TableInfo tableInfoToRet = null;
        if (tableCustomizerOptions != null) {
            ObjectInputStream objectInputStream = null;
            try {
                byte[] data = DatatypeConverter.parseBase64Binary((String)tableCustomizerOptions);
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream(data));
                tableInfoToRet = (TableInfo)objectInputStream.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (objectInputStream != null) {
                    try {
                        objectInputStream.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return tableInfoToRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serializeTableCustomizerOptions() {
        String serializedOptions = null;
        ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
        ObjectOutputStream objOutStream = null;
        try {
            objOutStream = new ObjectOutputStream(byteArrayOutStream);
            objOutStream.writeObject(this.tableInfo);
            serializedOptions = DatatypeConverter.printBase64Binary((byte[])byteArrayOutStream.toByteArray());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (objOutStream != null) {
                try {
                    objOutStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return serializedOptions;
    }
}

