/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableColumnsInfo;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECCustomTableColumnInsertionDialog
extends TrayDialog {
    private TableColumnsInfo tableColumnsInfo;
    private int columns;
    private boolean insertAfter;
    private Spinner columnsSpinner;
    private Button beforeRadioButton;
    private Button afterRadioButton;
    private AuthorResourceBundle authorResourceBundle;

    protected ECCustomTableColumnInsertionDialog(Shell parentShell, AuthorResourceBundle authorResourceBundle) {
        super(parentShell);
        this.authorResourceBundle = authorResourceBundle;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.authorResourceBundle.getMessage("insert.table.columns.custom"));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        Label numberOfColumnsLabel = new Label(mainComposite, 0);
        numberOfColumnsLabel.setText(this.authorResourceBundle.getMessage("Number_of_columns") + ":");
        this.columnsSpinner = new Spinner(mainComposite, 2048);
        this.columnsSpinner.setValues(1, 1, Integer.MAX_VALUE, 0, 1, 1);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnsSpinner.setLayoutData((Object)gridData);
        this.columnsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ECCustomTableColumnInsertionDialog.this.columns = ECCustomTableColumnInsertionDialog.this.columnsSpinner.getSelection();
            }
        });
        this.columns = new TableColumnsInfo().getColumnsNumber();
        Label positionLabel = new Label(mainComposite, 0);
        positionLabel.setText(this.authorResourceBundle.getMessage("Position") + ":");
        Composite positionComposite = new Composite(mainComposite, 0);
        positionComposite.setLayout((Layout)new RowLayout());
        this.beforeRadioButton = new Button(positionComposite, 16);
        this.beforeRadioButton.setText(this.authorResourceBundle.getMessage("Before"));
        this.beforeRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = false;
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = false;
            }
        });
        this.afterRadioButton = new Button(positionComposite, 16);
        this.afterRadioButton.setText(this.authorResourceBundle.getMessage("After"));
        this.afterRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = true;
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                ECCustomTableColumnInsertionDialog.this.insertAfter = true;
            }
        });
        this.initialize();
        return mainComposite;
    }

    public TableColumnsInfo showDialog(TableColumnsInfo previousTableColumnsInfo) {
        this.tableColumnsInfo = previousTableColumnsInfo;
        if (0 == this.open()) {
            return new TableColumnsInfo(this.columns, this.insertAfter);
        }
        return null;
    }

    private void initialize() {
        if (this.tableColumnsInfo != null) {
            this.columns = this.tableColumnsInfo.getColumnsNumber();
            this.columnsSpinner.setSelection(this.columns);
            this.insertAfter = this.tableColumnsInfo.isInsertAfter();
            this.beforeRadioButton.setSelection(!this.insertAfter);
            this.afterRadioButton.setSelection(this.insertAfter);
        } else {
            TableColumnsInfo defaultInfo = new TableColumnsInfo();
            this.columns = defaultInfo.getColumnsNumber();
            this.columnsSpinner.setSelection(this.columns);
            this.insertAfter = defaultInfo.isInsertAfter();
            this.beforeRadioButton.setSelection(!this.insertAfter);
            this.afterRadioButton.setSelection(this.insertAfter);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(this.authorResourceBundle.getMessage("Insert"));
    }
}

