/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class SortUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SortUtil.class.getName());

    private SortUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static String detectXMLLangFrom(AuthorNode parent) {
        String toRet = null;
        if (parent != null) {
            if (parent.getType() == 0) {
                String langVal;
                AttrValue attrVal = ((AuthorElement)parent).getAttribute("xml:lang");
                String string = langVal = attrVal != null ? attrVal.getValue() : null;
                if (langVal == null) {
                    attrVal = ((AuthorElement)parent).getAttribute("lang");
                    String string2 = langVal = attrVal != null ? attrVal.getValue() : null;
                }
                toRet = langVal != null ? langVal : SortUtil.detectXMLLangFrom(parent.getParent());
            } else {
                toRet = SortUtil.detectXMLLangFrom(parent.getParent());
            }
        }
        return toRet;
    }

    static Date parseXsdDatetime(AuthorOperationException[] error, String dateString) {
        Date val1 = null;
        Calendar calendar = null;
        try {
            calendar = DatatypeConverter.parseDateTime((String)dateString);
        }
        catch (IllegalArgumentException e1) {
            try {
                calendar = DatatypeConverter.parseDate((String)dateString);
            }
            catch (IllegalArgumentException e2) {
                try {
                    calendar = DatatypeConverter.parseTime((String)dateString);
                }
                catch (IllegalArgumentException e3) {
                    error[0] = new AuthorOperationException("Unable to parse the following text value as a date:\n\"" + dateString + "\"", (Throwable)e3);
                }
            }
        }
        if (calendar != null) {
            long dateInMills = calendar.getTimeInMillis();
            val1 = new Date(dateInMills);
        }
        return val1;
    }

    static Date parseDate(AuthorOperationException[] error, String dateString, DateFormat dateTimeFormatter, DateFormat dateFormatter, DateFormat timeFormatter) {
        Date val1 = null;
        try {
            val1 = dateTimeFormatter.parse(dateString);
        }
        catch (ParseException e) {
            try {
                val1 = dateFormatter.parse(dateString);
            }
            catch (ParseException e1) {
                try {
                    val1 = timeFormatter.parse(dateString);
                }
                catch (ParseException e2) {
                    error[0] = new AuthorOperationException("Unable to parse the following text value as a date:\n\"" + dateString + "\"");
                }
            }
        }
        return val1;
    }

    static Double parseNumber(AuthorOperationException[] error, String number) {
        Double val1 = 0.0;
        if (number.isEmpty()) {
            val1 = Double.MIN_VALUE;
        } else {
            try {
                val1 = NumberParserUtil.parseDouble((String)number);
            }
            catch (NumberFormatException e) {
                LOGGER.debug((Object)e, (Throwable)e);
                error[0] = new AuthorOperationException("Unable to parse the following text value as a number:\n\"" + number + "\"", (Throwable)e);
            }
        }
        return val1;
    }
}

