/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.text.FormSelectedTextOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class CapitalizeWordsOperation
extends FormSelectedTextOperation {
    @Override
    protected boolean isDelimiterBeforeTextNode(AuthorAccess authorAccess, int contentOffset) throws BadLocationException, AuthorOperationException {
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        boolean toRet = false;
        CharSequence contentCharSequence = documentController.getContentCharSequence();
        --contentOffset;
        while (contentOffset >= 1) {
            char ch = contentCharSequence.charAt(contentOffset);
            if (ch == '\u0000') {
                OffsetInformation contentInformationAtOffset = documentController.getContentInformationAtOffset(contentOffset);
                AuthorNode nodeAtOffset = contentInformationAtOffset.getNodeForMarkerOffset();
                Styles styles = authorAccess.getEditorAccess().getStyles(nodeAtOffset);
                if (!styles.isInline()) {
                    toRet = true;
                    break;
                }
            } else {
                if (!this.isWordDelimiter(ch)) break;
                toRet = true;
                break;
            }
            --contentOffset;
        }
        return toRet;
    }

    @Override
    protected char[] processTextContent(char[] charArray, boolean isDelimiterBefore) {
        for (int i = 0; i < charArray.length; ++i) {
            char currentChar = charArray[i];
            if (this.isWordDelimiter(currentChar)) {
                isDelimiterBefore = true;
                continue;
            }
            if (isDelimiterBefore) {
                charArray[i] = Character.toUpperCase(currentChar);
            }
            isDelimiterBefore = false;
        }
        return charArray;
    }

    public String getDescription() {
        return "Capitalize the first letter of each word in the current selection.";
    }
}

