/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class JSOperation
implements AuthorOperation {
    private static final String ARGUMENT_SCRIPT = "script";

    public String getDescription() {
        return "Run Javascript code which calls AuthorAccess API by using the predefined field 'authorAccess'.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        block18: {
            Object scriptValue = args.getArgumentValue(ARGUMENT_SCRIPT);
            if (!(scriptValue instanceof String)) {
                throw new IllegalArgumentException("The argument \"script\" was not defined as a string object!");
            }
            String script = (String)scriptValue;
            Context cx = Context.enter();
            try {
                ScriptableObject globalScope = cx.initStandardObjects();
                String baseLocation = authorAccess.getUtilAccess().expandEditorVariables("${framework}", authorAccess.getEditorAccess().getEditorLocation());
                if (baseLocation == null || baseLocation.contains("${framework}")) {
                    baseLocation = authorAccess.getEditorAccess().getEditorLocation().toString();
                }
                URL commonScriptURL = new URL(new URL(baseLocation), "commons.js");
                try (InputStream commonIS2 = commonScriptURL.openStream();){
                    cx.evaluateReader((Scriptable)globalScope, (Reader)new InputStreamReader(commonIS2, StandardCharsets.UTF_8), commonScriptURL.toExternalForm(), 1, null);
                }
                catch (IOException commonIS2) {
                    // empty catch block
                }
                URL dummyScriptURL = new URL(new URL(baseLocation), "currentScript.js");
                cx.evaluateString((Scriptable)globalScope, script, dummyScriptURL.toString(), 1, null);
                Object wrappedDispatcher = Context.javaToJS((Object)authorAccess, (Scriptable)globalScope);
                ScriptableObject.defineProperty((Scriptable)globalScope, (String)"authorAccess", (Object)wrappedDispatcher, (int)13);
                Object fObj = globalScope.get("doOperation", (Scriptable)globalScope);
                if (fObj instanceof Function) {
                    ((Function)fObj).call(cx, (Scriptable)globalScope, (Scriptable)globalScope, new Object[0]);
                    break block18;
                }
                throw new AuthorOperationException("The script should have a \"doOperation\" function defined.");
            }
            catch (RhinoException ex) {
                throw new AuthorOperationException("Could not evaluate script: " + ex.getMessage(), (Throwable)ex);
            }
            catch (MalformedURLException e) {
                throw new AuthorOperationException("Could not evaluate script: " + e.getMessage(), (Throwable)e);
            }
            finally {
                Context.exit();
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCRIPT, 4, "The Javascript content to execute. It must have a function called doOperation() which can use the predefined variable \"authorAccess\".\nThe \"authorAccess\" variable has access to the entire Java API \"ro.sync.ecss.extensions.api.AuthorAccess\".");
        return new ArgumentDescriptor[]{argumentDescriptor};
    }
}

