/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.commons.operations.ElementLocationPath;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class GetCurrentElementSaxonExtension
extends ExtensionFunctionDefinition {
    private static final Logger logger = LoggerFactory.getLogger((String)GetCurrentElementSaxonExtension.class.getName());
    private final ElementLocationPath elementLocation;
    private NodeInfo cachedElement = null;

    public GetCurrentElementSaxonExtension(ElementLocationPath currentElementLocation) {
        this.elementLocation = currentElementLocation;
    }

    public StructuredQName getFunctionQName() {
        return new StructuredQName("oxy", "http://www.oxygenxml.com/ns/author/xpath-extension-functions", "current-element");
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[0];
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.OPTIONAL_NODE;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCallImpl();
    }

    private final class ExtensionFunctionCallImpl
    extends ExtensionFunctionCall {
        private ExtensionFunctionCallImpl() {
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            Item contextItem;
            if (GetCurrentElementSaxonExtension.this.cachedElement == null && (contextItem = context.getContextItem()) instanceof NodeInfo) {
                contextItem = ((NodeInfo)contextItem).getRoot();
                GetCurrentElementSaxonExtension.this.cachedElement = this.getNodeByLocation(contextItem, GetCurrentElementSaxonExtension.this.elementLocation);
            }
            return GetCurrentElementSaxonExtension.this.cachedElement != null ? GetCurrentElementSaxonExtension.this.cachedElement : EmptySequence.getInstance();
        }

        private NodeInfo getNodeByLocation(Item contextItem, ElementLocationPath elementLocation) {
            NodeInfo crtNode = ((NodeInfo)contextItem).getRoot();
            List<ElementLocationPath.ElementLocationPathComponent> parts = elementLocation.getPath();
            for (ElementLocationPath.ElementLocationPathComponent part : parts) {
                if (logger.isDebugEnabled()) {
                    logger.debug("XPath part: " + part);
                }
                crtNode = this.nextNode(crtNode, part);
            }
            return crtNode;
        }

        private NodeInfo nextNode(NodeInfo node, ElementLocationPath.ElementLocationPathComponent comp) {
            NodeInfo nextNode;
            if (comp instanceof ElementLocationPath.Root) {
                nextNode = this.getNthChild(node.getRoot(), 1);
            } else if (comp instanceof ElementLocationPath.Parent) {
                nextNode = node.getParent();
            } else if (comp instanceof ElementLocationPath.Child) {
                ElementLocationPath.Child childSelector = (ElementLocationPath.Child)comp;
                nextNode = this.getNthChild(node, childSelector.getIndex());
            } else {
                throw new IllegalArgumentException("XPath component not supported: " + comp.toXPath());
            }
            return nextNode;
        }

        private NodeInfo getNthChild(NodeInfo node, int n) {
            AxisIterator iter = node.iterateAxis(3, (NodePredicate)NodeKindTest.ELEMENT);
            NodeInfo child = null;
            for (int i = 0; i < n; ++i) {
                child = iter.next();
            }
            return child;
        }
    }
}

