/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import java.net.URL;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.ArraysUtil;
import ro.sync.basic.util.URLUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class MediaObjectsUtil {
    private static final String VIMEO_EMBEDDED_HOST = "player.vimeo.com";
    private static final String VIDYARD_EMBEDDED_HOST = "play.vidyard.com";
    private static final String VIMEO_HOST = "vimeo.com";
    private static final String YOUTUBE_HOST = "www.youtube.com";
    public static final String REFERENCE_ATTR_DATA = "data";
    public static final String REFERENCE_ATTR_DATAKEYREF = "datakeyref";
    public static final String[] MEDIA_AUDIO_EXTENSIONS = new String[]{"mp3", "wav", "pcm", "m4a", "aif", "aiff"};
    public static final String[] MEDIA_VIDEO_EXTENSIONS = new String[]{"mp4", "flv", "m4v", "avi", "wmv"};
    public static final String[] ALLOWED_MEDIA_EXTENSIONS = (String[])ArraysUtil.mergeArrays((Object)MEDIA_AUDIO_EXTENSIONS, (Object)MEDIA_VIDEO_EXTENSIONS, (int)ArraysUtil.getArrayLength((Object)MEDIA_AUDIO_EXTENSIONS));
    public static final String[] RECOGNIZED_MEDIA_HOSTS = new String[]{"www.youtube.com", "vimeo.com", "player.vimeo.com", "play.vidyard.com"};

    private MediaObjectsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean containsExtension(String extension, String[] allowedExtensions) {
        boolean isContained = false;
        for (int i = 0; i < allowedExtensions.length; ++i) {
            if (!extension.equalsIgnoreCase(allowedExtensions[i])) continue;
            isContained = true;
            break;
        }
        return isContained;
    }

    public static String detectOutputclass(String href) {
        String outputclass = "iframe";
        if (MediaObjectsUtil.isAudioReference(href)) {
            outputclass = "audio";
        } else if (MediaObjectsUtil.isVideoReference(href)) {
            outputclass = "video";
        }
        return outputclass;
    }

    public static boolean isMediaReference(URL url) {
        boolean isMediaRef = false;
        if (url != null) {
            String u = url.toExternalForm();
            String extension = URLUtil.getExtension((String)u);
            String host = url.getHost().toLowerCase();
            isMediaRef = MediaObjectsUtil.containsExtension(extension, ALLOWED_MEDIA_EXTENSIONS) || MediaObjectsUtil.isRecognizedAsMedia(host);
        }
        return isMediaRef;
    }

    public static boolean isEmbeddedContent(String url) {
        boolean toReturn = false;
        if (url != null) {
            String lowerCase = url.toLowerCase();
            boolean youTubeEmbedded = lowerCase.contains(".youtube.") && lowerCase.contains("embed");
            boolean vimeoEmbedded = lowerCase.contains(VIMEO_EMBEDDED_HOST);
            boolean vidyardEmbedded = lowerCase.contains(VIDYARD_EMBEDDED_HOST);
            toReturn = youTubeEmbedded || vimeoEmbedded || vidyardEmbedded;
        }
        return toReturn;
    }

    public static boolean isRecognizedAsMedia(String hostURL) {
        boolean accepted = false;
        for (int i = 0; i < RECOGNIZED_MEDIA_HOSTS.length; ++i) {
            if (!RECOGNIZED_MEDIA_HOSTS[i].equals(hostURL)) continue;
            accepted = true;
            break;
        }
        return accepted;
    }

    public static String correctMediaEmbeddedReference(String url) {
        String host;
        String corrected = url;
        URL convertToURL = null;
        try {
            convertToURL = URLUtil.convertToURL((String)url);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        String string = host = convertToURL != null ? convertToURL.getHost() : null;
        if (host != null && MediaObjectsUtil.isRecognizedAsMedia(host)) {
            if (YOUTUBE_HOST.equals(host) && corrected.contains("/watch?v=")) {
                corrected = corrected.replace("/watch?v=", "/embed/");
            } else if (VIMEO_HOST.equals(host) && corrected.contains("/vimeo.com/")) {
                corrected = corrected.replace("/vimeo.com/", "/player.vimeo.com/video/");
            }
        }
        return corrected;
    }

    public static boolean isAudioReference(String fileName) {
        String extension = URLUtil.getExtension((String)fileName);
        return MediaObjectsUtil.hasAudioFormat(extension);
    }

    public static boolean hasAudioFormat(String format) {
        return format != null && MediaObjectsUtil.containsExtension(format, MEDIA_AUDIO_EXTENSIONS);
    }

    public static boolean isVideoReference(String fileName) {
        String extension = URLUtil.getExtension((String)fileName);
        return MediaObjectsUtil.hasVideoFormat(extension);
    }

    public static boolean hasVideoFormat(String format) {
        return format != null && MediaObjectsUtil.containsExtension(format, MEDIA_VIDEO_EXTENSIONS);
    }
}

