/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import java.util.ArrayList;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.CIValue;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.ContextElement;
import ro.sync.contentcompletion.xml.SchemaManagerFilter;
import ro.sync.contentcompletion.xml.WhatAttributesCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatPossibleValuesHasAttributeContext;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLSchemaManagerFilter
implements SchemaManagerFilter {
    private String[] scriptTypes = new String[]{"text/javascript", "application/javascript", "text/ecmascript", "application/ecmascript", "application/json"};
    private String[] styleTypes = new String[]{"text/css"};

    public List<CIElement> filterElements(List<CIElement> elements, WhatElementsCanGoHereContext context) {
        return elements;
    }

    public List<CIAttribute> filterAttributes(List<CIAttribute> attributes, WhatAttributesCanGoHereContext context) {
        return attributes;
    }

    public List<CIValue> filterAttributeValues(List<CIValue> attributeValues, WhatPossibleValuesHasAttributeContext context) {
        block8: {
            ContextElement parentElement;
            if (context == null || (parentElement = context.getParentElement()) == null || !"type".equals(context.getAttributeName())) break block8;
            String qName = parentElement.getQName();
            String ns = parentElement.getNamespace();
            if ("http://www.w3.org/1999/xhtml".equals(ns)) {
                String localName = XHTMLSchemaManagerFilter.getLocalName(qName);
                if ("style".equals(localName)) {
                    if (attributeValues == null) {
                        attributeValues = new ArrayList<CIValue>();
                    }
                    for (String styleType : this.styleTypes) {
                        attributeValues.add(new CIValue(styleType));
                    }
                } else if ("script".equals(localName)) {
                    if (attributeValues == null) {
                        attributeValues = new ArrayList<CIValue>();
                    }
                    for (String scriptType : this.scriptTypes) {
                        attributeValues.add(new CIValue(scriptType));
                    }
                }
            }
        }
        return attributeValues;
    }

    public static String getLocalName(String qName) {
        int idx;
        String local = qName;
        if (qName != null && (idx = qName.lastIndexOf(58)) != -1) {
            local = qName.substring(idx + 1);
        }
        return local;
    }

    public List<CIValue> filterElementValues(List<CIValue> elementValues, Context context) {
        return elementValues;
    }

    public String getDescription() {
        return "XHTML implementation for adding type attribute values for script and style elements in content completion proposals list.";
    }
}

