/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.xhtml;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.link.ElementLocator;
import ro.sync.ecss.extensions.api.link.ElementLocatorException;
import ro.sync.ecss.extensions.api.link.ElementLocatorProvider;
import ro.sync.ecss.extensions.api.link.IDTypeVerifier;
import ro.sync.ecss.extensions.commons.XPointerElementLocator;
import ro.sync.ecss.extensions.xhtml.XHTMLElementLocator;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLElementLocatorProvider
implements ElementLocatorProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)XHTMLElementLocatorProvider.class.getName());

    public ElementLocator getElementLocator(IDTypeVerifier idVerifier, String link) {
        ElementLocator elementLocator = null;
        try {
            elementLocator = link.startsWith("element(") ? new XPointerElementLocator(idVerifier, link) : new XHTMLElementLocator(idVerifier, link);
        }
        catch (ElementLocatorException e) {
            logger.warn("Exception when create element locator for link: " + link + ". Cause: " + e, (Throwable)e);
        }
        return elementLocator;
    }

    public String getDescription() {
        return "XHTML implementation for locating elements based on a given link. \nThe following cases are covered: xinclude element scheme, ID based links and HTML anchor links.";
    }
}

