/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.ECPropertiesComposite;
import ro.sync.ecss.extensions.commons.table.properties.EditedTablePropertiesInfo;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.ui.EclipseHelpUtils;
import ro.sync.exml.workspace.api.util.ColorThemeUtilities;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECTablePropertiesCustomizerDialog
extends TrayDialog {
    private AuthorResourceBundle authorResourceBundle;
    private EditedTablePropertiesInfo editedTablePropertiesInfo;
    private TabFolder tabFolder;
    private EditedTablePropertiesInfo tableInfo = null;
    private ColorThemeUtilities colorThemeUtilities;
    private String helpPageID;

    public ECTablePropertiesCustomizerDialog(Shell parentFrame, AuthorResourceBundle authorResourceBundle, ColorThemeUtilities colorThemeUtilities) {
        this(parentFrame, authorResourceBundle, colorThemeUtilities, null);
    }

    public ECTablePropertiesCustomizerDialog(Shell parentFrame, AuthorResourceBundle authorResourceBundle, ColorThemeUtilities colorThemeUtilities, String helpPageID) {
        super(parentFrame);
        this.authorResourceBundle = authorResourceBundle;
        this.colorThemeUtilities = colorThemeUtilities;
        this.helpPageID = helpPageID;
        int style = 2144;
        style |= 0x10;
        this.setShellStyle(style |= 0x10000);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        EclipseHelpUtils.installHelp(newShell, this.helpPageID);
        newShell.setText(this.authorResourceBundle.getMessage("Table_properties"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        mainComposite.setLayout((Layout)layout);
        this.tabFolder = new TabFolder(mainComposite, 256);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        List<TabInfo> categories = this.editedTablePropertiesInfo.getCategories();
        EditedTablePropertiesInfo.TAB_TYPE selectedTab = this.editedTablePropertiesInfo.getSelectedTab();
        int tabToSelect = 0;
        for (int i = 0; i < categories.size(); ++i) {
            TabInfo tabInfo = categories.get(i);
            TabItem tabItem = new TabItem(this.tabFolder, 0);
            ECPropertiesComposite ecPropertiesComposite = new ECPropertiesComposite(this.tabFolder, tabInfo.getProperties(), tabInfo.getContextInfo(), this.authorResourceBundle, this.colorThemeUtilities);
            tabItem.setControl((Control)ecPropertiesComposite);
            tabItem.setText(this.authorResourceBundle.getMessage(tabInfo.getTabKey()));
            if (tabInfo.getTabKey().equals("Table") && selectedTab == EditedTablePropertiesInfo.TAB_TYPE.TABLE_TAB) {
                tabToSelect = i;
                continue;
            }
            if ((tabInfo.getTabKey().equals("Row") || tabInfo.getTabKey().equals("Rows")) && selectedTab == EditedTablePropertiesInfo.TAB_TYPE.ROW_TAB) {
                tabToSelect = i;
                continue;
            }
            if ((tabInfo.getTabKey().equals("Column") || tabInfo.getTabKey().equals("Columns")) && selectedTab == EditedTablePropertiesInfo.TAB_TYPE.COLUMN_TAB) {
                tabToSelect = i;
                continue;
            }
            if (!tabInfo.getTabKey().equals("Cell") && !tabInfo.getTabKey().equals("Cells") || selectedTab != EditedTablePropertiesInfo.TAB_TYPE.CELL_TAB) continue;
            tabToSelect = i;
        }
        this.tabFolder.setSelection(tabToSelect);
        return mainComposite;
    }

    protected void okPressed() {
        List<TabInfo> categories = this.editedTablePropertiesInfo.getCategories();
        ArrayList<TabInfo> modifications = new ArrayList<TabInfo>();
        for (int i = 0; i < this.tabFolder.getItemCount(); ++i) {
            TabItem item = this.tabFolder.getItem(i);
            ECPropertiesComposite panel = (ECPropertiesComposite)item.getControl();
            TabInfo tabInfo = categories.get(i);
            if (panel.getModifiedProperties().isEmpty()) continue;
            modifications.add(new TabInfo(tabInfo.getTabKey(), panel.getModifiedProperties(), tabInfo.getNodes()));
        }
        if (!modifications.isEmpty()) {
            this.tableInfo = new EditedTablePropertiesInfo(modifications);
        }
        super.okPressed();
    }

    public EditedTablePropertiesInfo getTablePropertiesInformation(EditedTablePropertiesInfo editedTablePropertiesInfo) {
        this.editedTablePropertiesInfo = editedTablePropertiesInfo;
        EditedTablePropertiesInfo tableInformation = null;
        if (this.open() == 0) {
            tableInformation = this.tableInfo;
        }
        return tableInformation;
    }
}

