/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.XHTMLConstants;
import ro.sync.ecss.extensions.commons.table.support.HTMLTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XHTMLDocumentTypeHelper
extends AbstractDocumentTypeHelper
implements XHTMLConstants {
    private static final String[] ROW_ELEMENT_NAMES = new String[]{"tr"};
    private static final String[] CELL_ELEMENT_NAMES = new String[]{"td", "th"};
    public static final String[] TABLE_ELEMENT_NAMES = new String[]{"table", "informaltable"};

    @Override
    public void checkTableColSpanIsDefined(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSpanSupport, AuthorElement cellElement) throws AuthorOperationException {
    }

    @Override
    public String[] getTableCellElementNames() {
        return CELL_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableElementLocalName() {
        return TABLE_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableRowElementNames() {
        return ROW_ELEMENT_NAMES;
    }

    @Override
    public AuthorTableCellSpanProvider getTableCellSpanProvider(AuthorElement tableElement) {
        HTMLTableCellInfoProvider tableSpanSupport = new HTMLTableCellInfoProvider();
        tableSpanSupport.init(tableElement);
        return tableSpanSupport;
    }

    @Override
    public void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement cellElement, int startCol, int endCol) {
        int colSpan = endCol - startCol + 1;
        if (colSpan > 1) {
            authorAccess.getDocumentController().setAttribute("colspan", new AttrValue(String.valueOf(colSpan)), cellElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("colspan", cellElement);
        }
    }

    @Override
    public void updateTableRowSpan(AuthorAccess authorAccess, AuthorElement cellElement, int rowSpan) {
        if (rowSpan > 1) {
            authorAccess.getDocumentController().setAttribute("rowspan", new AttrValue(String.valueOf(rowSpan)), cellElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("rowspan", cellElement);
        }
    }

    @Override
    public void updateTableColumnNumber(AuthorAccess authorAccess, AuthorElement tableElement, int colNum) {
    }

    @Override
    public void updateTableRowNumber(AuthorAccess authorAccess, AuthorElement tableElement, int rowsNumber) {
    }

    @Override
    public String[] getIgnoredColumnAttributes() {
        return new String[]{"rowspan", "colspan"};
    }

    @Override
    public String[] getIgnoredCellIDAttributes() {
        return new String[]{"xml:id", "id"};
    }

    @Override
    public String[] getIgnoredRowAttributes() {
        return new String[]{"rowspan"};
    }
}

