/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorTableAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.ECTableSplitCustomizerDialog;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.JoinOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SATableSplitCustomizerDialog;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public abstract class SplitOperationBase
extends AbstractTableOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)SplitOperationBase.class.getName());

    public SplitOperationBase(AuthorTableHelper tableHelper) {
        super(tableHelper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        block21: {
            try {
                AuthorNode fullySelectedNode;
                AuthorElement cell = null;
                if (authorAccess.getEditorAccess().hasSelection() && (fullySelectedNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null) {
                    cell = this.getElementAncestor(fullySelectedNode, 0);
                }
                if (cell == null) {
                    int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                    AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
                    cell = this.getElementAncestor(nodeAtCaret, 0);
                }
                if (cell != null) {
                    AuthorTableAccess tableAccess = authorAccess.getTableAccess();
                    int[] tableRowSpanIndices = tableAccess.getTableRowSpanIndices(cell);
                    int[] tableColSpanIndices = tableAccess.getTableColSpanIndices(cell);
                    int startRow = tableRowSpanIndices[0];
                    int endRow = tableRowSpanIndices[1];
                    int startColumn = tableColSpanIndices[0];
                    int endColumn = tableColSpanIndices[1];
                    int initialRowSpan = endRow - startRow + 1;
                    int initialColSpan = endColumn - startColumn + 1;
                    AuthorDocumentController controller = authorAccess.getDocumentController();
                    boolean hasInitialSpan = initialRowSpan > 1 || initialColSpan > 1;
                    int rowSpan = hasInitialSpan ? initialRowSpan : 20;
                    int colSpan = hasInitialSpan ? initialColSpan : 20;
                    int[] result = null;
                    int[] imposedSplitInfo = SplitOperationBase.getSplitInfoFromArguments(args);
                    if (imposedSplitInfo != null) {
                        result = new int[]{imposedSplitInfo[0], imposedSplitInfo[1]};
                    } else if (rowSpan == 2 && colSpan == 1 || rowSpan == 1 && colSpan == 2) {
                        result = new int[]{colSpan, rowSpan};
                    } else {
                        Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
                        if (Platform.STANDALONE == platform) {
                            SATableSplitCustomizerDialog saSplitDialog = new SATableSplitCustomizerDialog((Frame)authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), colSpan, rowSpan){

                                public String getHelpPageID() {
                                    return SplitOperationBase.this.getHelpPageID();
                                }
                            };
                            result = saSplitDialog.getSplitInformation();
                        } else if (Platform.ECLIPSE == platform) {
                            ECTableSplitCustomizerDialog ecTablePropertiesCustomizer = new ECTableSplitCustomizerDialog(authorAccess.getWorkspaceAccess().getParentFrame(), authorAccess.getAuthorResourceBundle(), colSpan, rowSpan, this.getHelpPageID());
                            result = ecTablePropertiesCustomizer.getSplitInformation();
                        }
                    }
                    if (result != null) {
                        AuthorElement tableElem = this.getElementAncestor((AuthorNode)cell, 2);
                        int nrOfColumnsForSplit = result[0];
                        int nrOfRowsForSplit = result[1];
                        if (nrOfRowsForSplit > 1 || nrOfColumnsForSplit > 1) {
                            if (hasInitialSpan) {
                                this.splitWithInitialSpan(authorAccess, cell, tableElem, initialRowSpan, initialColSpan, controller, nrOfColumnsForSplit, nrOfRowsForSplit);
                            } else {
                                this.splitNoInitialSpan(authorAccess, cell, tableElem, controller, nrOfColumnsForSplit - 1, nrOfRowsForSplit - 1);
                            }
                        }
                        ArrayList<ContentInterval> toSelect = new ArrayList<ContentInterval>();
                        int lastRowSpan = 0;
                        int lastColSpan = 0;
                        for (int i = 0; i < nrOfRowsForSplit; ++i) {
                            int startIntervalOffset = -1;
                            int endIntervalOffset = -1;
                            lastColSpan = 0;
                            int currentRowSpan = -1;
                            for (int j = 0; j < nrOfColumnsForSplit; ++j) {
                                AuthorElement cellToSelect = tableAccess.getTableCellAt(startRow + lastRowSpan + i, startColumn + lastColSpan + j, tableElem);
                                if (currentRowSpan == -1) {
                                    int[] rowSpanIndices = tableAccess.getTableRowSpanIndices(cell);
                                    int startCurrentRow = rowSpanIndices[0];
                                    int endCurrentRow = rowSpanIndices[1];
                                    currentRowSpan = endCurrentRow - startCurrentRow;
                                }
                                int[] colSpanIndices = tableAccess.getTableColSpanIndices(cell);
                                int startCurrentColumn = colSpanIndices[0];
                                int endCurrentColumn = colSpanIndices[1];
                                int initialCurrentColSpan = endCurrentColumn - startCurrentColumn;
                                lastColSpan += initialCurrentColSpan;
                                if (i == 0 && j == 0) {
                                    authorAccess.getEditorAccess().setCaretPosition(cellToSelect.getStartOffset());
                                }
                                if (j == 0) {
                                    startIntervalOffset = cellToSelect.getStartOffset();
                                }
                                endIntervalOffset = cellToSelect.getEndOffset() + 1;
                            }
                            lastRowSpan += currentRowSpan;
                            if (startIntervalOffset < 0 || endIntervalOffset < 0) continue;
                            toSelect.add(new ContentInterval(startIntervalOffset, endIntervalOffset));
                        }
                        authorAccess.getEditorAccess().getAuthorSelectionModel().addSelectionIntervals(toSelect, false);
                    }
                    break block21;
                }
                AuthorOperationException ex = new AuthorOperationException("The caret must be inside a table cell.");
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static int[] getSplitInfoFromArguments(ArgumentsMap args) {
        String splitInfoString;
        String[] split;
        int[] imposedSplitInfo = null;
        Object spltInfo = args.getArgumentValue("split_info");
        if (spltInfo instanceof String && (split = (splitInfoString = (String)spltInfo).split(",")).length == 2) {
            String rows = split[0].trim();
            String cols = split[1].trim();
            try {
                imposedSplitInfo = new int[]{NumberParserUtil.valueOfInteger((String)rows), NumberParserUtil.valueOfInteger((String)cols)};
            }
            catch (NumberFormatException e) {
                logger.error((Throwable)e);
            }
        }
        return imposedSplitInfo;
    }

    private void splitNoInitialSpan(AuthorAccess authorAccess, AuthorElement cell, AuthorElement tableElement, AuthorDocumentController controller, int nrOfColumnsForSplit, int nrOfRowsForSplit) throws BadLocationException, AuthorOperationException {
        AuthorElement tableCell;
        int i;
        String xPathExpression = authorAccess.getDocumentController().getXPathExpression(cell.getStartOffset());
        int insertOffset = cell.getEndOffset();
        HashSet<AuthorElement> columnCellsToJoin = null;
        HashSet<AuthorElement> rowCellsToJoin = null;
        AuthorTableAccess tableAccess = authorAccess.getTableAccess();
        int[] tableCellIndex = tableAccess.getTableCellIndex(cell);
        int rowIndex = tableCellIndex[0];
        int colIndex = tableCellIndex[1];
        if (nrOfRowsForSplit >= 1) {
            rowCellsToJoin = new HashSet<AuthorElement>();
            int numberOfColumns = tableAccess.getTableNumberOfColumns(tableElement);
            for (i = 0; i < numberOfColumns; ++i) {
                if (i == colIndex || (tableCell = tableAccess.getTableCellAt(rowIndex, i, tableElement)) == null) continue;
                rowCellsToJoin.add(tableCell);
            }
        }
        if (nrOfColumnsForSplit >= 1) {
            columnCellsToJoin = new HashSet<AuthorElement>();
            int numberOfRows = tableAccess.getTableRowCount(tableElement);
            for (i = 0; i < numberOfRows; ++i) {
                int[] tableColSpanIndices;
                if (i == rowIndex || (tableCell = tableAccess.getTableCellAt(i, colIndex, tableElement)) == null || (tableColSpanIndices = tableAccess.getTableColSpanIndices(tableCell))[1] != colIndex) continue;
                columnCellsToJoin.add(tableCell);
            }
        }
        this.getInsertRowOperation().insertRows(authorAccess, xPathExpression, cell.getNamespace(), (AuthorNode)cell, tableElement, nrOfRowsForSplit, "After");
        this.getInsertColumnOperation().insertColumns(authorAccess, tableElement, cell.getNamespace(), "After", insertOffset, nrOfColumnsForSplit);
        if (columnCellsToJoin != null || rowCellsToJoin != null) {
            try {
                int attributesCount;
                int[] cellIndex;
                JoinOperationBase joinOperation = this.getJoinOperation();
                if (columnCellsToJoin != null) {
                    for (AuthorElement elem : columnCellsToJoin) {
                        cellIndex = tableAccess.getTableCellIndex(elem);
                        int[] tableRowSpanIndices = tableAccess.getTableRowSpanIndices(elem);
                        int[] tableColSpanIndices = tableAccess.getTableColSpanIndices(elem);
                        int startRow = cellIndex[0];
                        int startCol = cellIndex[1];
                        int endRow = tableRowSpanIndices[1];
                        int endCol = startCol + nrOfColumnsForSplit + (tableColSpanIndices[1] - tableColSpanIndices[0]);
                        HashSet<AuthorElement> toJoin = new HashSet<AuthorElement>();
                        for (int i2 = startRow; i2 <= endRow; ++i2) {
                            for (int j = startCol; j <= endCol; ++j) {
                                AuthorElement nextCell = tableAccess.getTableCellAt(i2, j, tableElement);
                                if (nextCell == null) continue;
                                toJoin.add(nextCell);
                            }
                        }
                        if (toJoin.size() <= 1) continue;
                        joinOperation.joinCells(authorAccess, tableElement, new ArrayList<AuthorElement>(toJoin));
                    }
                }
                if (rowCellsToJoin != null) {
                    for (AuthorElement elem : rowCellsToJoin) {
                        cellIndex = tableAccess.getTableCellIndex(elem);
                        int[] tableColSpanIndices = tableAccess.getTableColSpanIndices(elem);
                        int startRow = cellIndex[0];
                        int startCol = cellIndex[1];
                        int endRow = startRow + nrOfRowsForSplit;
                        int endCol = tableColSpanIndices[1];
                        HashSet<AuthorElement> toJoin = new HashSet<AuthorElement>();
                        for (int i3 = startRow; i3 <= endRow; ++i3) {
                            for (int j = startCol; j <= endCol; ++j) {
                                AuthorElement nextCell = tableAccess.getTableCellAt(i3, j, tableElement);
                                if (nextCell == null) continue;
                                toJoin.add(nextCell);
                            }
                        }
                        if (toJoin.size() <= 1) continue;
                        joinOperation.joinCells(authorAccess, tableElement, new ArrayList<AuthorElement>(toJoin));
                    }
                }
                if ((attributesCount = cell.getAttributesCount()) > 0) {
                    int i4;
                    String[] skippedColumnAttributes = this.getIgnoredAttributesForColumnSplit();
                    String[] skippedRowAttributes = this.getIgnoredAttributesForRowSplit();
                    ArrayList<String> skippedAttributesList = null;
                    if (skippedColumnAttributes != null || skippedRowAttributes != null) {
                        skippedAttributesList = new ArrayList<String>();
                        if (skippedColumnAttributes != null) {
                            skippedAttributesList.addAll(Arrays.asList(skippedColumnAttributes));
                        }
                        if (skippedRowAttributes != null) {
                            skippedAttributesList.addAll(Arrays.asList(skippedRowAttributes));
                        }
                    }
                    LinkedHashMap<String, String> attrsToBeAdded = new LinkedHashMap<String, String>();
                    for (i4 = 0; i4 < attributesCount; ++i4) {
                        String attrName = cell.getAttributeAtIndex(i4);
                        AttrValue attrValue = cell.getAttribute(attrName);
                        if (!attrValue.isSpecified() || skippedAttributesList != null && skippedAttributesList.contains(attrName)) continue;
                        attrsToBeAdded.put(attrName, attrValue.getValue());
                    }
                    if (attrsToBeAdded.size() > 0) {
                        for (i4 = rowIndex; i4 <= rowIndex + nrOfRowsForSplit; ++i4) {
                            for (int j = colIndex; j <= colIndex + nrOfColumnsForSplit; ++j) {
                                AuthorElement cellFromSplit;
                                if (i4 == rowIndex && j == colIndex || (cellFromSplit = tableAccess.getTableCellAt(i4, j, tableElement)) == null) continue;
                                Set keySet = attrsToBeAdded.keySet();
                                for (String key : keySet) {
                                    controller.setAttribute(key, new AttrValue((String)attrsToBeAdded.get(key)), cellFromSplit);
                                }
                            }
                        }
                    }
                }
            }
            catch (AuthorOperationException e) {
                AuthorOperationException splitEx = new AuthorOperationException("The split operation cannot be completed.", (Throwable)e);
                logger.error((Object)e, (Throwable)e);
                splitEx.setOperationRejectedOnPurpose(e.isOperationRejectedOnPurpose());
                throw splitEx;
            }
        }
    }

    protected abstract InsertRowOperationBase getInsertRowOperation();

    protected abstract InsertColumnOperationBase getInsertColumnOperation();

    protected abstract JoinOperationBase getJoinOperation();

    private void splitWithInitialSpan(AuthorAccess authorAccess, AuthorElement cell, AuthorElement tableElem, int initialRowSpan, int initialColSpan, AuthorDocumentController controller, int nrOfColumnsForSplit, int nrOfRowsForSplit) throws BadLocationException, AuthorOperationException {
        int currentRowSpan = 0;
        AuthorElement firstSplitCellOnRow = cell;
        for (int i = 1; i <= nrOfRowsForSplit && firstSplitCellOnRow != null; ++i) {
            int[] location = authorAccess.getTableAccess().getTableCellIndex(firstSplitCellOnRow);
            if (i > 1) {
                int insertionOffset = this.findCellInsertionOffset(authorAccess, tableElem, location[0] + currentRowSpan, location[1]);
                if (insertionOffset != -1) {
                    AuthorDocumentFragment contentFragment = this.createEmptyCell(authorAccess, firstSplitCellOnRow, this.getIgnoredAttributesForRowSplit());
                    controller.insertFragment(insertionOffset, contentFragment);
                    AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(insertionOffset + 1);
                    firstSplitCellOnRow = this.getElementAncestor(nodeAtCaret, 0);
                } else {
                    AuthorOperationException ex = new AuthorOperationException("Could not determine the location where the split will occur.");
                    ex.setOperationRejectedOnPurpose(true);
                    throw ex;
                }
            }
            currentRowSpan = SplitOperationBase.determineCurrentSpan(currentRowSpan, nrOfRowsForSplit, initialRowSpan, i);
            this.tableHelper.updateTableRowSpan(authorAccess, firstSplitCellOnRow, currentRowSpan);
            int currentColSpan = 0;
            AuthorElement currentSplitCellOnColumn = firstSplitCellOnRow;
            for (int j = 1; j <= nrOfColumnsForSplit && currentSplitCellOnColumn != null; ++j) {
                if (j > 1) {
                    int insertOffset = currentSplitCellOnColumn.getEndOffset() + 1;
                    AuthorDocumentFragment emptyCellFragment = this.createEmptyCell(authorAccess, currentSplitCellOnColumn, this.getIgnoredAttributesForColumnSplit());
                    controller.insertFragment(insertOffset, emptyCellFragment);
                    AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(insertOffset + 1);
                    currentSplitCellOnColumn = this.getElementAncestor(nodeAtCaret, 0);
                }
                currentColSpan = SplitOperationBase.determineCurrentSpan(currentColSpan, nrOfColumnsForSplit, initialColSpan, j);
                this.updateColSpan(authorAccess, this.tableHelper.getTableCellSpanProvider(tableElem), currentSplitCellOnColumn, currentColSpan);
            }
        }
    }

    private static int determineCurrentSpan(int currentSpan, int countForSplit, int initialSpan, int i) {
        if (i == countForSplit) {
            currentSpan = initialSpan - currentSpan * (countForSplit - 1);
        } else {
            currentSpan = Math.round((float)initialSpan / (float)countForSplit);
            if (initialSpan - currentSpan * (countForSplit - 1) <= 0) {
                currentSpan = initialSpan / countForSplit;
            }
        }
        return currentSpan;
    }

    public String getDescription() {
        return "Split the selected table cell (or the cell at caret when there is no selection), if it spans over multiple rows or columns";
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor("split_info", 5, "", "${ask('', generic, '2,2')}")};
    }

    protected abstract String[] getIgnoredAttributesForRowSplit();

    protected abstract String[] getIgnoredAttributesForColumnSplit();

    private void updateColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement cell, int colSpan) throws AuthorOperationException {
        int[] cellColSpanIndices = authorAccess.getTableAccess().getTableColSpanIndices(cell);
        int startColumn = cellColSpanIndices[0] + 1;
        int endColumn = startColumn + colSpan - 1;
        this.tableHelper.updateTableColSpan(authorAccess, tableSupport, cell, startColumn, endColumn);
    }

    protected String getHelpPageID() {
        return null;
    }
}

