/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SATableCustomizerDialog
extends OKCancelDialog
implements TableCustomizerConstants {
    private static final int DEFAULT_NO_OF_COLS_FOR_PROPERTIES_TABLE = 3;
    protected JCheckBox titleCheckbox;
    protected JTextField titleTextField;
    protected JSpinner rowsSpinner;
    protected JSpinner columnsSpinner;
    protected JComboBox colWidthsCombobox;
    protected JCheckBox headerCheckbox;
    protected JCheckBox footerCheckbox;
    protected JComboBox frameCombo;
    protected JComboBox rowsepCombo;
    protected JComboBox colsepCombo;
    protected JComboBox alignCombo;
    private final boolean hasFooter;
    private final boolean hasFrameAttribute;
    private final boolean hasRowsepAttribute;
    private final boolean hasColsepAttribute;
    private final boolean hasAlignAttribute;
    private boolean showModelChooser;
    protected JRadioButton calsModelRadio;
    protected JRadioButton simpleOrHtmlModelRadio;
    protected JRadioButton propertiesModelRadio;
    protected final AuthorResourceBundle authorResourceBundle;
    private final int predefinedColumnsCount;
    private final int predefinedRowsCount;
    private final boolean choiceTableModel;
    private boolean isCalsTable;
    private final boolean isSimpleTableNotHtml;
    private boolean isPropertiesTable;
    private final SpinnerModel propertiesTableColSpinnerModel = new SpinnerNumberModel(3, 2, 3, 1);
    private final SpinnerModel defaultColSpinnerModel = new SpinnerNumberModel(2, 1, 100, 1);
    private boolean isSimpleOrHtmlTable;

    public SATableCustomizerDialog(Frame parentFrame, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(parentFrame, hasFooter, hasFrameAttribute, showModelChooser, false, false, false, false, false, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public SATableCustomizerDialog(Frame parentFrame, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModel, boolean innerCallsTable, boolean hasRowsepAttribute, boolean hasColsepAttribute, boolean hasAlignAttribute, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(parentFrame, hasFooter, hasFrameAttribute, showModelChooser, showSimpleModel, false, innerCallsTable, hasRowsepAttribute, hasColsepAttribute, hasAlignAttribute, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public SATableCustomizerDialog(Frame parentFrame, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModel, boolean choiceTableModel, boolean innerCallsTable, boolean hasRowsepAttribute, boolean hasColsepAttribute, boolean hasAlignAttribute, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(parentFrame, hasFooter, hasFrameAttribute, showModelChooser, showSimpleModel, choiceTableModel, true, innerCallsTable, hasRowsepAttribute, hasColsepAttribute, hasAlignAttribute, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public SATableCustomizerDialog(Frame parentFrame, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModel, boolean choiceTableModel, boolean isCalsTable, boolean innerCallsTable, boolean hasRowsepAttribute, boolean hasColsepAttribute, boolean hasAlignAttribute, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(parentFrame, hasFooter, hasFrameAttribute, showModelChooser, showSimpleModel, choiceTableModel, isCalsTable, false, false, false, innerCallsTable, hasRowsepAttribute, hasColsepAttribute, hasAlignAttribute, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public SATableCustomizerDialog(Frame parentFrame, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModel, boolean choiceTableModel, boolean isCalsTable, boolean isSimpleOrHtmlTable, boolean isPropertiesTableAccepted, boolean isPropertiesTable, boolean innerCallsTable, boolean hasRowsepAttribute, boolean hasColsepAttribute, boolean hasAlignAttribute, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        super(parentFrame, authorResourceBundle.getMessage(choiceTableModel ? "Insert_choice_table" : "Insert_table"), true);
        TableCustomizerConstants.ColumnWidthsType[] columnsWidths;
        int tableModelType;
        this.hasFooter = hasFooter;
        this.hasFrameAttribute = hasFrameAttribute;
        this.showModelChooser = showModelChooser;
        this.isSimpleTableNotHtml = showSimpleModel;
        this.choiceTableModel = choiceTableModel;
        this.isCalsTable = isCalsTable;
        this.isSimpleOrHtmlTable = isSimpleOrHtmlTable;
        this.isPropertiesTable = isPropertiesTable;
        this.hasRowsepAttribute = hasRowsepAttribute;
        this.hasColsepAttribute = hasColsepAttribute;
        this.hasAlignAttribute = hasAlignAttribute;
        this.authorResourceBundle = authorResourceBundle;
        this.predefinedRowsCount = predefinedRowsCount;
        this.predefinedColumnsCount = predefinedColumnsCount;
        this.setOkButtonText(authorResourceBundle.getMessage("Insert"));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 0;
        gridBagConstr.fill = 1;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.anchor = 17;
        gridBagConstr.gridwidth = 2;
        gridBagConstr.insets = new Insets(0, 0, 0, 0);
        JPanel modelPanel = new JPanel(new FlowLayout(0, 3, 2));
        modelPanel.setBorder(BorderFactory.createTitledBorder(authorResourceBundle.getMessage("Model")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.calsModelRadio = new JRadioButton("CALS");
        this.calsModelRadio.setName("CALS model");
        this.calsModelRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SATableCustomizerDialog.this.addValuesToFrameCombo(1);
                    SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(1));
                    SATableCustomizerDialog.this.colWidthsCombobox.setEnabled(true);
                    SATableCustomizerDialog.this.updateTitleState(true);
                    SATableCustomizerDialog.this.updateElementsState(true);
                    SATableCustomizerDialog.this.updateAlignState(true);
                }
            }
        });
        modelPanel.add(this.calsModelRadio);
        buttonGroup.add(this.calsModelRadio);
        if (!choiceTableModel) {
            if (showSimpleModel) {
                this.simpleOrHtmlModelRadio = new JRadioButton(authorResourceBundle.getMessage("Simple"));
                this.simpleOrHtmlModelRadio.setName("Simple table model");
                this.simpleOrHtmlModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(3));
                            SATableCustomizerDialog.this.addValuesToFrameCombo(3);
                            SATableCustomizerDialog.this.colWidthsCombobox.setEnabled(true);
                            SATableCustomizerDialog.this.updateTitleState(false);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(false);
                        }
                    }
                });
                modelPanel.add(this.simpleOrHtmlModelRadio);
                buttonGroup.add(this.simpleOrHtmlModelRadio);
            } else {
                this.simpleOrHtmlModelRadio = new JRadioButton("HTML");
                this.simpleOrHtmlModelRadio.setName("HTML model");
                this.simpleOrHtmlModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(0));
                            SATableCustomizerDialog.this.addValuesToFrameCombo(0);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(true);
                        }
                    }
                });
                modelPanel.add(this.simpleOrHtmlModelRadio);
                buttonGroup.add(this.simpleOrHtmlModelRadio);
            }
            if (isPropertiesTableAccepted) {
                this.propertiesModelRadio = new JRadioButton(authorResourceBundle.getMessage("Properties"));
                this.propertiesModelRadio.setName("Properties");
                this.propertiesModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            SATableCustomizerDialog.this.addValuesToFrameCombo(3);
                            SATableCustomizerDialog.this.colWidthsCombobox.setEnabled(false);
                            SATableCustomizerDialog.this.updateTitleState(false);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(false);
                            Integer cols = (Integer)SATableCustomizerDialog.this.columnsSpinner.getValue();
                            SATableCustomizerDialog.this.columnsSpinner.setModel(SATableCustomizerDialog.this.propertiesTableColSpinnerModel);
                            if (cols < 2 || cols > 3) {
                                cols = 3;
                            }
                            SATableCustomizerDialog.this.columnsSpinner.setValue(cols);
                        } else if (e.getStateChange() == 2) {
                            Object value = SATableCustomizerDialog.this.columnsSpinner.getValue();
                            SATableCustomizerDialog.this.columnsSpinner.setModel(SATableCustomizerDialog.this.defaultColSpinnerModel);
                            SATableCustomizerDialog.this.columnsSpinner.setValue(value);
                        }
                    }
                });
                modelPanel.add(this.propertiesModelRadio);
                buttonGroup.add(this.propertiesModelRadio);
            }
        } else {
            this.showModelChooser = false;
            modelPanel.setVisible(false);
        }
        int n = tableModelType = innerCallsTable ? 1 : 2;
        if (showModelChooser) {
            mainPanel.add((Component)modelPanel, gridBagConstr);
            tableModelType = 1;
        }
        if (!innerCallsTable && !choiceTableModel) {
            this.titleCheckbox = this.createTitleCheckbox();
            this.titleCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SATableCustomizerDialog.this.titleTextField.setEditable(SATableCustomizerDialog.this.titleCheckbox.isSelected());
                }
            });
            this.titleCheckbox.setBorder(BorderFactory.createEmptyBorder());
            this.titleCheckbox.getAccessibleContext().setAccessibleName("Create a title element for the table");
            ++gridBagConstr.gridy;
            gridBagConstr.gridx = 0;
            gridBagConstr.weightx = 0.0;
            gridBagConstr.gridwidth = 1;
            gridBagConstr.insets = new Insets(7, 0, 0, 0);
            gridBagConstr.fill = 0;
            mainPanel.add((Component)this.titleCheckbox, gridBagConstr);
            this.titleTextField = new JTextField();
            this.titleTextField.setName("Title text field");
            this.titleTextField.getAccessibleContext().setAccessibleName("Table Title");
            ++gridBagConstr.gridx;
            gridBagConstr.weightx = 1.0;
            gridBagConstr.fill = 2;
            gridBagConstr.insets = new Insets(7, 5, 0, 0);
            mainPanel.add((Component)this.titleTextField, gridBagConstr);
        }
        JPanel sizePanel = new JPanel(new GridLayout(1, 2));
        sizePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(authorResourceBundle.getMessage("Table_size")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        ++gridBagConstr.gridy;
        gridBagConstr.gridx = 0;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.fill = 2;
        gridBagConstr.gridwidth = 2;
        gridBagConstr.insets = new Insets(7, 0, 0, 0);
        mainPanel.add((Component)sizePanel, gridBagConstr);
        JPanel rowsPanel = new JPanel(new GridBagLayout());
        sizePanel.add(rowsPanel);
        JLabel rowsLabel = new JLabel(authorResourceBundle.getMessage("Rows") + ":");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        rowsPanel.add((Component)rowsLabel, c);
        this.rowsSpinner = new JSpinner();
        rowsLabel.setLabelFor(this.rowsSpinner);
        this.rowsSpinner.setName("Rows spinner");
        this.rowsSpinner.setModel(new SpinnerNumberModel(2, 1, 1000, 1));
        if (predefinedColumnsCount >= 0) {
            this.rowsSpinner.setValue(predefinedRowsCount);
        } else {
            this.rowsSpinner.setValue(3);
        }
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets.left = 5;
        c.insets.right = 8;
        rowsPanel.add((Component)this.rowsSpinner, c);
        JPanel columnsPanel = new JPanel(new GridBagLayout());
        sizePanel.add(columnsPanel);
        JLabel columnsLabel = new JLabel(authorResourceBundle.getMessage("Columns") + ":");
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 8, 0, 0);
        columnsPanel.add((Component)columnsLabel, c);
        this.columnsSpinner = new JSpinner();
        columnsLabel.setLabelFor(this.columnsSpinner);
        this.columnsSpinner.setName("Columns spinner");
        this.columnsSpinner.setModel(this.defaultColSpinnerModel);
        if (predefinedColumnsCount >= 0) {
            this.columnsSpinner.setValue(predefinedColumnsCount);
        } else {
            this.columnsSpinner.setValue(2);
        }
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets.left = 5;
        columnsPanel.add((Component)this.columnsSpinner, c);
        if (choiceTableModel) {
            this.columnsSpinner.setEnabled(false);
            this.columnsSpinner.setValue(2);
        }
        JPanel headerFooterPanel = new JPanel(new FlowLayout(0, 0, 0));
        gridBagConstr.gridx = 0;
        ++gridBagConstr.gridy;
        gridBagConstr.gridwidth = 2;
        gridBagConstr.weightx = 1.0;
        gridBagConstr.fill = 2;
        gridBagConstr.insets = new Insets(7, 0, 0, 0);
        mainPanel.add((Component)headerFooterPanel, gridBagConstr);
        this.headerCheckbox = new JCheckBox(authorResourceBundle.getMessage("Generate_table_header"));
        this.headerCheckbox.setName("Header checkbox");
        this.headerCheckbox.setBorder(BorderFactory.createEmptyBorder());
        headerFooterPanel.add(this.headerCheckbox);
        if (hasFooter) {
            headerFooterPanel.add(Box.createHorizontalStrut(16));
            this.footerCheckbox = new JCheckBox(authorResourceBundle.getMessage("Generate_table_footer"));
            this.footerCheckbox.setName("Footer checkbox");
            this.footerCheckbox.setBorder(BorderFactory.createEmptyBorder());
            headerFooterPanel.add(this.footerCheckbox);
        }
        if ((columnsWidths = this.getColumnWidthsSpecifications(tableModelType)) != null) {
            JLabel colWidthsLabel = new JLabel(authorResourceBundle.getMessage("Column_widths") + ":");
            gridBagConstr.gridx = 0;
            ++gridBagConstr.gridy;
            gridBagConstr.gridwidth = 1;
            gridBagConstr.weightx = 0.0;
            gridBagConstr.fill = 0;
            gridBagConstr.insets = new Insets(7, 0, 0, 0);
            mainPanel.add((Component)colWidthsLabel, gridBagConstr);
            this.colWidthsCombobox = new JComboBox();
            colWidthsLabel.setLabelFor(this.colWidthsCombobox);
            this.colWidthsCombobox.setName("Column Widths combo");
            final ListCellRenderer initRenderer = this.colWidthsCombobox.getRenderer();
            this.colWidthsCombobox.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String render = null;
                    if (TableCustomizerConstants.ColumnWidthsType.DYNAMIC_COL_WIDTHS == value) {
                        render = "dynamic";
                    } else if (TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS == value) {
                        render = "proportional";
                    }
                    if (TableCustomizerConstants.ColumnWidthsType.FIXED_COL_WIDTHS == value) {
                        render = "fixed";
                    }
                    return initRenderer.getListCellRendererComponent(list, render, index, isSelected, cellHasFocus);
                }
            });
            this.updateColumnsWidthsCombo(columnsWidths);
            ++gridBagConstr.gridx;
            gridBagConstr.weightx = 1.0;
            gridBagConstr.insets = new Insets(7, 5, 0, 0);
            gridBagConstr.fill = 2;
            mainPanel.add((Component)this.colWidthsCombobox, gridBagConstr);
        }
        if (hasFrameAttribute) {
            JLabel frameLabel = new JLabel(authorResourceBundle.getMessage("Frame") + ":");
            gridBagConstr.gridx = 0;
            ++gridBagConstr.gridy;
            gridBagConstr.gridwidth = 1;
            gridBagConstr.weightx = 0.0;
            gridBagConstr.insets = new Insets(7, 0, 0, 0);
            gridBagConstr.fill = 0;
            mainPanel.add((Component)frameLabel, gridBagConstr);
            this.frameCombo = new JComboBox();
            frameLabel.setLabelFor(this.frameCombo);
            this.frameCombo.setName("Frame combo");
            this.addValuesToFrameCombo(tableModelType);
            ++gridBagConstr.gridx;
            gridBagConstr.weightx = 1.0;
            gridBagConstr.insets.left = 5;
            gridBagConstr.fill = 2;
            mainPanel.add((Component)this.frameCombo, gridBagConstr);
        }
        if (hasRowsepAttribute) {
            JLabel rowsepLabel = new JLabel(authorResourceBundle.getMessage("Row_separator") + ":");
            gridBagConstr.gridx = 0;
            ++gridBagConstr.gridy;
            gridBagConstr.gridwidth = 1;
            gridBagConstr.weightx = 0.0;
            gridBagConstr.insets = new Insets(7, 0, 0, 0);
            gridBagConstr.fill = 0;
            mainPanel.add((Component)rowsepLabel, gridBagConstr);
            this.rowsepCombo = new JComboBox();
            rowsepLabel.setLabelFor(this.rowsepCombo);
            this.rowsepCombo.setName("Rowsep combo");
            this.addValuesToRowsepCombo(tableModelType);
            ++gridBagConstr.gridx;
            gridBagConstr.weightx = 1.0;
            gridBagConstr.insets.left = 5;
            gridBagConstr.fill = 2;
            mainPanel.add((Component)this.rowsepCombo, gridBagConstr);
        }
        if (hasColsepAttribute) {
            JLabel colsepLabel = new JLabel(authorResourceBundle.getMessage("Column_separator") + ":");
            gridBagConstr.gridx = 0;
            ++gridBagConstr.gridy;
            gridBagConstr.gridwidth = 1;
            gridBagConstr.weightx = 0.0;
            gridBagConstr.insets = new Insets(7, 0, 0, 0);
            gridBagConstr.fill = 0;
            mainPanel.add((Component)colsepLabel, gridBagConstr);
            this.colsepCombo = new JComboBox();
            colsepLabel.setLabelFor(this.colsepCombo);
            this.colsepCombo.setName("Colsep combo");
            this.addValuesToColsepCombo(tableModelType);
            ++gridBagConstr.gridx;
            gridBagConstr.weightx = 1.0;
            gridBagConstr.insets.left = 5;
            gridBagConstr.fill = 2;
            mainPanel.add((Component)this.colsepCombo, gridBagConstr);
        }
        if (hasAlignAttribute) {
            JLabel alignLabel = new JLabel(authorResourceBundle.getMessage("Alignment") + ":");
            gridBagConstr.gridx = 0;
            ++gridBagConstr.gridy;
            gridBagConstr.gridwidth = 1;
            gridBagConstr.weightx = 0.0;
            gridBagConstr.insets = new Insets(7, 0, 0, 0);
            gridBagConstr.fill = 0;
            mainPanel.add((Component)alignLabel, gridBagConstr);
            this.alignCombo = new JComboBox();
            alignLabel.setLabelFor(this.alignCombo);
            this.alignCombo.setName("Align combo");
            this.addValuesToAlignCombo(tableModelType);
            ++gridBagConstr.gridx;
            gridBagConstr.weightx = 1.0;
            gridBagConstr.insets.left = 5;
            gridBagConstr.fill = 2;
            mainPanel.add((Component)this.alignCombo, gridBagConstr);
        }
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setSize(340, this.getSize().height);
        this.setResizable(false);
    }

    protected void updateColumnsWidthsCombo(TableCustomizerConstants.ColumnWidthsType[] columnsWidthsSpecifications) {
        if (this.colWidthsCombobox != null) {
            Object previousSel = this.colWidthsCombobox.getSelectedItem();
            this.colWidthsCombobox.removeAllItems();
            int selIndex = -1;
            for (int i = 0; i < columnsWidthsSpecifications.length; ++i) {
                this.colWidthsCombobox.addItem(columnsWidthsSpecifications[i]);
                if (!columnsWidthsSpecifications[i].equals(previousSel)) continue;
                selIndex = i;
            }
            if (selIndex != -1) {
                this.colWidthsCombobox.setSelectedIndex(selIndex);
            }
        }
    }

    private void updateTitleState(boolean enabled) {
        if (this.titleCheckbox != null) {
            this.titleCheckbox.setEnabled(enabled);
            this.titleCheckbox.setSelected(enabled);
            this.titleTextField.setEditable(enabled && this.titleCheckbox.isSelected());
        }
    }

    private void updateElementsState(boolean enabled) {
        if (this.rowsepCombo != null) {
            this.rowsepCombo.setEnabled(enabled);
        }
        if (this.colsepCombo != null) {
            this.colsepCombo.setEnabled(enabled);
        }
    }

    private void updateAlignState(boolean enabled) {
        if (this.alignCombo != null) {
            this.alignCombo.setEnabled(enabled);
        }
    }

    protected abstract String[] getFrameValues(int var1);

    protected abstract String getDefaultFrameValue(int var1);

    protected abstract String[] getRowsepValues(int var1);

    protected abstract String getDefaultRowsepValue(int var1);

    protected abstract String[] getColsepValues(int var1);

    protected abstract String[] getAlignValues(int var1);

    protected abstract String getDefaultColsepValue(int var1);

    protected abstract String getDefaultAlignValue(int var1);

    protected abstract TableCustomizerConstants.ColumnWidthsType[] getColumnWidthsSpecifications(int var1);

    protected abstract JCheckBox createTitleCheckbox();

    private void addValuesToFrameCombo(int tableModelType) {
        Object sel = this.frameCombo.getSelectedItem();
        String[] frameValues = this.getFrameValues(tableModelType);
        this.frameCombo.removeAllItems();
        int selIndex = -1;
        for (int i = 0; i < frameValues.length; ++i) {
            this.frameCombo.addItem(frameValues[i]);
            if (frameValues[i] == null || !frameValues[i].equals(sel)) continue;
            selIndex = i;
        }
        if (selIndex != -1) {
            this.frameCombo.setSelectedIndex(selIndex);
        } else {
            this.frameCombo.setSelectedItem(this.getDefaultFrameValue(tableModelType));
        }
    }

    private void addValuesToRowsepCombo(int tableModelType) {
        String[] values = this.getRowsepValues(tableModelType);
        this.rowsepCombo.removeAllItems();
        for (int i = 0; i < values.length; ++i) {
            this.rowsepCombo.addItem(values[i]);
        }
        this.rowsepCombo.setSelectedItem(this.getDefaultRowsepValue(tableModelType));
    }

    private void addValuesToColsepCombo(int tableModelType) {
        String[] values = this.getColsepValues(tableModelType);
        this.colsepCombo.removeAllItems();
        for (int i = 0; i < values.length; ++i) {
            this.colsepCombo.addItem(values[i]);
        }
        this.colsepCombo.setSelectedItem(this.getDefaultColsepValue(tableModelType));
    }

    private void addValuesToAlignCombo(int tableModelType) {
        String[] values = this.getAlignValues(tableModelType);
        this.alignCombo.removeAllItems();
        for (int i = 0; i < values.length; ++i) {
            this.alignCombo.addItem(values[i]);
        }
        this.alignCombo.setSelectedItem(this.getDefaultAlignValue(tableModelType));
    }

    public TableInfo showDialog(TableInfo previousTableInfo) {
        this.initialize(previousTableInfo);
        super.setVisible(true);
        TableInfo tableInfo = null;
        if (this.getResult() == 1) {
            String title = null;
            if (this.titleCheckbox != null && this.titleCheckbox.isSelected()) {
                title = this.titleTextField.getText();
            }
            int rowsNumber = (Integer)this.rowsSpinner.getValue();
            int columnsNumber = (Integer)this.columnsSpinner.getValue();
            int tableModelType = this.getTableModelType();
            tableInfo = new TableInfo(title, rowsNumber, columnsNumber, this.headerCheckbox.isSelected(), this.hasFooter ? this.footerCheckbox.isSelected() : false, this.hasFrameAttribute ? (!"<unspecified>".equals(this.frameCombo.getSelectedItem()) ? (String)this.frameCombo.getSelectedItem() : null) : null, tableModelType, this.colWidthsCombobox != null ? (TableCustomizerConstants.ColumnWidthsType)((Object)this.colWidthsCombobox.getSelectedItem()) : null, this.hasRowsepAttribute ? (!"<unspecified>".equals(this.rowsepCombo.getSelectedItem()) ? (String)this.rowsepCombo.getSelectedItem() : null) : null, this.hasColsepAttribute ? (!"<unspecified>".equals(this.colsepCombo.getSelectedItem()) ? (String)this.colsepCombo.getSelectedItem() : null) : null, this.hasAlignAttribute ? (!"<unspecified>".equals(this.alignCombo.getSelectedItem()) ? (String)this.alignCombo.getSelectedItem() : null) : null);
        }
        return tableInfo;
    }

    protected int getTableModelType() {
        int tableModelType = 2;
        if (this.showModelChooser) {
            tableModelType = this.calsModelRadio.isSelected() ? 1 : (this.propertiesModelRadio != null && this.propertiesModelRadio.isSelected() ? 5 : (this.isSimpleTableNotHtml ? 3 : 0));
        } else if (this.choiceTableModel) {
            tableModelType = 4;
        }
        return tableModelType;
    }

    private void initialize(TableInfo previousTableInfo) {
        if (this.titleCheckbox != null) {
            this.titleTextField.setEditable(true);
            this.titleTextField.setText("");
        }
        if (this.choiceTableModel) {
            this.updateColumnsWidthsCombo(this.getColumnWidthsSpecifications(4));
            this.addValuesToFrameCombo(4);
        }
        if (previousTableInfo != null) {
            if (this.showModelChooser) {
                if (this.isCalsTable || previousTableInfo.getTableModel() == 1 && !this.isPropertiesTable && !this.isSimpleOrHtmlTable) {
                    this.calsModelRadio.setSelected(true);
                } else if (this.isSimpleOrHtmlTable || previousTableInfo.getTableModel() != 1 && previousTableInfo.getTableModel() != 5 && !this.isCalsTable && !this.isPropertiesTable) {
                    this.simpleOrHtmlModelRadio.setSelected(true);
                } else if (this.propertiesModelRadio != null && (this.isPropertiesTable || previousTableInfo.getTableModel() == 5 && !this.isCalsTable && !this.isSimpleOrHtmlTable)) {
                    this.propertiesModelRadio.setSelected(true);
                } else {
                    this.calsModelRadio.setSelected(true);
                }
            }
            if (this.titleCheckbox != null) {
                if (previousTableInfo.getTitle() != null) {
                    this.titleCheckbox.setSelected(true);
                } else {
                    this.titleCheckbox.setSelected(false);
                    this.titleTextField.setEditable(false);
                }
            }
            if (this.predefinedColumnsCount < 0 || this.predefinedRowsCount < 0) {
                this.rowsSpinner.setValue(previousTableInfo.getRowsNumber());
                int colsNumber = previousTableInfo.getColumnsNumber();
                if (!this.choiceTableModel) {
                    if (!(this.propertiesModelRadio == null || !this.isPropertiesTable && (previousTableInfo.getTableModel() != 5 || this.isCalsTable || this.isSimpleOrHtmlTable) || colsNumber >= 2 && colsNumber <= 3)) {
                        colsNumber = 3;
                    }
                    this.columnsSpinner.setValue(colsNumber);
                }
            }
            this.headerCheckbox.setSelected(previousTableInfo.isGenerateHeader());
            if (this.hasFooter) {
                this.footerCheckbox.setSelected(previousTableInfo.isGenerateFooter());
            }
            if (this.colWidthsCombobox != null) {
                this.colWidthsCombobox.setSelectedItem((Object)previousTableInfo.getColumnsWidthsType());
            }
            if (this.frameCombo != null) {
                if (previousTableInfo.getFrame() != null) {
                    this.frameCombo.setSelectedItem(previousTableInfo.getFrame());
                } else {
                    this.frameCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.rowsepCombo != null) {
                if (previousTableInfo.getRowsep() != null) {
                    this.rowsepCombo.setSelectedItem(previousTableInfo.getRowsep());
                } else {
                    this.rowsepCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.colsepCombo != null) {
                if (previousTableInfo.getColsep() != null) {
                    this.colsepCombo.setSelectedItem(previousTableInfo.getColsep());
                } else {
                    this.colsepCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.alignCombo != null) {
                if (previousTableInfo.getAlign() != null) {
                    this.alignCombo.setSelectedItem(previousTableInfo.getAlign());
                } else {
                    this.alignCombo.setSelectedItem("<unspecified>");
                }
            }
        } else {
            if (this.titleCheckbox != null) {
                this.titleCheckbox.setSelected(true);
            }
            if (this.showModelChooser) {
                if (this.isCalsTable) {
                    this.calsModelRadio.setSelected(true);
                } else if (this.isSimpleOrHtmlTable) {
                    this.simpleOrHtmlModelRadio.setSelected(true);
                } else if (this.isPropertiesTable) {
                    this.propertiesModelRadio.setSelected(true);
                } else {
                    this.calsModelRadio.setSelected(true);
                }
            }
            if (this.predefinedColumnsCount < 0 || this.predefinedRowsCount < 0) {
                this.rowsSpinner.setValue(3);
                if (this.isPropertiesTable) {
                    this.columnsSpinner.setValue(3);
                } else {
                    this.columnsSpinner.setValue(2);
                }
            }
            this.headerCheckbox.setSelected(true);
            if (this.hasFooter) {
                this.footerCheckbox.setSelected(false);
            }
        }
        if (this.titleCheckbox != null) {
            this.titleTextField.requestFocus();
        }
    }

    public JRadioButton getPropertiesModelRadio() {
        return this.propertiesModelRadio;
    }

    public JSpinner getColumnsSpinner() {
        return this.columnsSpinner;
    }

    public JCheckBox getHeaderCheckbox() {
        return this.headerCheckbox;
    }

    public JComboBox getColWidthsCombobox() {
        return this.colWidthsCombobox;
    }

    public JComboBox getFrameCombo() {
        return this.frameCombo;
    }

    public JComboBox getColsepCombo() {
        return this.colsepCombo;
    }

    public JComboBox getRowsepCombo() {
        return this.rowsepCombo;
    }

    public JComboBox getAlignCombo() {
        return this.alignCombo;
    }

    public JCheckBox getTitleCheckbox() {
        return this.titleCheckbox;
    }

    public JTextField getTitleTextField() {
        return this.titleTextField;
    }

    public JSpinner getRowsSpinner() {
        return this.rowsSpinner;
    }

    public JRadioButton getCalsModelRadio() {
        return this.calsModelRadio;
    }

    public JRadioButton getSimpleOrHtmlModelRadio() {
        return this.simpleOrHtmlModelRadio;
    }

    public JCheckBox getFooterCheckbox() {
        return this.footerCheckbox;
    }
}

