/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.SortCriteriaInformation;
import ro.sync.ecss.extensions.commons.sort.SortOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class DITAListSortOperation
extends SortOperation {
    public DITAListSortOperation() {
        super("Selected_items", "All_items");
    }

    @Override
    public AuthorElement getSortParent(int offset, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorElement sortParent;
        block4: {
            sortParent = null;
            try {
                AuthorNode nodeAtOffset;
                AttrValue classAttr;
                AuthorNode selectedNode;
                if (authorAccess.getEditorAccess().hasSelection() && (selectedNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null && selectedNode.getType() == 0 && (classAttr = ((AuthorElement)selectedNode).getAttribute("class")) != null && (classAttr.getValue().contains(" topic/ol ") || classAttr.getValue().contains(" topic/ul ") || classAttr.getValue().contains(" topic/sl ") || classAttr.getValue().contains(" topic/dl "))) {
                    sortParent = (AuthorElement)selectedNode;
                }
                if (sortParent != null) break block4;
                for (AuthorNode parentElement = nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(offset); parentElement != null && parentElement.getType() != 2; parentElement = parentElement.getParent()) {
                    AttrValue classAttr2;
                    if (parentElement.getType() != 0 || (classAttr2 = ((AuthorElement)parentElement).getAttribute("class")) == null || !classAttr2.getValue().contains(" topic/ol ") && !classAttr2.getValue().contains(" topic/ul ") && !classAttr2.getValue().contains(" topic/sl ") && !classAttr2.getValue().contains(" topic/dl ")) continue;
                    sortParent = (AuthorElement)parentElement;
                    break;
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return sortParent;
    }

    @Override
    public boolean isIgnored(AuthorNode node) {
        return node.getType() == 3 || node.getType() == 5;
    }

    @Override
    public void canBeSorted(AuthorElement parent, int[] selectedNonIgnoredChildrenInterval) throws AuthorOperationException {
    }

    @Override
    public String[] getSortKeysValues(AuthorNode node, SortCriteriaInformation sortInfo) throws AuthorOperationException {
        CriterionInformation[] criterionInfo = sortInfo.criteriaInfo;
        String[] values = null;
        if (node instanceof AuthorElement && criterionInfo.length > 0) {
            values = new String[1];
            AuthorElement authorElement = (AuthorElement)node;
            AttrValue classAttr = authorElement.getAttribute("class");
            if (classAttr != null && (classAttr.getValue().contains(" topic/li ") || classAttr.getValue().contains(" topic/sli ") || classAttr.getValue().contains(" topic/dlentry "))) {
                values[0] = this.getTextContentToSort(node);
            }
        }
        return values;
    }

    @Override
    public List<CriterionInformation> getSortCriteria(AuthorElement parent) throws AuthorOperationException {
        ArrayList<CriterionInformation> criteria = new ArrayList<CriterionInformation>();
        List<AuthorNode> children = this.getNonIgnoredChildren(parent);
        if (!children.isEmpty()) {
            criteria.add(new CriterionInformation(0, this.authorAccess.getAuthorResourceBundle().getMessage("List_item")));
        }
        return criteria;
    }

    @Override
    protected String getHelpPageID() {
        return "sort-list-items";
    }
}

