/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorNodeUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class MoveElementOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)MoveElementOperation.class.getName());
    private static final String ARGUMENT_SOURCE_LOCATION = "sourceLocation";
    private static final String ARGUMENT_DELETE_LOCATION = "deleteLocation";
    private static final String ARGUMENT_SURROUND_FRAGMENT = "surroundFragment";
    private static final String ARGUMENT_TARGET_LOCATION = "targetLocation";
    private static final String ARGUMENT_RELATIVE_LOCATION = "insertPosition";
    private static final String ARGUMENT_MOVE_ONLY_CONTENT = "moveOnlySourceContentNodes";
    private static final String ARGUMENT_PROCESS_CHANGE_MARKERS = "processTrackedChangesForXPathLocations";
    private static final String ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_IN_MOVED_CONTENT = "alwaysPreserveTrackedChangesInMovedContent";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[8];

    public MoveElementOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SOURCE_LOCATION, 2, "An XPath expression that identifies the node to be moved. If missing, the node at caret will be moved.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_MOVE_ONLY_CONTENT, 3, "Controls whether the source element is moved entirely or just its content (the content of a node consists in text, other nodes or both). If true, the copied fragment consists in just the content of the node identified by the argument 'sourceLocation'. If false, the entire node will be copied.", new String[]{"true", "false"}, "false");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_DELETE_LOCATION, 2, "An XPath expression that identifies the node to be removed. Optional. If missing, the node identified by 'sourceLocation' as being moved will be removed.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SURROUND_FRAGMENT, 1, "A string representation of an XML fragment. The moved node will be inserted in the first leaf will be this fragment and this fragment containing the moved node will be placed at the destination.");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_TARGET_LOCATION, 2, "An XPath expression that identifies the location where the node must be moved to.");
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_RELATIVE_LOCATION, 3, "The insert position relative to the node determined by the \"targetLocation\" XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
        this.arguments[6] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_PROCESS_CHANGE_MARKERS, 3, "When nodes are located via XPath, if you have nodes deleted with change tracking in the document they are considered as being present by default.\nBut if you set this argument to 'true', the nodes deleted with track changes will be ignored when the xpath locations are computed. ", new String[]{"true", "false"}, "false");
        this.arguments[7] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_IN_MOVED_CONTENT, 3, "Always preserve track changes in the moved content, regardless of the track changes state", new String[]{"true", "false"}, "false");
    }

    public String getDescription() {
        return "Moves an element to a different location. The element to move as well as the destination are provided through XPath expressions.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        boolean selectNode = false;
        String sourceLocation = (String)args.getArgumentValue(ARGUMENT_SOURCE_LOCATION);
        AuthorNode toMoveNode = null;
        boolean processTrackChanges = "true".equals(args.getArgumentValue(ARGUMENT_PROCESS_CHANGE_MARKERS));
        if (sourceLocation != null && sourceLocation.trim().length() > 0) {
            toMoveNode = MoveElementOperation.executeLocationXPath(authorAccess, sourceLocation, processTrackChanges);
        } else {
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            try {
                toMoveNode = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("To move " + toMoveNode);
        }
        if (authorAccess.getEditorAccess().getFullySelectedNode() == toMoveNode) {
            selectNode = true;
        }
        if (toMoveNode != null) {
            AuthorNode toDeleteNode = toMoveNode;
            String toDeleteLocation = (String)args.getArgumentValue(ARGUMENT_DELETE_LOCATION);
            if (toDeleteLocation != null && !toDeleteLocation.isEmpty()) {
                toDeleteNode = MoveElementOperation.executeLocationXPath(authorAccess, toDeleteLocation, processTrackChanges);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("To delete " + toDeleteNode);
            }
            MoveElementOperation.moveNode(toMoveNode, toDeleteNode, selectNode, authorAccess, args);
        }
    }

    private static void moveNode(AuthorNode toMoveNode, AuthorNode toDeleteNode, boolean selectNode, AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        block9: {
            String targetLocationXPath = (String)args.getArgumentValue(ARGUMENT_TARGET_LOCATION);
            if (targetLocationXPath != null) {
                String relativePosition = (String)args.getArgumentValue(ARGUMENT_RELATIVE_LOCATION);
                AuthorDocumentController ctrl = authorAccess.getDocumentController();
                try {
                    ctrl.beginCompoundEdit();
                    boolean moveOnlyContent = "true".equals(args.getArgumentValue(ARGUMENT_MOVE_ONLY_CONTENT));
                    boolean alwaysPreserveTrackedChanges = MoveElementOperation.isAlwaysPreserveTrackChangesTrue(args);
                    selectNode = moveOnlyContent ? false : selectNode;
                    AuthorDocumentFragment fragmentToMove = MoveElementOperation.getFragmentToMove(toMoveNode, ctrl, alwaysPreserveTrackedChanges, moveOnlyContent);
                    boolean processTrackChanges = "true".equals(args.getArgumentValue(ARGUMENT_PROCESS_CHANGE_MARKERS));
                    int insertionOffset = ctrl.getXPathLocationOffset(targetLocationXPath, relativePosition, processTrackChanges);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Insert location for fragment: " + insertionOffset);
                    }
                    if (insertionOffset != -1) {
                        if (toDeleteNode.getStartOffset() < insertionOffset && insertionOffset <= toDeleteNode.getEndOffset()) {
                            throw new AuthorOperationException("Trying to move inside the node that will be removed. Node to remove: " + toDeleteNode + ". Computed insertion offset " + insertionOffset);
                        }
                        MoveElementOperation.moveFragment(fragmentToMove, insertionOffset, selectNode, toDeleteNode, authorAccess, args);
                        break block9;
                    }
                    throw new AuthorOperationException("The XPath expression: " + targetLocationXPath + " - doesn't identify any node");
                }
                catch (BadLocationException e) {
                    throw new AuthorOperationException("Unable to move the element because of: ", (Throwable)e);
                }
                finally {
                    ctrl.endCompoundEdit();
                }
            }
            throw new AuthorOperationException("The argument 'targetLocation' was not specified.");
        }
    }

    private static AuthorDocumentFragment getFragmentToMove(AuthorNode toMoveNode, AuthorDocumentController ctrl, boolean alwaysPreserveTrackedChanges, boolean moveOnlyContent) throws BadLocationException {
        AuthorDocumentFragment fragmentToMove = null;
        int nodeStartOffset = toMoveNode.getStartOffset();
        int nodeEndOffset = toMoveNode.getEndOffset();
        if (moveOnlyContent) {
            if (nodeStartOffset + 1 != nodeEndOffset) {
                fragmentToMove = alwaysPreserveTrackedChanges ? ctrl.createDocumentFragment(nodeStartOffset + 1, nodeEndOffset - 1, true) : ctrl.createDocumentFragment(nodeStartOffset + 1, nodeEndOffset - 1);
            }
        } else {
            fragmentToMove = alwaysPreserveTrackedChanges ? ctrl.createDocumentFragment(nodeStartOffset, nodeEndOffset, true) : ctrl.createDocumentFragment(toMoveNode, true);
        }
        return fragmentToMove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveFragment(AuthorDocumentFragment fragmentToMove, int insertionOffset, boolean selectNode, AuthorNode toDeleteNode, AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException, BadLocationException {
        AuthorDocumentController ctrl = authorAccess.getDocumentController();
        boolean toggleTrackChanges = false;
        if (MoveElementOperation.isAlwaysPreserveTrackChangesTrue(args) && authorAccess.getReviewController().isTrackingChanges()) {
            authorAccess.getReviewController().toggleTrackChanges();
            toggleTrackChanges = true;
        }
        try {
            String fragment = (String)args.getArgumentValue(ARGUMENT_SURROUND_FRAGMENT);
            if (fragment != null) {
                selectNode = false;
                AuthorDocumentFragment xmlFragment = ctrl.createNewDocumentFragmentInContext(fragment, insertionOffset);
                ctrl.insertFragment(insertionOffset, xmlFragment);
                AuthorNode firstLeaf = AuthorNodeUtil.getFirstLeaf((AuthorDocumentFragment)xmlFragment);
                if (firstLeaf != null) {
                    insertionOffset += firstLeaf.getStartOffset() + 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Insert location for moved: " + insertionOffset);
                }
            }
            if (fragmentToMove != null) {
                ctrl.insertFragment(insertionOffset, fragmentToMove);
            }
        }
        finally {
            if (toggleTrackChanges) {
                authorAccess.getReviewController().toggleTrackChanges();
            }
        }
        Position insertPosition = ctrl.createPositionInContent(insertionOffset + 1);
        ctrl.deleteNode(toDeleteNode);
        if (selectNode) {
            AuthorNode toSelectNode = ctrl.getNodeAtOffset(insertPosition.getOffset());
            if (toSelectNode != null) {
                authorAccess.getEditorAccess().select(toSelectNode.getStartOffset(), toSelectNode.getEndOffset() + 1);
            }
        } else {
            authorAccess.getEditorAccess().setCaretPosition(insertPosition.getOffset());
        }
    }

    private static boolean isAlwaysPreserveTrackChangesTrue(ArgumentsMap args) {
        return "true".equals(args.getArgumentValue(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_IN_MOVED_CONTENT));
    }

    private static AuthorNode executeLocationXPath(AuthorAccess authorAccess, String xPathExpression, boolean processTrackChanges) throws AuthorOperationException {
        AuthorNode toReturn = null;
        AuthorNode[] locatedNodes = authorAccess.getDocumentController().findNodesByXPath(xPathExpression, null, true, true, true, processTrackChanges, XPathVersion.XPATH_3_0, true);
        if (locatedNodes.length > 0) {
            if (locatedNodes.length > 1) {
                logger.warn("More than one nodes identified by: " + xPathExpression + ". Only the first node will be processed");
            }
        } else {
            throw new AuthorOperationException("The XPath expression: " + xPathExpression + " - doesn't identify any node");
        }
        toReturn = locatedNodes[0];
        return toReturn;
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

