/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.imagemap;

import java.util.Arrays;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.imagemap.EditImageMapCore;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class EditImageMapWithSurroundCore
extends EditImageMapCore {
    @Override
    public final AuthorNode[] getNodesOfInterest(AuthorAccess authorAccess, AuthorNode interestNode, boolean doSurroundIfMissing) throws BadLocationException, AuthorOperationException {
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        String[] nodesOfInterestCriteria = this.getNodesOfInterestCriteria(documentController.getAuthorDocumentNode().getRootElement().getNamespace());
        String[] imageMapProps = Arrays.copyOf(nodesOfInterestCriteria, 1);
        String[] imageProps = Arrays.copyOfRange(nodesOfInterestCriteria, 1, 2);
        AuthorNode nodeToEdit = this.findNodeOfInterest(authorAccess, interestNode, imageMapProps);
        if (doSurroundIfMissing && nodeToEdit == null && (nodeToEdit = this.findNodeOfInterest(authorAccess, interestNode, imageProps)) != null) {
            String fragStart = nodesOfInterestCriteria[2];
            String fragEnd = nodesOfInterestCriteria[3];
            boolean needComplexSurround = this.needComplexSurround(nodeToEdit);
            if (needComplexSurround && nodesOfInterestCriteria.length == 6) {
                fragStart = nodesOfInterestCriteria[4];
                fragEnd = nodesOfInterestCriteria[5];
            }
            AuthorDocumentFragment frag = documentController.createDocumentFragment(nodeToEdit, true);
            documentController.deleteNode(nodeToEdit);
            String fragStr = documentController.serializeFragmentToXML(frag);
            documentController.insertXMLFragment(fragStart + fragStr + fragEnd, editorAccess.getCaretOffset());
            nodeToEdit = this.findNodeOfInterest(authorAccess, interestNode, imageMapProps);
        }
        if (nodeToEdit != null) {
            return new AuthorNode[]{nodeToEdit};
        }
        return null;
    }

    protected boolean needComplexSurround(AuthorNode nodeToEdit) {
        return false;
    }

    protected abstract String[] getNodesOfInterestCriteria(String var1);
}

