/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.csseditor.prettyprint;

import java.io.IOException;
import java.io.Writer;
import ro.sync.exml.editor.csseditor.prettyprint.OutputHandler;
import ro.sync.exml.editor.csseditor.prettyprint.ParseException;
import ro.sync.exml.editor.csseditor.prettyprint.Token;

public class CSSOutputHandler
implements OutputHandler {
    private final Writer writer;
    private boolean newLineLast;
    private String indent = "";
    private int newLineCount;
    private int nonWsCharCount;
    private boolean inComment;
    private boolean spaceWritten;
    private final boolean skipSpacesInComments;

    public CSSOutputHandler(Writer writer, String lineSeparator) {
        this.writer = writer;
        this.skipSpacesInComments = lineSeparator != null && lineSeparator.isEmpty();
    }

    @Override
    public void write(Token token) throws ParseException {
        switch (token.kind) {
            case 5: {
                this.inComment = true;
                this.spaceWritten = false;
                break;
            }
            case 6: {
                this.inComment = false;
                this.spaceWritten = false;
                break;
            }
        }
        this.write(token.image);
    }

    @Override
    public void fakeWrite(Token token) throws ParseException {
        this.write(token.image, true);
    }

    @Override
    public void write(String string) throws ParseException {
        this.write(string, false);
    }

    private void write(String string, boolean fake) throws ParseException {
        try {
            if (string.endsWith("\n")) {
                this.newLineLast = true;
                ++this.newLineCount;
            } else if (!string.trim().isEmpty()) {
                this.newLineLast = false;
                this.newLineCount = 0;
            }
            this.nonWsCharCount += CSSOutputHandler.countNonWSChars(string);
            if (!fake) {
                if (this.inComment) {
                    if (string.length() == 1 && Character.isWhitespace(string.charAt(0))) {
                        if (this.skipSpacesInComments) {
                            if (!this.spaceWritten) {
                                this.writer.write(32);
                                this.spaceWritten = true;
                            }
                        } else {
                            this.writer.write(string);
                        }
                    } else {
                        this.spaceWritten = false;
                        this.writer.write(string);
                    }
                } else {
                    this.writer.write(string);
                }
            }
        }
        catch (IOException e) {
            ParseException parseException = new ParseException("Could not write to output the value: '" + string + "'");
            parseException.initCause(e);
            throw parseException;
        }
    }

    private static int countNonWSChars(String string) {
        int nonWSCharsCounter = 0;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            ++nonWSCharsCounter;
        }
        return nonWSCharsCounter;
    }

    @Override
    public int getNewLineBeforeCount() {
        return this.newLineCount;
    }

    @Override
    public boolean isLastNewLine() {
        return this.newLineLast;
    }

    @Override
    public void setIndent(String indent) {
        this.indent = indent;
    }

    @Override
    public String getIndent() {
        return this.indent;
    }

    @Override
    public int getNonWhitespaceCharCount() {
        return this.nonWsCharCount;
    }
}

