/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer.include;

import java.io.File;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.Job;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.dita.dost.writer.include.IncludeText;
import org.dita.dost.writer.include.IncludeXml;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IncludeResolver
extends AbstractXMLFilter {
    public static final char[] XML_NEWLINE = new char[]{'\n'};
    private Deque<Boolean> ignoreDepth = new ArrayDeque<Boolean>();
    private final Deque<Deque<StackItem>> includeStack = new ArrayDeque<Deque<StackItem>>();
    private Configuration.Mode processingMode;

    public void write(File filename) throws DITAOTException {
        assert (filename.isAbsolute());
        this.setCurrentFile(filename.toURI());
        super.write(filename);
    }

    public void startDocument() throws SAXException {
        String mode = (String)this.params.get("processing-mode");
        this.processingMode = mode != null ? Configuration.Mode.valueOf((String)mode.toUpperCase()) : Configuration.Mode.LAX;
        ArrayDeque<StackItem> elementStack = new ArrayDeque<StackItem>();
        elementStack.push(new StackItem(null, true));
        this.includeStack.push(elementStack);
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        Deque<StackItem> elementStack = this.includeStack.pop();
        assert (elementStack.size() == 1);
        assert (this.includeStack.isEmpty());
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        Deque<StackItem> elementStack = this.includeStack.peek();
        StackItem stackItem = elementStack.peek();
        String cls = atts.getValue("class");
        if (Constants.TOPIC_INCLUDE.matches(cls) || Constants.PR_D_CODEREF.matches(cls)) {
            elementStack.push(new StackItem(cls, stackItem.include));
            boolean include = false;
            if (stackItem.include) {
                try {
                    URI hrefValue = URLUtils.toURI((String)atts.getValue("href"));
                    if (hrefValue != null) {
                        String parse;
                        this.logger.debug("Resolve " + localName + " " + this.currentFile.resolve(hrefValue));
                        this.checkIfCoderefIsOutsideDitaMapDir(atts.getValue("href"));
                        switch (parse = this.getParse(atts.getValue("parse"))) {
                            case "text": {
                                include = new IncludeText(this.job, this.currentFile, this.getContentHandler(), this.logger, this.processingMode).include(atts);
                                break;
                            }
                            case "xml": {
                                include = new IncludeXml(this.job, this.currentFile, this.getContentHandler(), this.logger).include(atts);
                                break;
                            }
                            default: {
                                this.logger.error("Unsupported include parse " + parse);
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            ArrayDeque<StackItem> childStack = new ArrayDeque<StackItem>();
            childStack.push(new StackItem(cls, include));
            this.includeStack.push(childStack);
        } else if (Constants.TOPIC_FALLBACK.matches(cls)) {
            assert (elementStack.size() == 1);
            elementStack.push(new StackItem(cls, stackItem.include));
        } else {
            elementStack.push(new StackItem(cls, stackItem.include));
            if (stackItem.include) {
                super.startElement(uri, localName, name, atts);
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        Deque<StackItem> elementStack = this.includeStack.peek();
        StackItem stackItem = elementStack.pop();
        if (Constants.TOPIC_INCLUDE.matches(stackItem.cls) || Constants.PR_D_CODEREF.matches(stackItem.cls)) {
            Deque<StackItem> pop = this.includeStack.pop();
            assert (pop.size() == 0);
            Deque<StackItem> parentStack = this.includeStack.peek();
            parentStack.pop();
        } else if (!Constants.TOPIC_FALLBACK.matches(stackItem.cls) && stackItem.include) {
            super.endElement(uri, localName, name);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        Deque<StackItem> elementStack = this.includeStack.peek();
        if (!elementStack.peek().include) {
            return;
        }
        super.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        Deque<StackItem> elementStack = this.includeStack.peek();
        if (!elementStack.peek().include) {
            return;
        }
        super.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        Deque<StackItem> elementStack = this.includeStack.peek();
        if (!elementStack.peek().include) {
            return;
        }
        super.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        Deque<StackItem> elementStack = this.includeStack.peek();
        if (!elementStack.peek().include) {
            return;
        }
        super.skippedEntity(name);
    }

    private String getParse(String value) {
        if (value == null) {
            return "text";
        }
        return value;
    }

    private void checkIfCoderefIsOutsideDitaMapDir(String href) throws Exception {
        URI tempTarget = this.currentFile.resolve(href);
        String allowExternalCodeRefsProp = (String)this.params.get("args.allow.external.coderefs");
        if (allowExternalCodeRefsProp == null || "no".equalsIgnoreCase(allowExternalCodeRefsProp) || "false".equalsIgnoreCase(allowExternalCodeRefsProp)) {
            boolean safeResource = false;
            if (tempTarget != null && "file".equals(tempTarget.getScheme())) {
                File file = this.tempToSrc(tempTarget);
                File ditaMapDir = new File(this.job.getProperty("user.input.dir"), this.job.getProperty("user.input.file")).getParentFile();
                if (file != null && ditaMapDir != null && file.getAbsolutePath().startsWith(ditaMapDir.getAbsolutePath())) {
                    safeResource = true;
                }
            }
            if (!safeResource) {
                throw new Exception("[OXYSC01E][ERROR] For security reasons, files outside the DITA map directory are not read. Please set the 'args.allow.external.coderefs' to 'true' to enable processing of external code files. The following file was not read: " + href);
            }
        }
    }

    private File tempToSrc(URI tempURI) {
        String rel = this.job.tempDir.toURI().relativize(tempURI).toString();
        Job.FileInfo fileInfo = (Job.FileInfo)this.job.getFileInfoMap().get(new File(rel));
        File srcfile = null;
        if (fileInfo != null) {
            srcfile = new File(fileInfo.src);
        } else {
            this.logger.warn("Cannot map " + tempURI + " to a source topic");
        }
        return srcfile;
    }

    private record StackItem(String cls, boolean include) {
    }
}

