/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.dita.dost.platform.InsertAction;
import org.dita.dost.util.FileUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

final class InsertAntActionRelative
extends InsertAction {
    private static final Map<String, String> RELATIVE_ATTRS = Map.of("import", "file", "lang", "filename");

    InsertAntActionRelative() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        AttributesImpl attrBuf = new AttributesImpl();
        int attLen = attributes.getLength();
        for (int i = 0; i < attLen; ++i) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (RELATIVE_ATTRS.containsKey(localName) && RELATIVE_ATTRS.get(localName).equals(name) && !FileUtils.isAbsolutePath((String)value)) {
                File currentFileFile = null;
                try {
                    URL currentFileURL = new URL(this.currentFile);
                    currentFileFile = new File(currentFileURL.toURI());
                }
                catch (MalformedURLException | URISyntaxException ex) {
                    currentFileFile = new File(this.currentFile);
                }
                File targetFile = new File(currentFileFile.getParentFile(), attributes.getValue(i));
                value = FileUtils.getRelativeUnixPath((String)((String)this.paramTable.get("template")), (String)targetFile.toString());
            } else {
                value = attributes.getValue(i);
            }
            attrBuf.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), value);
        }
        super.startElement(uri, localName, qName, attrBuf);
    }
}

