/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.Task;
import org.dita.dost.log.DITAOTAntLogger;
import org.dita.dost.log.DITAOTLogger;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ConvertLang
extends Task {
    private static final String ATTRIBUTE_FORMAT_VALUE_WINDOWS = "windows";
    private static final String ATTRIBUTE_FORMAT_VALUE_HTML = "html";
    private static final String tag1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String tag2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>[OPTIONS]";
    private static final String tag3 = "&lt;?xml version=\"1.0\" encoding=\"utf-8\"?&gt;";
    private static final String CODEPAGE_ISO_8859_1 = "iso-8859-1";
    private static final String CODEPAGE_ISO_8859_2 = "iso-8859-2";
    private static final String CODEPAGE_ISO_8859_7 = "iso-8859-7";
    private static final String CODEPAGE_1250 = "windows-1250";
    private static final String CODEPAGE_1252 = "windows-1252";
    private static final String CODEPAGE_1253 = "windows-1253";
    private String basedir;
    private String outputdir;
    private String message;
    private String langcode;
    private final Map<String, String> charsetMap = new HashMap<String, String>();
    private final Map<String, String> langMap = new HashMap<String, String>();
    private final Map<String, String> entityMap = new HashMap<String, String>();
    private Set<Integer> entityExceptionSet;
    private String exceptionCharset;
    private DITAOTLogger logger;
    private XMLUtils xmlUtils;

    public void execute() {
        this.logger = new DITAOTAntLogger(this.getProject());
        this.logger.info(this.message);
        if (!new File(this.outputdir).isAbsolute()) {
            this.outputdir = new File(this.basedir, this.outputdir).getAbsolutePath();
        }
        this.createLangMap();
        this.createEntityMap();
        this.entityExceptionSet = new HashSet<Integer>(128);
        this.createCharsetMap();
        this.convertHtmlCharset();
        this.updateAllEntitiesAndLangs();
    }

    private void createLangMap() {
        Properties entities = new Properties();
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/dita/dost/util/languages.properties");){
            entities.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read language property file: " + e.getMessage(), e);
        }
        for (Map.Entry<Object, Object> e : entities.entrySet()) {
            this.langMap.put((String)e.getKey(), (String)e.getValue());
        }
    }

    private void createEntityMap() {
        Properties entities = new Properties();
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/dita/dost/util/entities.properties");){
            entities.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read entities property file: " + e.getMessage(), e);
        }
        for (Map.Entry<Object, Object> e : entities.entrySet()) {
            this.entityMap.put((String)e.getKey(), (String)e.getValue());
        }
    }

    private void createCharsetMap() {
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/dita/dost/util/codepages.xml");){
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element e;
                String lang;
                Node node = childNodes.item(i);
                if (node.getNodeType() != 1 || !this.langcode.equalsIgnoreCase(lang = (e = (Element)node).getAttribute("lang")) && !lang.startsWith(this.langcode)) continue;
                NodeList subChild = e.getChildNodes();
                for (int j = 0; j < subChild.getLength(); ++j) {
                    Node subNode = subChild.item(j);
                    if (subNode.getNodeType() != 1) continue;
                    Element elem = (Element)subNode;
                    String format = elem.getAttribute("format");
                    String charset = elem.getAttribute("charset");
                    this.charsetMap.put(format, charset);
                }
                break;
            }
            if (this.charsetMap.size() == 0) {
                this.charsetMap.put(ATTRIBUTE_FORMAT_VALUE_HTML, CODEPAGE_ISO_8859_1);
                this.charsetMap.put(ATTRIBUTE_FORMAT_VALUE_WINDOWS, CODEPAGE_1252);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read charset configuration file: " + e.getMessage(), e);
        }
    }

    private String replaceXmlTag(String source, String tag) {
        int startPos = source.indexOf(tag);
        int endPos = startPos + tag.length();
        return source.substring(0, startPos) + source.substring(endPos);
    }

    private void convertHtmlCharset() {
        File outputDir = new File(this.outputdir);
        File[] files = outputDir.listFiles();
        if (files != null) {
            for (File file : files) {
                this.convertCharset(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertCharset(File inputFile) {
        block33: {
            block32: {
                if (!inputFile.isDirectory()) break block32;
                File[] files = inputFile.listFiles();
                if (files == null) break block33;
                for (File file : files) {
                    this.convertCharset(file);
                }
                break block33;
            }
            if (!org.dita.dost.util.FileUtils.isHTMLFile((String)inputFile.getName()) && !org.dita.dost.util.FileUtils.isHHCFile((String)inputFile.getName()) && !org.dita.dost.util.FileUtils.isHHKFile((String)inputFile.getName())) break block33;
            String fileName = inputFile.getAbsolutePath();
            File outputFile = new File(fileName + ".temp");
            this.log("Processing " + fileName, 2);
            BufferedReader reader = null;
            Writer writer = null;
            try {
                FileInputStream inputStream = new FileInputStream(inputFile);
                InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                reader = new BufferedReader(streamReader);
                FileOutputStream outputStream = new FileOutputStream(outputFile);
                OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8);
                writer = new BufferedWriter(streamWriter);
                String value = reader.readLine();
                while (value != null) {
                    if (value.contains("<meta http-equiv") && value.contains("charset")) {
                        int insertPoint = value.indexOf("charset=") + "charset=".length();
                        String subString = value.substring(0, insertPoint);
                        int remainIndex = value.indexOf("UTF-8") + "UTF-8".length();
                        String remainString = value.substring(remainIndex);
                        String newValue = org.dita.dost.util.FileUtils.isHHCFile((String)inputFile.getName()) || org.dita.dost.util.FileUtils.isHHKFile((String)inputFile.getName()) ? subString + this.charsetMap.get(ATTRIBUTE_FORMAT_VALUE_WINDOWS) + remainString : subString + this.charsetMap.get(ATTRIBUTE_FORMAT_VALUE_HTML) + remainString;
                        writer.write(newValue);
                        writer.write(Constants.LINE_SEPARATOR);
                    } else {
                        if (value.contains(tag1)) {
                            value = this.replaceXmlTag(value, tag1);
                        } else if (value.contains(tag2)) {
                            value = this.replaceXmlTag(value, tag2);
                        } else if (value.contains(tag3)) {
                            value = this.replaceXmlTag(value, tag3);
                        }
                        writer.write(value);
                        writer.write(Constants.LINE_SEPARATOR);
                    }
                    value = reader.readLine();
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        this.logger.error("Failed to close input stream: " + e.getMessage());
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        this.logger.error("Failed to close output stream: " + e.getMessage());
                    }
                }
            }
            try {
                FileUtils.deleteQuietly((File)inputFile);
                FileUtils.moveFile((File)outputFile, (File)inputFile);
            }
            catch (Exception e) {
                this.logger.error("Failed to replace " + inputFile + ": " + e.getMessage());
            }
        }
    }

    private void updateAllEntitiesAndLangs() {
        File outputDir = new File(this.outputdir);
        File[] files = outputDir.listFiles();
        if (files != null) {
            for (File file : files) {
                this.updateEntityAndLang(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateEntityAndLang(File inputFile) {
        if (inputFile.isDirectory()) {
            File[] files = inputFile.listFiles();
            if (files == null) return;
            for (File file : files) {
                this.updateEntityAndLang(file);
            }
            return;
        }
        if (org.dita.dost.util.FileUtils.isHTMLFile((String)inputFile.getName())) {
            this.convertEntityAndCharset(inputFile, ATTRIBUTE_FORMAT_VALUE_HTML);
            return;
        }
        if (!org.dita.dost.util.FileUtils.isHHPFile((String)inputFile.getName()) && !org.dita.dost.util.FileUtils.isHHCFile((String)inputFile.getName()) && !org.dita.dost.util.FileUtils.isHHKFile((String)inputFile.getName())) return;
        this.convertEntityAndCharset(inputFile, ATTRIBUTE_FORMAT_VALUE_WINDOWS);
        String fileName = inputFile.getAbsolutePath();
        File outputFile = new File(fileName + ".temp");
        String charset = this.charsetMap.get(ATTRIBUTE_FORMAT_VALUE_WINDOWS);
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            FileInputStream inputStream = new FileInputStream(inputFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, charset);
            reader = new BufferedReader(streamReader);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
            writer = new BufferedWriter(streamWriter);
            String value = reader.readLine();
            while (value != null) {
                if (value.contains(tag1)) {
                    value = this.replaceXmlTag(value, tag1);
                } else if (value.contains(tag2)) {
                    value = this.replaceXmlTag(value, tag2);
                } else if (value.contains(tag3)) {
                    value = this.replaceXmlTag(value, tag3);
                }
                if (value.contains("Language=")) {
                    String newValue = this.langMap.get(this.langcode);
                    if (newValue == null) {
                        newValue = this.langMap.get(this.langcode.split("-")[0]);
                    }
                    if (newValue == null) throw new IllegalArgumentException("Unsupported language code '" + this.langcode + "', unable to map to a Locale ID.");
                    writer.write("Language=" + newValue);
                    writer.write(Constants.LINE_SEPARATOR);
                } else {
                    writer.write(value);
                    writer.write(Constants.LINE_SEPARATOR);
                }
                value = reader.readLine();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close input stream: " + e.getMessage());
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close output stream: " + e.getMessage());
                }
            }
        }
        try {
            FileUtils.deleteQuietly((File)inputFile);
            FileUtils.moveFile((File)outputFile, (File)inputFile);
            return;
        }
        catch (Exception e) {
            this.logger.error("Failed to replace " + inputFile + ": " + e.getMessage());
        }
    }

    private void updateExceptionCharacters(String charset) {
        if (this.exceptionCharset != null && this.exceptionCharset.equals(charset)) {
            return;
        }
        this.exceptionCharset = charset;
        if (!this.entityExceptionSet.isEmpty()) {
            this.entityExceptionSet.clear();
        }
        if (charset.equals(CODEPAGE_ISO_8859_2) || charset.equals(CODEPAGE_1250) || charset.equals(CODEPAGE_ISO_8859_1) || charset.equals(CODEPAGE_1252)) {
            this.entityExceptionSet.add(193);
            this.entityExceptionSet.add(225);
            this.entityExceptionSet.add(194);
            this.entityExceptionSet.add(226);
            this.entityExceptionSet.add(196);
            this.entityExceptionSet.add(228);
            this.entityExceptionSet.add(199);
            this.entityExceptionSet.add(231);
            this.entityExceptionSet.add(201);
            this.entityExceptionSet.add(233);
            this.entityExceptionSet.add(203);
            this.entityExceptionSet.add(235);
            this.entityExceptionSet.add(205);
            this.entityExceptionSet.add(237);
            this.entityExceptionSet.add(206);
            this.entityExceptionSet.add(238);
            this.entityExceptionSet.add(211);
            this.entityExceptionSet.add(243);
            this.entityExceptionSet.add(212);
            this.entityExceptionSet.add(244);
            this.entityExceptionSet.add(214);
            this.entityExceptionSet.add(246);
            this.entityExceptionSet.add(218);
            this.entityExceptionSet.add(250);
            this.entityExceptionSet.add(220);
            this.entityExceptionSet.add(252);
            this.entityExceptionSet.add(221);
            this.entityExceptionSet.add(253);
            this.entityExceptionSet.add(223);
            this.entityExceptionSet.add(215);
        }
        switch (charset) {
            case "iso-8859-1": 
            case "windows-1252": {
                this.entityExceptionSet.add(192);
                this.entityExceptionSet.add(224);
                this.entityExceptionSet.add(195);
                this.entityExceptionSet.add(227);
                this.entityExceptionSet.add(197);
                this.entityExceptionSet.add(229);
                this.entityExceptionSet.add(198);
                this.entityExceptionSet.add(230);
                this.entityExceptionSet.add(200);
                this.entityExceptionSet.add(232);
                this.entityExceptionSet.add(202);
                this.entityExceptionSet.add(234);
                this.entityExceptionSet.add(204);
                this.entityExceptionSet.add(236);
                this.entityExceptionSet.add(207);
                this.entityExceptionSet.add(239);
                this.entityExceptionSet.add(208);
                this.entityExceptionSet.add(240);
                this.entityExceptionSet.add(209);
                this.entityExceptionSet.add(241);
                this.entityExceptionSet.add(210);
                this.entityExceptionSet.add(242);
                this.entityExceptionSet.add(213);
                this.entityExceptionSet.add(245);
                this.entityExceptionSet.add(216);
                this.entityExceptionSet.add(248);
                this.entityExceptionSet.add(217);
                this.entityExceptionSet.add(249);
                this.entityExceptionSet.add(219);
                this.entityExceptionSet.add(251);
                this.entityExceptionSet.add(222);
                this.entityExceptionSet.add(254);
                this.entityExceptionSet.add(255);
                break;
            }
            case "iso-8859-2": 
            case "windows-1250": {
                this.entityExceptionSet.add(352);
                this.entityExceptionSet.add(353);
                break;
            }
            case "iso-8859-7": 
            case "windows-1253": {
                this.entityExceptionSet.add(913);
                this.entityExceptionSet.add(945);
                this.entityExceptionSet.add(914);
                this.entityExceptionSet.add(946);
                this.entityExceptionSet.add(915);
                this.entityExceptionSet.add(947);
                this.entityExceptionSet.add(916);
                this.entityExceptionSet.add(948);
                this.entityExceptionSet.add(917);
                this.entityExceptionSet.add(949);
                this.entityExceptionSet.add(918);
                this.entityExceptionSet.add(950);
                this.entityExceptionSet.add(919);
                this.entityExceptionSet.add(951);
                this.entityExceptionSet.add(920);
                this.entityExceptionSet.add(952);
                this.entityExceptionSet.add(921);
                this.entityExceptionSet.add(953);
                this.entityExceptionSet.add(922);
                this.entityExceptionSet.add(954);
                this.entityExceptionSet.add(923);
                this.entityExceptionSet.add(955);
                this.entityExceptionSet.add(924);
                this.entityExceptionSet.add(956);
                this.entityExceptionSet.add(925);
                this.entityExceptionSet.add(957);
                this.entityExceptionSet.add(926);
                this.entityExceptionSet.add(958);
                this.entityExceptionSet.add(927);
                this.entityExceptionSet.add(959);
                this.entityExceptionSet.add(928);
                this.entityExceptionSet.add(960);
                this.entityExceptionSet.add(929);
                this.entityExceptionSet.add(961);
                this.entityExceptionSet.add(930);
                this.entityExceptionSet.add(962);
                this.entityExceptionSet.add(931);
                this.entityExceptionSet.add(963);
                this.entityExceptionSet.add(932);
                this.entityExceptionSet.add(964);
                this.entityExceptionSet.add(933);
                this.entityExceptionSet.add(965);
                this.entityExceptionSet.add(934);
                this.entityExceptionSet.add(966);
                this.entityExceptionSet.add(935);
                this.entityExceptionSet.add(967);
                this.entityExceptionSet.add(936);
                this.entityExceptionSet.add(968);
                this.entityExceptionSet.add(937);
                this.entityExceptionSet.add(969);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertEntityAndCharset(File inputFile, String format) {
        String fileName = inputFile.getAbsolutePath();
        File outputFile = new File(fileName + ".temp");
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            FileInputStream inputStream = new FileInputStream(inputFile);
            InputStreamReader streamReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            reader = new BufferedReader(streamReader);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            String charset = this.charsetMap.get(format);
            OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
            writer = new BufferedWriter(streamWriter);
            this.updateExceptionCharacters(charset);
            CharsetEncoder outputCharsetEncoder = null;
            try {
                Charset outputCharset = Charset.forName(charset);
                outputCharsetEncoder = outputCharset.newEncoder();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            int charCode = reader.read();
            while (charCode != -1) {
                String key = String.valueOf(charCode);
                if (this.entityMap.containsKey(key) && !this.entityExceptionSet.contains(charCode)) {
                    if (outputCharsetEncoder != null && outputCharsetEncoder.canEncode((char)charCode)) {
                        writer.write(charCode);
                    } else {
                        String value = this.entityMap.get(key);
                        writer.write(value);
                    }
                } else {
                    writer.write(charCode);
                }
                charCode = reader.read();
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close input stream: " + e.getMessage());
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.error("Failed to close output stream: " + e.getMessage());
                }
            }
        }
        try {
            FileUtils.deleteQuietly((File)inputFile);
            FileUtils.moveFile((File)outputFile, (File)inputFile);
        }
        catch (Exception e) {
            this.logger.error("Failed to replace " + inputFile + ": " + e.getMessage());
        }
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setLangcode(String langcode) {
        this.langcode = langcode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOutputdir(String outputdir) {
        this.outputdir = outputdir;
    }
}

