/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.soap;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.messaging.saaj.soap.MessageImpl;
import com.sun.xml.messaging.saaj.soap.SOAPExceptionWithContentDetails;
import com.sun.xml.messaging.saaj.soap.ver1_1.Message1_1Impl;
import com.sun.xml.messaging.saaj.soap.ver1_2.Message1_2Impl;
import com.sun.xml.messaging.saaj.util.TeeInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class MessageFactoryImpl
extends MessageFactory {
    protected static Logger log = Logger.getLogger("javax.xml.messaging.saaj.soap", "com.sun.xml.messaging.saaj.soap.LocalStrings");
    protected static OutputStream listener;
    protected boolean lazyAttachments = false;

    public static OutputStream listen(OutputStream newListener) {
        OutputStream oldListener = listener;
        listener = newListener;
        return oldListener;
    }

    public SOAPMessage createMessage() throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(boolean isFastInfoset, boolean acceptFastInfoset) throws SOAPException {
        throw new UnsupportedOperationException();
    }

    public SOAPMessage createMessage(MimeHeaders headers, InputStream in) throws SOAPException, IOException {
        String contentTypeString = MessageImpl.getContentType(headers);
        ByteArrayOutputStream contentListener = null;
        if (listener == null && (contentTypeString != null && contentTypeString.contains("html") || contentTypeString.contains("text") || contentTypeString.contains("xml") || contentTypeString.contains("script"))) {
            contentListener = new ByteArrayOutputStream();
        }
        if (listener != null || contentListener != null) {
            in = new TeeInputStream(in, listener != null ? listener : contentListener);
        }
        try {
            ContentType contentType = new ContentType(contentTypeString);
            int stat = MessageImpl.identifyContentType(contentType);
            if (MessageImpl.isSoap1_1Content(stat)) {
                return new Message1_1Impl(headers, contentType, stat, in);
            }
            if (MessageImpl.isSoap1_2Content(stat)) {
                return new Message1_2Impl(headers, contentType, stat, in);
            }
            log.severe("SAAJ0530.soap.unknown.Content-Type");
            throw new SOAPExceptionImpl("Unrecognized Content-Type");
        }
        catch (ParseException e) {
            log.severe("SAAJ0531.soap.cannot.parse.Content-Type");
            throw new SOAPExceptionImpl("Unable to parse content type: " + e.getMessage());
        }
        catch (SOAPException ex) {
            try {
                if (contentListener != null) {
                    while (in.read() != -1) {
                    }
                    throw new SOAPExceptionWithContentDetails(ex.getMessage(), ex, contentListener.toByteArray());
                }
            }
            catch (IOException e) {
                log.severe(e.getMessage());
            }
            throw ex;
        }
    }

    protected static final String getContentType(MimeHeaders headers) {
        String[] values = headers.getHeader("Content-Type");
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public void setLazyAttachmentOptimization(boolean flag) {
        this.lazyAttachments = flag;
    }
}

