/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

public class ThreadUtil {
    public static String dumpThreads(Thread currentThread) {
        StringBuilder buf = new StringBuilder(500);
        ThreadGroup root = null;
        for (ThreadGroup currentGroup = currentThread.getThreadGroup(); currentGroup != null; currentGroup = currentGroup.getParent()) {
            root = currentGroup;
        }
        buf.append("========================\n");
        buf.append("  Group: ");
        buf.append(root.getName());
        buf.append("\n");
        buf.append("========================\n\n");
        Thread[] threads = new Thread[100];
        int cnt = root.enumerate(threads, true);
        for (int i = 0; i < cnt; ++i) {
            buf.append("======================\n");
            if (threads[i] != null) {
                buf.append(i);
                buf.append(" - Thread \"");
                buf.append(threads[i].getName());
                buf.append("\" [");
                buf.append(threads[i].getThreadGroup() != null ? threads[i].getThreadGroup().getName() : "NULL Thread group, thread probably STOPPED");
                buf.append("]");
                buf.append(" - state: ");
                buf.append((Object)threads[i].getState());
                buf.append("\n");
            }
            buf.append("----------------------\n");
            StackTraceElement[] ste = threads[i].getStackTrace();
            for (int j = 0; j < ste.length; ++j) {
                buf.append(" ");
                buf.append(ste[j]);
                buf.append("\n");
            }
        }
        return buf.toString();
    }
}

