/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.NumberParserUtil;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class PlatformDetector {
    public static final String COM_OXYGENXML_IS_ECLIPSE_PLUGIN = "com.oxygenxml.is.eclipse.plugin";
    private static final String UNKNOWN_VERSION = "Unknown";
    public static final int DETECT = -1;
    public static final int WIN = 0;
    public static final int MACOS = 1;
    public static final int LINUX = 2;
    private static int type = -1;
    private static String version = "Unknown";
    private static WindowsVersion windowsVersion = null;
    private static Boolean isEclipse = null;

    protected PlatformDetector() {
    }

    @Deprecated
    public static synchronized boolean isWin32() {
        return PlatformDetector.isWin();
    }

    public static synchronized boolean isWin() {
        if (type == -1) {
            type = PlatformDetector.detect();
        }
        return type == 0;
    }

    public static synchronized boolean isMacOS() {
        if (type == -1) {
            type = PlatformDetector.detect();
        }
        return type == 1;
    }

    public static synchronized boolean isLinux() {
        if (type == -1) {
            type = PlatformDetector.detect();
        }
        return type == 2;
    }

    public static synchronized String getVersion() {
        if (version == UNKNOWN_VERSION) {
            version = System.getProperty("os.version");
        }
        return version;
    }

    private static synchronized int detect() {
        return PlatformDetector.detect(System.getProperty("os.name"));
    }

    public static synchronized int detect(String osName) {
        if ((osName = osName.trim().toUpperCase(Locale.ENGLISH)).startsWith("WIN")) {
            return 0;
        }
        if (osName.startsWith("MAC OS") || osName.equals("MAC")) {
            return 1;
        }
        return 2;
    }

    private static synchronized void detectWindowsVersion() {
        if (PlatformDetector.isWin()) {
            String detectedName;
            float detectedVersion;
            block14: {
                windowsVersion = WindowsVersion.UNKNOWN;
                HashMap<WindowsVersion, List<Float>> WINDOWS_VERSIONS_MAP = new HashMap<WindowsVersion, List<Float>>();
                WINDOWS_VERSIONS_MAP.put(WindowsVersion.WINDOWS_XP, Arrays.asList(Float.valueOf(5.1f), Float.valueOf(5.2f)));
                WINDOWS_VERSIONS_MAP.put(WindowsVersion.WINDOWS_VISTA, Arrays.asList(Float.valueOf(6.0f)));
                WINDOWS_VERSIONS_MAP.put(WindowsVersion.WINDOWS_7, Arrays.asList(Float.valueOf(6.1f)));
                WINDOWS_VERSIONS_MAP.put(WindowsVersion.WINDOWS_8, Arrays.asList(Float.valueOf(6.2f), Float.valueOf(6.3f)));
                WINDOWS_VERSIONS_MAP.put(WindowsVersion.WINDOWS_10, Arrays.asList(Float.valueOf(10.0f)));
                HashMap<WindowsVersion, List<String>> WINDOWS_NAMES_MAP = new HashMap<WindowsVersion, List<String>>();
                WINDOWS_NAMES_MAP.put(WindowsVersion.WINDOWS_XP, Arrays.asList(" XP", " XP PROFESSIONAL X64", " 2003", " 2003 R2"));
                WINDOWS_NAMES_MAP.put(WindowsVersion.WINDOWS_VISTA, Arrays.asList(" VISTA", " 2008"));
                WINDOWS_NAMES_MAP.put(WindowsVersion.WINDOWS_7, Arrays.asList(" 7", " 2008 R2"));
                WINDOWS_NAMES_MAP.put(WindowsVersion.WINDOWS_8, Arrays.asList(" 8", " 2012", " 8.1", " 2012 R2"));
                WINDOWS_NAMES_MAP.put(WindowsVersion.WINDOWS_10, Arrays.asList(" 10", " 2016", " 2019", " 2022"));
                WINDOWS_NAMES_MAP.put(WindowsVersion.WINDOWS_11, Arrays.asList(" 11"));
                detectedVersion = -1.0f;
                try {
                    detectedVersion = NumberParserUtil.parseFloat(PlatformDetector.getVersion());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                detectedName = System.getProperty("os.name").trim().toUpperCase(Locale.ENGLISH);
                if (detectedVersion > 0.0f) {
                    block2: for (WindowsVersion winVersion : WINDOWS_VERSIONS_MAP.keySet()) {
                        for (Float version : (List)WINDOWS_VERSIONS_MAP.get((Object)winVersion)) {
                            if (detectedVersion != version.floatValue()) continue;
                            windowsVersion = winVersion;
                            break block2;
                        }
                    }
                }
                if (detectedName != null && detectedName.length() > 0) {
                    if (windowsVersion == WindowsVersion.UNKNOWN) {
                        for (WindowsVersion winVersion : WINDOWS_NAMES_MAP.keySet()) {
                            for (String name : (List)WINDOWS_NAMES_MAP.get((Object)winVersion)) {
                                if (!detectedName.endsWith(name)) continue;
                                windowsVersion = winVersion;
                                break block14;
                            }
                        }
                    } else if (windowsVersion == WindowsVersion.WINDOWS_10) {
                        for (String name : (List)WINDOWS_NAMES_MAP.get((Object)WindowsVersion.WINDOWS_11)) {
                            if (!detectedName.endsWith(name)) continue;
                            windowsVersion = WindowsVersion.WINDOWS_11;
                            break;
                        }
                    }
                }
            }
            if (windowsVersion == WindowsVersion.UNKNOWN) {
                System.out.println("Unknown Windows version: " + detectedVersion + " / " + detectedName);
            }
        }
    }

    public static synchronized boolean isWinXP() {
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        return windowsVersion == WindowsVersion.WINDOWS_XP;
    }

    public static synchronized boolean isWinXPOrLater() {
        boolean winXPLater = false;
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        if (type == 0) {
            if (windowsVersion != WindowsVersion.UNKNOWN) {
                winXPLater = WindowsVersion.WINDOWS_XP.compareTo(windowsVersion) <= 0;
            } else {
                try {
                    winXPLater = NumberParserUtil.parseFloat(PlatformDetector.getVersion()) >= 5.1f;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return winXPLater;
    }

    public static synchronized boolean isWinVista() {
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        return windowsVersion == WindowsVersion.WINDOWS_VISTA;
    }

    public static synchronized boolean isWinVistaOrLater() {
        boolean winVistaLater = false;
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        if (type == 0) {
            if (windowsVersion != WindowsVersion.UNKNOWN) {
                winVistaLater = WindowsVersion.WINDOWS_VISTA.compareTo(windowsVersion) <= 0;
            } else {
                try {
                    winVistaLater = NumberParserUtil.parseFloat(PlatformDetector.getVersion()) >= 6.0f;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return winVistaLater;
    }

    public static synchronized boolean isWin7() {
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        return windowsVersion == WindowsVersion.WINDOWS_7;
    }

    public static synchronized boolean isWin8() {
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        return windowsVersion == WindowsVersion.WINDOWS_8;
    }

    public static synchronized boolean isWin8OrLater() {
        boolean win8Later = false;
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        if (type == 0) {
            if (windowsVersion != WindowsVersion.UNKNOWN) {
                win8Later = WindowsVersion.WINDOWS_8.compareTo(windowsVersion) <= 0;
            } else {
                try {
                    win8Later = NumberParserUtil.parseFloat(PlatformDetector.getVersion()) >= 6.2f;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return win8Later;
    }

    public static synchronized boolean isWin10() {
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        return windowsVersion == WindowsVersion.WINDOWS_10;
    }

    public static synchronized boolean isWin11() {
        if (windowsVersion == null) {
            PlatformDetector.detectWindowsVersion();
        }
        return windowsVersion == WindowsVersion.WINDOWS_11;
    }

    public static synchronized boolean isMacOS_10_5_orGreater() {
        String version;
        boolean toReturn = PlatformDetector.isMacOS();
        if (toReturn && (version = System.getProperty("os.version")) != null) {
            String[] versionTokens = version.split("\\.", 3);
            try {
                int major = NumberParserUtil.parseInt(versionTokens[0]);
                int minor = versionTokens.length > 1 ? NumberParserUtil.parseInt(versionTokens[1]) : 0;
                toReturn = major > 10 || major == 10 && minor >= 5;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    public static synchronized boolean isMacOS_10_7_orGreater() {
        String version;
        boolean toReturn = PlatformDetector.isMacOS();
        if (toReturn && (version = System.getProperty("os.version")) != null) {
            String[] versionTokens = version.split("\\.", 3);
            try {
                int major = NumberParserUtil.parseInt(versionTokens[0]);
                int minor = versionTokens.length > 1 ? NumberParserUtil.parseInt(versionTokens[1]) : 0;
                toReturn = major > 10 || major == 10 && minor >= 7;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    public static synchronized void setTypeFromTests(int newType) {
        if (newType != -1 && newType != 0 && newType != 1 && newType != 2) {
            System.out.println("Invalid OS type, switched to AUTO-DETECT mode!");
            newType = -1;
        }
        type = newType;
        version = UNKNOWN_VERSION;
        windowsVersion = null;
    }

    public static synchronized int getType() {
        if (type == -1) {
            type = PlatformDetector.detect();
        }
        return type;
    }

    public static synchronized boolean isEclipse() {
        if (isEclipse == null) {
            isEclipse = "true".equalsIgnoreCase(System.getProperty(COM_OXYGENXML_IS_ECLIPSE_PLUGIN));
        }
        return isEclipse;
    }

    public static synchronized void resetIsEclipseFromTC() {
        isEclipse = null;
    }

    public static synchronized boolean isMacOS_10_10_orGreater() {
        String version;
        boolean toReturn = PlatformDetector.isMacOS();
        if (toReturn && (version = System.getProperty("os.version")) != null) {
            String[] versionTokens = version.split("\\.", 3);
            try {
                int major = NumberParserUtil.parseInt(versionTokens[0]);
                int minor = versionTokens.length > 1 ? NumberParserUtil.parseInt(versionTokens[1]) : 0;
                toReturn = major > 10 || major == 10 && minor >= 10;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    public static synchronized boolean isMacOS_10_11_orGreater() {
        String version;
        boolean toReturn = PlatformDetector.isMacOS();
        if (toReturn && (version = System.getProperty("os.version")) != null) {
            String[] versionTokens = version.split("\\.", 3);
            try {
                int major = NumberParserUtil.parseInt(versionTokens[0]);
                int minor = versionTokens.length > 1 ? NumberParserUtil.parseInt(versionTokens[1]) : 0;
                toReturn = major > 10 || major == 10 && minor >= 11;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    public static synchronized boolean isMacOS_10_16_orGreater() {
        String version;
        boolean toReturn = PlatformDetector.isMacOS();
        if (toReturn && (version = System.getProperty("os.version")) != null) {
            String[] versionTokens = version.split("\\.", 3);
            try {
                int major = NumberParserUtil.parseInt(versionTokens[0]);
                int minor = versionTokens.length > 1 ? NumberParserUtil.parseInt(versionTokens[1]) : 0;
                toReturn = major > 10 || major == 10 && minor >= 16;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return toReturn;
    }

    private static enum WindowsVersion {
        UNKNOWN,
        WINDOWS_XP,
        WINDOWS_VISTA,
        WINDOWS_7,
        WINDOWS_8,
        WINDOWS_10,
        WINDOWS_11;

    }
}

