/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOStreamUtil;

public class DiffUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DiffUtil.class.getName());
    public static int BYTE_BUF_SIZE = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean byteCompareFilesIgnoreCR(InputStream is1, InputStream is2) {
        fis1 = null;
        fis2 = null;
        try {
            fis1 = new BufferedInputStream(is1);
            fis2 = new BufferedInputStream(is2);
            b1 = -1;
            b2 = -1;
lbl8:
            // 2 sources

            while (true) {
                if ((b1 = fis1.read()) == 13) {
                    continue;
                }
                while ((b2 = fis2.read()) == 13) {
                }
                if (b1 == b2) ** GOTO lbl-1000
                var6_7 = false;
                ** GOTO lbl25
                break;
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                var5_6 = false;
            }
            catch (Throwable var7_8) {
                DiffUtil.closeSilently(fis1);
                DiffUtil.closeSilently(fis2);
                throw var7_8;
            }
lbl25:
            // 1 sources

            DiffUtil.closeSilently(fis1);
            DiffUtil.closeSilently(fis2);
            return var6_7;
lbl-1000:
            // 1 sources

            {
                if (b1 == -1 && b2 == -1) ** break;
                ** continue;
            }
            DiffUtil.closeSilently(fis1);
            DiffUtil.closeSilently(fis2);
            return true;
            DiffUtil.closeSilently(fis1);
            DiffUtil.closeSilently(fis2);
            return var5_6;
        }
    }

    private static void closeSilently(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void byteCompareFiles(InputStream is1, InputStream is2, String fileDesc1, String fileDesc2) throws DiffUtilException {
        BufferedInputStream fis2;
        BufferedInputStream fis1;
        block9: {
            fis1 = null;
            fis2 = null;
            try {
                DiffUtilException differentSizedEx;
                fis1 = new BufferedInputStream(is1);
                fis2 = new BufferedInputStream(is2);
                byte[] b1Bytes = new byte[BYTE_BUF_SIZE];
                byte[] b2Bytes = new byte[BYTE_BUF_SIZE];
                int posInInput = 0;
                do {
                    int len1 = IOStreamUtil.readFully(fis1, b1Bytes);
                    int len2 = IOStreamUtil.readFully(fis2, b2Bytes);
                    differentSizedEx = null;
                    int len = len1;
                    if (len1 < len2) {
                        len = len1;
                        differentSizedEx = new DiffUtilException("File '" + fileDesc2 + "' is longer than file '" + fileDesc1 + "'");
                    } else if (len1 > len2) {
                        len = len2;
                        differentSizedEx = new DiffUtilException("File '" + fileDesc1 + "' is longer than file '" + fileDesc2 + "'");
                    }
                    if (len1 == len2 && len1 == -1) break block9;
                    for (int i = 0; i < len; ++posInInput, ++i) {
                        if (b1Bytes[i] == b2Bytes[i]) continue;
                        throw new DiffUtilException("Files are different starting with offset " + posInInput);
                    }
                } while (differentSizedEx == null);
                throw differentSizedEx;
            }
            catch (IOException e) {
                try {
                    throw new DiffUtilException(e.getMessage());
                }
                catch (Throwable throwable) {
                    DiffUtil.closeSilently(fis1);
                    DiffUtil.closeSilently(fis2);
                    throw throwable;
                }
            }
        }
        DiffUtil.closeSilently(fis1);
        DiffUtil.closeSilently(fis2);
        return;
    }

    public static class DiffUtilException
    extends Exception {
        public DiffUtilException(String message) {
            super(message);
        }
    }
}

