/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class BoundedSizeCache<K, V>
extends LinkedHashMap<K, V> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int maxSize;

    public BoundedSizeCache(int maxSize) {
        super(maxSize + 1, 0.75f, true);
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Cache size should be positive.");
        }
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }
}

