/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.Reader;

public class DynamicBufferedReader
extends Reader {
    private Reader actualReader;
    private StringBuffer data;
    private boolean canClose = false;
    private boolean buffering = true;
    int dataIndex = 0;

    public DynamicBufferedReader(Reader in, int sz) {
        this.data = new StringBuffer(sz);
        this.actualReader = in;
    }

    public void setCanClose(boolean canClose) {
        this.canClose = canClose;
    }

    @Override
    public void close() throws IOException {
        if (this.canClose) {
            this.actualReader.close();
        }
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.buffering) {
            int n = this.actualReader.read(cbuf, off, len);
            if (n > 0) {
                this.data.append(cbuf, off, n);
            }
            return n;
        }
        if (this.dataIndex < this.data.length()) {
            int end = this.dataIndex + len;
            if (end > this.data.length()) {
                end = this.data.length();
            }
            this.data.getChars(this.dataIndex, end, cbuf, off);
            len = end - this.dataIndex;
            this.dataIndex = end;
            return len;
        }
        return this.actualReader.read(cbuf, off, len);
    }

    public void stopBuffering() {
        if (!this.buffering) {
            throw new IllegalStateException("Buffering was already stopped!");
        }
        this.buffering = false;
    }
}

