/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.classloader;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualServicesClassLoader
extends URLClassLoader {
    private static Logger logger = LoggerFactory.getLogger((String)VirtualServicesClassLoader.class.getName());
    private final String[] resValues;
    private final String[] resNames;
    private static final String PREFIX = "META-INF/oxy-virtual-services/";

    public VirtualServicesClassLoader(ClassLoader parent, String[] resNames, String[] resValues) {
        super(new URL[0], parent);
        this.resNames = resNames;
        this.resValues = resValues;
        for (int i = 0; i < resValues.length; ++i) {
            String path = this.getPath(resValues[i]);
            URL resource = parent.getResource(path);
            String exp = "VirtualServicesClassLoader value " + resValues[i] + " is not registered. It should be in " + path;
            if (resource == null) {
                throw new IllegalStateException(exp);
            }
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), "UTF-8"));
                String line = reader.readLine();
                if (resValues[i].equals(line)) continue;
                throw new IllegalStateException("The file " + resource + " does not contain a text equal to its name: " + resValues[i] + ", found instead: " + line);
            }
            catch (IOException e) {
                throw new IllegalStateException(exp);
            }
        }
    }

    private String getPath(String val) {
        return PREFIX + val;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream ret = null;
        for (int i = 0; i < this.resNames.length; ++i) {
            try {
                if (!this.resNames[i].equals(name)) continue;
                ret = new ByteArrayInputStream(this.resValues[i].getBytes("UTF8"));
                break;
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (ret == null) {
            ret = super.getResourceAsStream(name);
        }
        return ret;
    }

    @Override
    public URL getResource(String name) {
        URL ret = null;
        for (int i = 0; i < this.resNames.length; ++i) {
            if (!this.resNames[i].equals(name)) continue;
            ret = super.getResource(this.getPath(this.resValues[i]));
            break;
        }
        if (ret == null) {
            ret = super.getResource(name);
        }
        return ret;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> v = null;
        for (int i = 0; i < this.resNames.length; ++i) {
            if (!this.resNames[i].equals(name)) continue;
            if (v == null) {
                v = new Vector<URL>(1);
            }
            v.add(super.getResource(this.getPath(this.resValues[i])));
        }
        if (v == null) {
            return super.getResources(name);
        }
        return v.elements();
    }
}

