/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xinclude;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;

public class FragIDParser {
    String charset;
    int[] lineRange;
    int[] charRange;
    private String fragID;

    public FragIDParser(String fragID) {
        this.fragID = fragID;
        if (this.fragID != null) {
            String toProcessForRanges = this.fragID;
            int lastCommaIndex = fragID.lastIndexOf(",");
            if (lastCommaIndex != -1 && lastCommaIndex < fragID.length()) {
                String possibleCharset = fragID.substring(lastCommaIndex + 1, fragID.length());
                try {
                    Integer.parseInt(possibleCharset);
                }
                catch (RuntimeException ex) {
                    this.charset = possibleCharset;
                    toProcessForRanges = lastCommaIndex > 0 ? toProcessForRanges.substring(0, lastCommaIndex) : "";
                }
            }
            StringTokenizer st = new StringTokenizer(fragID, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int[] range = FragIDParser.updateRange(token, "line=");
                if (range != null) {
                    this.lineRange = range;
                }
                if ((range = FragIDParser.updateRange(token, "char=")) == null) continue;
                this.charRange = range;
            }
        }
    }

    private static int[] updateRange(String token, String tokenPrefix) {
        int[] range = null;
        if (token.startsWith(tokenPrefix) && token.length() > tokenPrefix.length()) {
            String values = token.substring(tokenPrefix.length(), token.length());
            int cnt = 0;
            int delta = 0;
            if (values.startsWith(",")) {
                ++cnt;
                delta = 1;
            }
            StringTokenizer valuesTokenizer = new StringTokenizer(values, ",");
            range = new int[valuesTokenizer.countTokens() + delta];
            while (valuesTokenizer.hasMoreTokens()) {
                String val = valuesTokenizer.nextToken();
                try {
                    range[cnt] = Integer.parseInt(val.trim());
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                }
                ++cnt;
            }
        }
        return range;
    }

    public Reader limitedRangeReader(Reader reader) throws IOException {
        block14: {
            if (this.charRange != null && this.charRange.length > 0 || this.lineRange != null && this.lineRange.length > 0) {
                reader = new BufferedReader(reader);
            }
            if (this.charRange != null && this.charRange.length > 0) {
                int firstOffset = this.charRange[0];
                try {
                    for (int i = 0; i < firstOffset; ++i) {
                        reader.read();
                    }
                    if (this.charRange.length > 1 && this.charRange[1] != 0) {
                        char[] toReturn = new char[this.charRange[1] - this.charRange[0]];
                        int len = reader.read(toReturn);
                        String ret = new String(toReturn, 0, len);
                        reader.close();
                        reader = new StringReader(ret);
                        break block14;
                    }
                    reader = new StringReader("" + (char)reader.read());
                }
                catch (Exception e) {
                    reader.close();
                    reader = new StringReader("");
                }
            } else if (this.lineRange != null && this.lineRange.length > 0) {
                int firstLine = this.lineRange[0];
                StringBuilder sb = new StringBuilder();
                try {
                    int i;
                    for (i = 0; i < firstLine; ++i) {
                        ((BufferedReader)reader).readLine();
                    }
                    if (this.lineRange.length > 1 && this.lineRange[1] != 0) {
                        String line;
                        for (i = this.lineRange[0]; i < this.lineRange[1] && (line = ((BufferedReader)reader).readLine()) != null; ++i) {
                            sb.append(line).append("\n");
                        }
                        reader.close();
                        reader = new StringReader(sb.toString());
                    } else {
                        String line = ((BufferedReader)reader).readLine();
                        ((BufferedReader)reader).close();
                        reader = new StringReader(line + "\n");
                    }
                }
                catch (IOException e) {
                    reader = sb.length() > 0 ? new StringReader(sb.toString()) : new StringReader("");
                }
            }
        }
        return reader;
    }

    public String getCharset() {
        return this.charset;
    }

    public int[] getCharRange() {
        return this.charRange;
    }
}

