/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.locator;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.impl.locator.AttributeLocator;
import org.apache.xerces.impl.locator.AttributeOrElementLocator;
import org.apache.xerces.impl.locator.XMLItemLocator;

public class ElementLocator
implements AttributeOrElementLocator {
    private XMLItemLocator contentLocator = new XMLItemLocator();
    private List<AttributeLocator> attributeLocators;
    private List<XMLItemLocator> contentLocators;
    private XMLItemLocator elementNameLocator = new XMLItemLocator();
    private String publicId;
    private String systemId;

    public ElementLocator(int elNameStartLine, int elNameStartColumn, String publicId, String systemId) {
        this.elementNameLocator.setStartLine(elNameStartLine);
        this.elementNameLocator.setStartColumn(elNameStartColumn);
        this.publicId = publicId;
        this.systemId = systemId;
        this.elementNameLocator.setPublicID(publicId);
        this.elementNameLocator.setSystemID(systemId);
    }

    public void setContentEndColumn(int contentEndColumn) {
        this.contentLocator.setEndColumn(contentEndColumn);
    }

    public void setContentEndLine(int contentEndLine) {
        this.contentLocator.setEndLine(contentEndLine);
    }

    public void setContentStartColumn(int contentStartColumn) {
        this.contentLocator.setStartColumn(contentStartColumn);
    }

    public void setContentStartLine(int contentStartLine) {
        this.contentLocator.setStartLine(contentStartLine);
    }

    public void addAttributeLocator(AttributeLocator attributeLocator) {
        if (this.attributeLocators == null) {
            this.attributeLocators = new ArrayList<AttributeLocator>(1);
        }
        this.attributeLocators.add(attributeLocator);
        attributeLocator.setParentElementLocator(this);
    }

    public void addContentLocator(XMLItemLocator elementContentLocator) {
        if (this.contentLocators == null) {
            this.contentLocators = new ArrayList<XMLItemLocator>(1);
        }
        if (this.contentLocators.isEmpty()) {
            this.contentLocators.add(elementContentLocator);
        } else {
            XMLItemLocator previous = this.contentLocators.get(this.contentLocators.size() - 1);
            if (previous.getEndLine() == elementContentLocator.getStartLine() && previous.getEndColumn() == elementContentLocator.getStartColumn()) {
                previous.setEndLine(elementContentLocator.getEndLine());
                previous.setEndColumn(elementContentLocator.getEndColumn());
            } else if (previous.getStartLine() == elementContentLocator.getStartLine() && previous.getStartColumn() == elementContentLocator.getStartColumn()) {
                previous.setEndLine(elementContentLocator.getEndLine());
                previous.setEndColumn(elementContentLocator.getEndColumn());
            } else {
                this.contentLocators.add(elementContentLocator);
            }
        }
    }

    public AttributeLocator getAttributeWithName(String name) {
        AttributeLocator attribute = null;
        if (this.attributeLocators != null) {
            int size = this.attributeLocators.size();
            for (int i = size - 1; i >= 0; --i) {
                AttributeLocator attr = this.attributeLocators.get(i);
                Object rawName = attr.getLocalName();
                if (attr.getPrefix() != null) {
                    rawName = attr.getPrefix() + ":" + attr.getLocalName();
                }
                if (name.equals(rawName)) {
                    attribute = attr;
                    break;
                }
                Object nameWithNS = attr.getLocalName();
                if (attr.getUri() != null) {
                    nameWithNS = attr.getUri() + "," + attr.getLocalName();
                }
                if (!name.equals(nameWithNS)) continue;
                attribute = attr;
                break;
            }
        }
        return attribute;
    }

    public AttributeLocator getAttributeWithValue(String value) {
        AttributeLocator attribute = null;
        if (this.attributeLocators != null) {
            for (AttributeLocator atr : this.attributeLocators) {
                if (!value.equals(atr.getValue())) continue;
                attribute = atr;
                break;
            }
        }
        return attribute;
    }

    public int getContentEndColumn() {
        return this.contentLocator.getEndColumn();
    }

    public int getContentEndLine() {
        return this.contentLocator.getEndLine();
    }

    public int getContentStartColumn() {
        return this.contentLocator.getStartColumn();
    }

    public int getContentStartLine() {
        return this.contentLocator.getStartLine();
    }

    public List<XMLItemLocator> getElementContentLocators() {
        return this.contentLocators;
    }

    public void setNameEndLocation(int lineNumber, int columnNumber) {
        this.elementNameLocator.setEndLine(lineNumber);
        this.elementNameLocator.setEndColumn(columnNumber);
    }

    public XMLItemLocator getNameLocation() {
        return this.elementNameLocator;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getColumnNumber() {
        int col = 1;
        XMLItemLocator nameLocation = this.getNameLocation();
        if (nameLocation != null) {
            col = nameLocation.getStartColumn();
        }
        return col;
    }

    @Override
    public int getLineNumber() {
        int line = 1;
        XMLItemLocator nameLocation = this.getNameLocation();
        if (nameLocation != null) {
            line = nameLocation.getStartLine();
        }
        return line;
    }

    public void updateAttributesNSURIs(String prefix, String uri) {
        if (this.attributeLocators != null && uri != null && prefix != null) {
            for (AttributeLocator locator : this.attributeLocators) {
                if (!prefix.equals(locator.getPrefix())) continue;
                locator.setUri(uri);
            }
        }
    }
}

