/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.IsLastExpression;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ParentNodeExpression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.pattern.Pattern;

public final class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = null;
    protected int numberOfFilters = 0;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;

    public void addFilter(Expression filter) {
        if (this.filters == null) {
            this.filters = new Expression[3];
        } else if (this.numberOfFilters == this.filters.length) {
            Expression[] f2 = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, f2, 0, this.numberOfFilters);
            this.filters = f2;
        }
        this.filters[this.numberOfFilters++] = filter;
    }

    @Override
    public Pattern simplify() throws XPathException {
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters == null) {
            this.nodeTest.setStaticContext(this.getStaticContext());
            return this.nodeTest;
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify();
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify();
        }
        if (this.filters != null) {
            for (int i = this.numberOfFilters - 1; i >= 0; --i) {
                Expression filter;
                this.filters[i] = filter = this.filters[i].simplify();
                if (!(filter instanceof BooleanValue) || !((Value)filter).asBoolean() || i != this.numberOfFilters - 1) continue;
                --this.numberOfFilters;
            }
        }
        if (this.nodeTest.getNodeType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof NumericValue && (int)((NumericValue)this.filters[0]).asNumber() == 1) {
            this.firstElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.nodeTest.getNodeType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.isRelative()) {
            this.makeEquivalentExpression();
            this.specialFilter = true;
        }
        return this;
    }

    private void makeEquivalentExpression() throws XPathException {
        byte axis = this.nodeTest.getNodeType() == 2 ? (byte)2 : 3;
        Step step = new Step(axis, this.nodeTest);
        step.setFilters(this.filters, this.numberOfFilters);
        this.equivalentExpr = new PathExpression(new ParentNodeExpression(), step);
    }

    public boolean matchesX(NodeInfo node, Context context) throws XPathException {
        System.err.println("Matching node " + node + " against LP pattern " + this);
        System.err.println("Node types " + node.getNodeType() + " / " + this.getNodeType());
        boolean b = this.matches(node, context);
        System.err.println(b ? "matches" : "no match");
        return b;
    }

    @Override
    public boolean matches(NodeInfo node, Context context) throws XPathException {
        Context c;
        if (!this.nodeTest.matches(node)) {
            return false;
        }
        if (this.parentPattern != null) {
            NodeInfo par = node.getParent();
            if (par == null) {
                return false;
            }
            if (!this.parentPattern.matches(par, context)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            NodeInfo anc = node.getParent();
            while (!this.ancestorPattern.matches(anc, context)) {
                if ((anc = anc.getParent()) != null) continue;
                return false;
            }
        }
        if (this.specialFilter) {
            AxisEnumeration enm;
            if (this.firstElementPattern) {
                enm = node.getEnumeration((byte)11, this.nodeTest);
                return !enm.hasMoreElements();
            }
            if (this.lastElementPattern) {
                enm = node.getEnumeration((byte)7, this.nodeTest);
                return !enm.hasMoreElements();
            }
            if (this.equivalentExpr != null) {
                c = context.newContext();
                c.setContextNode(node);
                c.setPosition(1);
                c.setLast(1);
                NodeEnumeration nsv = this.equivalentExpr.enumerate(c, false);
                while (nsv.hasMoreElements()) {
                    NodeInfo n = nsv.nextElement();
                    if (!n.isSameNodeInfo(node)) continue;
                    return true;
                }
                return false;
            }
        }
        if (this.filters != null) {
            c = context.newContext();
            c.setContextNode(node);
            c.setPosition(1);
            c.setLast(1);
            for (int i = 0; i < this.numberOfFilters; ++i) {
                if (this.filters[i].evaluateAsBoolean(c)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public short getNodeType() {
        return this.nodeTest.getNodeType();
    }

    @Override
    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public boolean isRelative() throws XPathException {
        if (this.filters == null) {
            return false;
        }
        for (int i = 0; i < this.numberOfFilters; ++i) {
            int type = this.filters[i].getDataType();
            if (type == 2 || type == -1) {
                return true;
            }
            if ((this.filters[i].getDependencies() & 0x30) == 0) continue;
            return true;
        }
        return false;
    }

    public Expression[] getFilters() {
        return this.filters;
    }

    public int getNumberOfFilters() {
        return this.numberOfFilters;
    }
}

