/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.cssvalidator.properties.oxygen;

import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import ro.sync.cssvalidator.properties.oxygen.CssIdentFilter;
import ro.sync.cssvalidator.properties.oxygen.InheritDecoratorFilter;

public final class CssIdentUtils {
    public static final CssIdent IDENTIFIER_TRUE = CssIdent.getIdent("true");
    public static final CssIdent IDENTIFIER_FALSE = CssIdent.getIdent("false");
    public static final CssIdent IDENTIFIER_YES = CssIdent.getIdent("yes");
    public static final CssIdent IDENTIFIER_NO = CssIdent.getIdent("no");
    public static final CssIdent IDENTIFIER_DEFAULT = CssIdent.getIdent("default");
    public static final CssIdent IDENTIFIER_ALWAYS = CssIdent.getIdent("always");

    private CssIdentUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static CssIdent[] getCssIdents(String ... allowedValues) {
        CssIdent[] cssIdents = new CssIdent[allowedValues.length];
        for (int i = 0; i < allowedValues.length; ++i) {
            cssIdents[i] = CssIdent.getIdent(allowedValues[i]);
        }
        return cssIdents;
    }

    public static CssIdent findIdent(CssIdent[] toSearch, CssIdent toFind) {
        for (CssIdent id : toSearch) {
            if (!id.equals(toFind)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getInheritOrAllowed(CssValue value, CssIdentFilter allowedFilter) {
        CssIdent ident = null;
        if (value.getType() == 0) {
            ident = new InheritDecoratorFilter(allowedFilter).filter((CssIdent)value);
        }
        return ident;
    }

    public static boolean isYesNoIdentifier(CssValue value) {
        return value instanceof CssIdent && (IDENTIFIER_YES.equals((CssIdent)value) || IDENTIFIER_NO.equals((CssIdent)value));
    }

    public static boolean isTrueFalseIdentifier(CssValue value) {
        return value instanceof CssIdent && (IDENTIFIER_TRUE.equals((CssIdent)value) || IDENTIFIER_FALSE.equals((CssIdent)value));
    }
}

