/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors.attributes;

import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.Selector;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.util.ApplContext;

public class AttributeStart
extends AttributeSelector {
    private String value;
    boolean isPrefix = false;

    public AttributeStart(String name, String value) {
        this.setName(name);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean canApply(Selector other) {
        return true;
    }

    @Override
    public void applyAttribute(ApplContext ac, AttributeSelector attr) {
        String name = this.getName();
        if (name.equals(attr.getName())) {
            if (attr instanceof AttributeExact) {
                ((AttributeExact)attr).applyAttribute(ac, this);
            } else if (attr instanceof AttributeBegin) {
                ((AttributeBegin)attr).applyAttribute(ac, this);
            } else if (attr instanceof AttributeOneOf) {
                ((AttributeOneOf)attr).applyAttribute(ac, this);
            } else if (attr instanceof AttributeStart) {
                AttributeStart next = (AttributeStart)attr;
                String othervalue = next.getValue();
                boolean bl = this.isPrefix = this.value.startsWith(othervalue) || othervalue.startsWith(this.value);
                if (!this.isPrefix) {
                    ac.getFrame().addWarning("incompatible", new String[]{this.toString(), attr.toString()});
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getPrefixedName());
        sb.append("^=\"").append(this.value).append('\"');
        sb.append(this.getEndingString());
        return sb.toString();
    }
}

