/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css3.CssBackgroundAttachment;
import org.w3c.css.properties.css3.CssBackgroundClip;
import org.w3c.css.properties.css3.CssBackgroundColor;
import org.w3c.css.properties.css3.CssBackgroundImage;
import org.w3c.css.properties.css3.CssBackgroundOrigin;
import org.w3c.css.properties.css3.CssBackgroundPosition;
import org.w3c.css.properties.css3.CssBackgroundRepeat;
import org.w3c.css.properties.css3.CssBackgroundSize;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssBackground
extends org.w3c.css.properties.css.CssBackground {
    public CssBackground() {
        this.value = initial;
    }

    public CssBackground(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssBackground(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        this.setByUser();
        CssExpression single_layer = null;
        CssBackgroundValue b_val = null;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (val.getType() == 0 && CssIdent.isCssWide(val.getIdent())) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = val;
                expression.next();
                return;
            }
            if (single_layer == null) {
                single_layer = new CssExpression();
            }
            single_layer.addValue(val);
            single_layer.setOperator(op);
            expression.next();
            if (expression.end()) continue;
            if (op == ',') {
                single_layer.setOperator(' ');
                b_val = this.check(ac, single_layer, check2, false);
                values.add(b_val);
                single_layer = null;
                continue;
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        if (single_layer != null) {
            b_val = this.check(ac, single_layer, check2, true);
            values.add(b_val);
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
        this.transform_into_individual_values();
    }

    private CssValue getCssBackgroundRepeatValue(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        char op = expression.getOperator();
        CssExpression exp = new CssExpression();
        exp.addValue(expression.getValue());
        this.repeat = new CssBackgroundRepeat(ac, exp, check2);
        if (op == ' ' && !expression.end()) {
            expression.next();
            if (!expression.end()) {
                CssValue val = expression.getValue();
                if (val.getType() == 0 && CssBackgroundRepeat.isMatchingIdent(val.getIdent())) {
                    exp.addValue(val);
                    exp.starts();
                    try {
                        this.repeat = new CssBackgroundRepeat(ac, exp, check2);
                    }
                    catch (InvalidParamException ipe) {
                        expression.precedent();
                    }
                } else {
                    expression.precedent();
                }
            }
        }
        return this.repeat.value;
    }

    private CssValue getCssBackgroundSizeValue(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        char op = expression.getOperator();
        CssExpression exp = new CssExpression();
        exp.addValue(expression.getValue());
        CssBackgroundSize bg_size = new CssBackgroundSize(ac, exp, check2);
        if (op == ' ' && !expression.end()) {
            expression.next();
            if (!expression.end()) {
                exp.addValue(expression.getValue());
                exp.starts();
                try {
                    bg_size = new CssBackgroundSize(ac, exp, check2);
                }
                catch (InvalidParamException ipe) {
                    expression.precedent();
                }
            }
        }
        return bg_size.value;
    }

    private CssValue getCssBackgroundPositionValue(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssExpression exp = new CssExpression();
        char op = expression.getOperator();
        exp.addValue(expression.getValue());
        int last_val = -1;
        CssBackgroundPosition bg_pos = new CssBackgroundPosition(ac, exp, check2);
        expression.mark();
        for (int i = 0; i < 3; ++i) {
            if (op != ' ' || expression.end()) continue;
            expression.next();
            if (expression.end()) break;
            exp.addValue(expression.getValue());
            exp.starts();
            try {
                bg_pos = new CssBackgroundPosition(ac, exp, check2);
                last_val = i;
                continue;
            }
            catch (InvalidParamException invalidParamException) {
                // empty catch block
            }
        }
        expression.reset();
        while (last_val >= 0) {
            expression.next();
            --last_val;
        }
        return bg_pos.value;
    }

    public CssBackgroundValue check(ApplContext ac, CssExpression expression, boolean check2, boolean is_final) throws InvalidParamException {
        CssBackgroundValue v = new CssBackgroundValue();
        boolean next_is_size = false;
        boolean got_size = false;
        boolean prev_is_position = false;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 3: 
                case 15: {
                    prev_is_position = false;
                    if (v.color != null || next_is_size || !is_final) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    CssExpression exp = new CssExpression();
                    exp.addValue(val);
                    CssBackgroundColor bg_color = new CssBackgroundColor(ac, exp, check2);
                    v.color = bg_color.value;
                    break;
                }
                case 2: 
                case 16: {
                    prev_is_position = false;
                    if (v.bg_image != null || next_is_size) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    CssExpression exp = new CssExpression();
                    exp.addValue(val);
                    CssBackgroundImage bg_image = new CssBackgroundImage(ac, exp, check2);
                    CssValue res = bg_image.value;
                    if (res != null) {
                        v.bg_image = res;
                        break;
                    }
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                case 4: 
                case 5: 
                case 6: {
                    CssValue res;
                    prev_is_position = false;
                    if (next_is_size) {
                        if (v.bg_size != null) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        res = this.getCssBackgroundSizeValue(ac, expression, check2);
                        op = expression.getOperator();
                        if (!(res instanceof CssValue)) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        v.bg_size = res;
                        got_size = true;
                        next_is_size = false;
                        break;
                    }
                    if (got_size) {
                        throw new InvalidParamException("bg_order", val, this.getPropertyName(), ac);
                    }
                    if (v.bg_position != null) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    res = this.getCssBackgroundPositionValue(ac, expression, check2);
                    op = expression.getOperator();
                    prev_is_position = true;
                    if (res != null) {
                        v.bg_position = res;
                        break;
                    }
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                case 0: {
                    CssValue res;
                    CssBackgroundImage bg_image;
                    CssBackgroundColor bg_color;
                    CssExpression exp;
                    prev_is_position = false;
                    CssIdent ident_val = val.getIdent();
                    if (CssBackgroundAttachment.isMatchingIdent(ident_val)) {
                        if (v.attachment != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        CssBackgroundAttachment attachment = new CssBackgroundAttachment(ac, exp, check2);
                        res = attachment.value;
                        if (res != null) {
                            v.attachment = res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (CssBackgroundImage.isMatchingIdent(ident_val)) {
                        if (v.bg_image != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        bg_image = new CssBackgroundImage(ac, exp, check2);
                        res = bg_image.value;
                        if (res != null) {
                            v.bg_image = res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (CssBackgroundOrigin.isMatchingIdent(ident_val)) {
                        if (next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        if (v.origin != null) {
                            if (v.clip != null) {
                                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                            }
                            exp = new CssExpression();
                            exp.addValue(val);
                            CssBackgroundClip clip = new CssBackgroundClip(ac, exp, check2);
                            res = clip.value;
                            if (res != null) {
                                v.clip = res;
                                break;
                            }
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        CssBackgroundOrigin origin = new CssBackgroundOrigin(ac, exp, check2);
                        res = origin.value;
                        if (res != null) {
                            v.origin = res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (CssBackgroundRepeat.isMatchingIdent(ident_val)) {
                        if (v.repeat_style != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        res = this.getCssBackgroundRepeatValue(ac, expression, check2);
                        op = expression.getOperator();
                        if (res != null) {
                            v.repeat_style = res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (next_is_size) {
                        if (CssBackgroundSize.isMatchingIdent(ident_val)) {
                            if (v.bg_size != null) {
                                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                            }
                            res = this.getCssBackgroundSizeValue(ac, expression, check2);
                            op = expression.getOperator();
                            if (res == null) {
                                throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                            }
                            v.bg_size = res;
                            got_size = true;
                            next_is_size = false;
                            break;
                        }
                    } else if (CssBackgroundPosition.isMatchingIdent(ident_val)) {
                        if (got_size) {
                            throw new InvalidParamException("bg_order", val, this.getPropertyName(), ac);
                        }
                        if (v.bg_position != null) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        res = this.getCssBackgroundPositionValue(ac, expression, check2);
                        op = expression.getOperator();
                        prev_is_position = true;
                        if (res != null) {
                            v.bg_position = res;
                            break;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    if (is_final) {
                        if (v.color != null || next_is_size) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        exp = new CssExpression();
                        exp.addValue(val);
                        bg_color = new CssBackgroundColor(ac, exp, check2);
                        v.color = (CssValue)bg_color.get();
                        break;
                    }
                }
                case 11: {
                    prev_is_position = false;
                    if (v.color != null || next_is_size || !is_final) {
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    CssExpression exp = new CssExpression();
                    exp.addValue(val);
                    CssBackgroundColor bg_color = new CssBackgroundColor(ac, exp, check2);
                    v.color = bg_color.value;
                    break;
                }
                case 14: {
                    if (!prev_is_position) {
                        throw new InvalidParamException("operator", val, this.getPropertyName(), ac);
                    }
                    next_is_size = true;
                    break;
                }
                default: {
                    if (val.getRawType() == 20) {
                        v.color = val;
                        break;
                    }
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            expression.next();
        }
        this.align_bg_values(v);
        return v;
    }

    private void align_bg_values(CssBackgroundValue v) {
        v.bg_image_value = v.bg_image == null ? new CssBackgroundImage().value : v.bg_image;
        v.bg_position_value = v.bg_position == null ? new CssBackgroundPosition().value : v.bg_position;
        v.bg_size_value = v.bg_size == null ? new CssBackgroundSize().value : v.bg_size;
        v.repeat_style_value = v.repeat_style == null ? new CssBackgroundRepeat().value : v.repeat_style;
        v.attachment_value = v.attachment == null ? new CssBackgroundAttachment().value : v.attachment;
        if (v.origin == null) {
            CssValue css_val = new CssBackgroundOrigin().value;
            v.origin_value = new CssBackgroundOrigin().value;
            try {
                if (v.clip == null && css_val.getType() == 0 && CssBackgroundClip.isMatchingIdent(css_val.getIdent())) {
                    v.clip_value = v.origin_value;
                }
            }
            catch (InvalidParamException invalidParamException) {}
        } else {
            v.origin_value = v.origin;
        }
        if (v.clip != null) {
            v.clip_value = v.clip;
        }
        v.color_value = v.color == null ? new CssBackgroundColor().getColor() : v.color;
    }

    private void transform_into_individual_values() {
        if (this.value instanceof CssBackgroundValue) {
            CssBackgroundValue v = (CssBackgroundValue)this.value;
            if (v.color != null) {
                this.color = new CssBackgroundColor();
                this.color.set(v.color_value);
            }
            if (v.bg_image != null) {
                this.image = new CssBackgroundImage();
                this.image.value = v.bg_image_value;
            }
            if (v.repeat_style != null) {
                this.repeat = new CssBackgroundRepeat();
                this.repeat.value = v.repeat_style_value;
            }
            if (v.attachment != null) {
                this.attachment = new CssBackgroundAttachment();
                this.attachment.value = v.attachment_value;
            }
            if (v.bg_position != null) {
                this.position = new CssBackgroundPosition();
                this.position.value = v.bg_position_value;
            }
            if (v.bg_size != null) {
                this.size = new CssBackgroundSize();
                this.size.value = v.bg_size_value;
            }
        } else if (this.value instanceof CssLayerList) {
            ArrayList vlist = (ArrayList)this.value.get();
            int len = vlist.size();
            ArrayList<CssValue> images = new ArrayList<CssValue>(len);
            ArrayList<CssValue> repeats = new ArrayList<CssValue>(len);
            ArrayList<CssValue> positions = new ArrayList<CssValue>(len);
            ArrayList<CssValue> attachments = new ArrayList<CssValue>(len);
            ArrayList<CssValue> sizes = new ArrayList<CssValue>(len);
            for (int i = 0; i < len; ++i) {
                CssBackgroundValue v = (CssBackgroundValue)vlist.get(i);
                images.add(v.bg_image_value);
                repeats.add(v.repeat_style_value);
                positions.add(v.bg_position_value);
                attachments.add(v.attachment_value);
                sizes.add(v.bg_size_value);
                if (v.color == null) continue;
                this.color = new CssBackgroundColor();
                this.color.set(v.color_value);
            }
            this.image = new CssBackgroundImage();
            this.image.value = new CssLayerList(images);
            this.repeat = new CssBackgroundRepeat();
            this.repeat.value = new CssLayerList(repeats);
            this.attachment = new CssBackgroundAttachment();
            this.attachment.value = new CssLayerList(attachments);
            this.position = new CssBackgroundPosition();
            this.position.value = new CssLayerList(positions);
            this.size = new CssBackgroundSize();
            this.size.value = new CssLayerList(sizes);
        } else {
            this.image = null;
            this.repeat = null;
            this.attachment = null;
            this.color = null;
            this.size = null;
            this.position = null;
        }
    }

    @Override
    public Object get() {
        return this.value;
    }

    @Override
    public CssValue getColor() {
        if (this.color == null) {
            return null;
        }
        return this.color.getColor();
    }

    public class CssBackgroundValue
    extends CssValueList {
        CssValue bg_image = null;
        CssValue bg_position = null;
        CssValue bg_size = null;
        CssValue repeat_style = null;
        CssValue attachment = null;
        CssValue origin = null;
        CssValue clip = null;
        CssValue color = null;
        CssValue bg_image_value = null;
        CssValue bg_position_value = null;
        CssValue bg_size_value = null;
        CssValue repeat_style_value = null;
        CssValue attachment_value = null;
        CssValue origin_value = null;
        CssValue clip_value = null;
        CssValue color_value = null;

        public boolean equals(CssBackgroundValue v) {
            if (this.bg_image_value == null ? v.bg_image_value != null : !this.bg_image_value.equals(v.bg_image_value)) {
                return false;
            }
            if (this.bg_position_value == null ? v.bg_position_value != null : !this.bg_position_value.equals(v.bg_position_value)) {
                return false;
            }
            if (this.bg_size_value == null ? v.bg_size_value != null : !this.bg_size_value.equals(v.bg_size_value)) {
                return false;
            }
            if (this.repeat_style_value == null ? v.repeat_style_value != null : !this.repeat_style_value.equals(v.repeat_style_value)) {
                return false;
            }
            if (this.attachment_value == null ? v.attachment_value != null : !this.attachment_value.equals(v.attachment_value)) {
                return false;
            }
            if (this.origin_value == null ? v.origin_value != null : !this.origin_value.equals(v.origin_value)) {
                return false;
            }
            if (this.clip_value == null ? v.clip_value != null : !this.clip_value.equals(v.clip_value)) {
                return false;
            }
            return !(this.color_value == null ? v.color_value != null : !this.color_value.equals(v.color_value));
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.bg_image != null) {
                sb.append(this.bg_image).append(' ');
            }
            if (this.bg_position != null) {
                sb.append(this.bg_position).append(' ');
                if (this.bg_size != null) {
                    sb.append('/').append(this.bg_size).append(' ');
                }
            }
            if (this.repeat_style != null) {
                sb.append(this.repeat_style).append(' ');
            }
            if (this.attachment != null) {
                sb.append(this.attachment).append(' ');
            }
            if (this.origin != null) {
                sb.append(this.origin).append(' ');
            }
            if (this.clip != null) {
                sb.append(this.clip).append(' ');
            }
            if (this.color != null) {
                sb.append(this.color);
            } else {
                int sb_length = sb.length();
                if (sb_length > 0) {
                    sb.setLength(sb_length - 1);
                }
            }
            return sb.toString();
        }
    }
}

