/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Util;

public class PropertiesLoader {
    public static Utf8Properties DEFAULT_PROFILE;
    public static Utf8Properties config;
    public static Utf8Properties mediaProperties;
    private static Utf8Properties profiles;
    private static Hashtable<String, Utf8Properties> allProps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Utf8Properties loadProfile(String profile, String profilePath) throws IOException {
        Utf8Properties result = new Utf8Properties();
        InputStream f = null;
        URL url = null;
        if (profilePath != null) {
            String[] split = profilePath.split(",");
            for (int i = 0; i < split.length; ++i) {
                String token = split[i].trim();
                if (profiles.getProperty(token) != null) {
                    Utf8Properties otherProfile = allProps.get(token);
                    if (otherProfile == null) {
                        otherProfile = PropertiesLoader.loadProfile(token, profiles.getProperty(token));
                    }
                    result.putAll((Map<?, ?>)otherProfile);
                    continue;
                }
                url = PropertiesLoader.class.getResource(token);
                try {
                    f = url.openStream();
                    result.load(f);
                    continue;
                }
                finally {
                    f.close();
                }
            }
        }
        allProps.put(new String(profile), result);
        if (Util.onDebug) {
            System.out.println(profile + " profile loaded");
        }
        return result;
    }

    public static Utf8Properties getProfile(String profile) {
        Utf8Properties result = allProps.get(profile);
        if (result == null) {
            result = new Utf8Properties();
            String profilePath = (String)profiles.get(profile);
            if (profilePath != null && !profilePath.equals("")) {
                try {
                    return PropertiesLoader.loadProfile(profile, profilePath);
                }
                catch (IOException e) {
                    if (Util.onDebug) {
                        System.out.println(PropertiesLoader.class + ": Error while loading " + profile + " profile");
                    }
                    e.printStackTrace();
                }
            }
            return DEFAULT_PROFILE;
        }
        return result;
    }

    public static String[] getProfiles() {
        Iterator<Object> it = profiles.keySet().iterator();
        ArrayList<String> res = new ArrayList<String>();
        while (it.hasNext()) {
            String profil = it.next().toString();
            if (!profil.startsWith("css") || profil.contains("svg")) continue;
            res.add(profil);
        }
        Collections.sort(res);
        return res.toArray(new String[res.size()]);
    }

    private static void loadMedia(String mediaProperty) {
        String[] mediaFiles = mediaProperty.split(",");
        for (int i = 0; i < mediaFiles.length; ++i) {
            Utf8Properties current;
            block9: {
                String mediaFile = mediaFiles[i].trim();
                current = new Utf8Properties();
                URL url = PropertiesLoader.class.getResource(mediaFile);
                InputStream f = null;
                try {
                    f = url.openStream();
                    current.load(f);
                }
                catch (IOException e) {
                    if (f == null) break block9;
                    try {
                        f.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (mediaProperties == null || mediaProperties.isEmpty()) {
                mediaProperties = current;
                continue;
            }
            Set<Object> keySet = current.keySet();
            for (Object object : keySet) {
                String currentVal = current.getProperty((String)object);
                String previousVal = mediaProperties.getProperty((String)object);
                if ("all".equals(previousVal)) continue;
                if ("all".equals(currentVal)) {
                    mediaProperties.put(object, currentVal);
                    continue;
                }
                Object concat = currentVal;
                if (previousVal != null) {
                    concat = previousVal + ", " + currentVal;
                }
                mediaProperties.put(object, concat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        config = new Utf8Properties();
        mediaProperties = new Utf8Properties();
        profiles = new Utf8Properties();
        allProps = new Hashtable();
        InputStream f = null;
        try {
            URL url = PropertiesLoader.class.getResource("Config.properties");
            f = url.openStream();
            config.load(f);
            String media = config.getProperty("media");
            PropertiesLoader.loadMedia(media);
            url = PropertiesLoader.class.getResource(config.getProperty("profilesProperties"));
            f = url.openStream();
            profiles.load(f);
            String defaultProfile = config.getProperty("defaultProfile");
            String defaultPath = (String)profiles.get(defaultProfile);
            DEFAULT_PROFILE = PropertiesLoader.loadProfile(defaultProfile, defaultPath);
            if (Util.onDebug) {
                System.out.println("Default profile (" + defaultProfile + ") loaded");
            }
        }
        catch (Exception e) {
            System.err.println(PropertiesLoader.class + ": Error while loading default config");
            e.printStackTrace();
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                    f = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

