/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.XdmNode;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class FoFOP
implements FoProcessor {
    XProcRuntime runtime = null;
    Properties options = null;
    XStep step = null;
    URIResolver resolver = null;
    private FopFactory fopFactory = null;

    public void initialize(XProcRuntime runtime, XStep step, Properties options) {
        this.runtime = runtime;
        this.step = step;
        this.options = options;
        this.resolver = runtime.getResolver();
        URI baseURI = step.getStep().getNode().getBaseURI();
        String s = this.getStringProp("BaseURL");
        if (s != null) {
            baseURI = baseURI.resolve(s);
        }
        FopFactoryBuilder fopBuilder = null;
        try {
            Float f;
            s = this.getStringProp("UserConfig");
            if (s != null) {
                DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
                DefaultConfiguration cfg = cfgBuilder.buildFromFile(new File(s));
                fopBuilder = new FopFactoryBuilder(baseURI).setConfiguration((Configuration)cfg);
            } else {
                fopBuilder = new FopFactoryBuilder(baseURI);
            }
            Boolean b = this.getBooleanProp("StrictFOValidation");
            if (b != null) {
                fopBuilder.setStrictFOValidation(b.booleanValue());
            }
            if ((b = this.getBooleanProp("BreakIndentInheritanceOnReferenceAreaBoundary")) != null) {
                fopBuilder.setBreakIndentInheritanceOnReferenceAreaBoundary(b.booleanValue());
            }
            if ((f = this.getFloatProp("SourceResolution")) != null) {
                fopBuilder.setSourceResolution(f.floatValue());
            }
            if ((b = this.getBooleanProp("Base14KerningEnabled")) != null) {
                fopBuilder.getFontManager().setBase14KerningEnabled(b.booleanValue());
            }
            if ((s = this.getStringProp("PageHeight")) != null) {
                fopBuilder.setPageHeight(s);
            }
            if ((s = this.getStringProp("PageWidth")) != null) {
                fopBuilder.setPageWidth(s);
            }
            if ((f = this.getFloatProp("TargetResolution")) != null) {
                fopBuilder.setTargetResolution(f.floatValue());
            }
            if ((b = this.getBooleanProp("StrictUserConfigValidation")) != null) {
                fopBuilder.setStrictUserConfigValidation(b.booleanValue());
            }
            if ((b = this.getBooleanProp("StrictValidation")) != null) {
                fopBuilder.setStrictUserConfigValidation(b.booleanValue());
            }
            if ((b = this.getBooleanProp("UseCache")) != null && !b.booleanValue()) {
                fopBuilder.getFontManager().disableFontCache();
            }
            this.fopFactory = fopBuilder.build();
        }
        catch (Exception e) {
            throw new XProcException((Throwable)e);
        }
    }

    public void format(XdmNode doc, OutputStream out, String contentType) {
        String outputFormat = null;
        if (contentType == null || "application/pdf".equalsIgnoreCase(contentType)) {
            outputFormat = "application/pdf";
        } else if ("application/PostScript".equalsIgnoreCase(contentType)) {
            outputFormat = "application/postscript";
        } else if ("application/afp".equalsIgnoreCase(contentType)) {
            outputFormat = "application/x-afp";
        } else if ("application/rtf".equalsIgnoreCase(contentType)) {
            outputFormat = "application/rtf";
        } else if ("text/plain".equalsIgnoreCase(contentType)) {
            outputFormat = "text/plain";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + contentType);
        }
        try {
            Float f;
            String s;
            InputSource fodoc = S9apiUtils.xdmToInputSource((XProcRuntime)this.runtime, (XdmNode)doc);
            SAXSource source = new SAXSource(fodoc);
            FOUserAgent userAgent = this.fopFactory.newFOUserAgent();
            Class<?> uaClass = userAgent.getClass();
            Boolean b = this.getBooleanProp("Accessibility");
            if (b != null) {
                userAgent.setAccessibility(b.booleanValue());
            }
            if ((s = this.getStringProp("Author")) != null) {
                userAgent.setAuthor(s);
            }
            if ((b = this.getBooleanProp("ConserveMemoryPolicy")) != null) {
                userAgent.setConserveMemoryPolicy(b.booleanValue());
            }
            if ((s = this.getStringProp("CreationDate")) != null) {
                DateFormat df = DateFormat.getDateInstance();
                Date d = df.parse(s);
                userAgent.setCreationDate(d);
            }
            if ((s = this.getStringProp("Creator")) != null) {
                userAgent.setCreator(s);
            }
            if ((s = this.getStringProp("Keywords")) != null) {
                userAgent.setKeywords(s);
            }
            if ((b = this.getBooleanProp("LocatorEnabled")) != null) {
                userAgent.setLocatorEnabled(b.booleanValue());
            }
            if ((s = this.getStringProp("Producer")) != null) {
                userAgent.setProducer(s);
            }
            if ((s = this.getStringProp("Subject")) != null) {
                userAgent.setSubject(s);
            }
            if ((f = this.getFloatProp("TargetResolution")) != null) {
                userAgent.setTargetResolution(f.floatValue());
            }
            if ((s = this.getStringProp("Title")) != null) {
                userAgent.setTitle(s);
            }
            Fop fop = userAgent.newFop(outputFormat, out);
            DefaultHandler defHandler = fop.getDefaultHandler();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(source, new SAXResult(defHandler));
        }
        catch (Exception e) {
            throw new XProcException(this.step.getNode(), "Failed to process FO document with FOP", (Throwable)e);
        }
    }

    private String getStringProp(String name) {
        return this.options.getProperty(name);
    }

    private Float getFloatProp(String name) {
        String s = this.getStringProp(name);
        if (s != null) {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String name) {
        String s = this.options.getProperty(name);
        if (s != null) {
            return "true".equals(s);
        }
        return null;
    }
}

