/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import jp.co.antenna.XfoJavaCtl.MessageListener;
import jp.co.antenna.XfoJavaCtl.XfoException;
import jp.co.antenna.XfoJavaCtl.XfoFormatPageListener;
import jp.co.antenna.XfoJavaCtl.XfoObj;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoAH
implements FoProcessor {
    private Logger logger = LoggerFactory.getLogger(FoAH.class);
    XProcRuntime runtime = null;
    Properties options = null;
    XStep step = null;
    XfoObj ah = null;

    public void initialize(XProcRuntime runtime, XStep step, Properties options) {
        this.runtime = runtime;
        this.step = step;
        this.options = options;
        try {
            Boolean b;
            this.ah = new XfoObj();
            this.ah.setFormatterType(4);
            FoMessages msgs = new FoMessages();
            this.ah.setMessageListener((MessageListener)msgs);
            String s = this.getStringProp("OptionsFileURI");
            if (s != null) {
                this.ah.setOptionFileURI(s);
            }
            this.ah.setExitLevel(4);
            Integer i = this.getIntProp("ExitLevel");
            if (i != null) {
                this.ah.setExitLevel(i.intValue());
            }
            if ((i = this.getIntProp("EmbedAllFontsEx")) != null) {
                this.ah.setPdfEmbedAllFontsEx(i.intValue());
            }
            if ((i = this.getIntProp("ImageCompression")) != null) {
                this.ah.setPdfImageCompression(i.intValue());
            }
            if ((b = this.getBooleanProp("NoAccessibility")) != null) {
                this.ah.setPdfNoAccessibility(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoAddingOrChangingComments")) != null) {
                this.ah.setPdfNoAddingOrChangingComments(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoAssembleDoc")) != null) {
                this.ah.setPdfNoAssembleDoc(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoChanging")) != null) {
                this.ah.setPdfNoChanging(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoContentCopying")) != null) {
                this.ah.setPdfNoContentCopying(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoFillForm")) != null) {
                this.ah.setPdfNoFillForm(b.booleanValue());
            }
            if ((b = this.getBooleanProp("NoPrinting")) != null) {
                this.ah.setPdfNoPrinting(b.booleanValue());
            }
            if ((s = this.getStringProp("OwnersPassword")) != null) {
                this.ah.setPdfOwnerPassword(s);
            }
            if ((b = this.getBooleanProp("TwoPassFormatting")) != null) {
                this.ah.setTwoPassFormatting(b.booleanValue());
            }
        }
        catch (XfoException xfoe) {
            throw new XProcException((Throwable)xfoe);
        }
    }

    public void format(XdmNode doc, OutputStream out, String contentType) {
        String outputFormat = null;
        if (contentType == null || "application/pdf".equals(contentType)) {
            outputFormat = "@PDF";
        } else if ("application/PostScript".equals(contentType)) {
            outputFormat = "@PS";
        } else if ("image/svg+xml".equals(contentType)) {
            outputFormat = "@SVG";
        } else if ("application/vnd.inx".equals(contentType)) {
            outputFormat = "@INX";
        } else if ("application/vnd.mif".equals(contentType)) {
            outputFormat = "@MIF";
        } else if ("text/plain".equals(contentType)) {
            outputFormat = "@TEXT";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + contentType);
        }
        try {
            Serializer serializer = this.runtime.getProcessor().newSerializer();
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                serializer.setOutputStream((OutputStream)baos);
                S9apiUtils.serialize((XProcRuntime)this.runtime, (XdmNode)doc, (Serializer)serializer);
            }
            catch (SaxonApiException sae) {
                throw new XProcException((Throwable)sae);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
            this.ah.render((InputStream)bis, out, outputFormat);
            this.ah.releaseObjectEx();
        }
        catch (XfoException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            throw new XProcException((Throwable)e);
        }
    }

    private String getStringProp(String name) {
        return this.options.getProperty(name);
    }

    private Integer getIntProp(String name) {
        String s = this.getStringProp(name);
        if (s != null) {
            try {
                int i = Integer.parseInt(s);
                return i;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String name) {
        String s = this.options.getProperty(name);
        if (s != null) {
            return "true".equals(s);
        }
        return null;
    }

    private class FoMessages
    implements MessageListener,
    XfoFormatPageListener {
        private FoMessages() {
        }

        public void onMessage(int errLevel, int errCode, String errMessage) {
            switch (errLevel) {
                case 1: {
                    FoAH.this.step.info(FoAH.this.step.getNode(), errMessage);
                    return;
                }
                case 2: {
                    FoAH.this.step.warning(FoAH.this.step.getNode(), errMessage);
                    return;
                }
            }
            FoAH.this.step.error(FoAH.this.step.getNode(), errMessage, XProcConstants.stepError((int)errCode));
        }

        public void onFormatPage(int pageNo) {
            FoAH.this.logger.trace(MessageFormatter.nodeMessage((XdmNode)FoAH.this.step.getNode(), (String)("Formatted PDF page " + pageNo)));
        }
    }
}

