/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilter;
import org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilterFactory;
import org.apache.lucene.analysis.miscellaneous.ProtectedTermFilter;
import org.apache.lucene.util.ResourceLoader;

public class ProtectedTermFilterFactory
extends ConditionalTokenFilterFactory {
    public static final String NAME = "protectedTerm";
    public static final String PROTECTED_TERMS = "protected";
    public static final char FILTER_ARG_SEPARATOR = '.';
    public static final char FILTER_NAME_ID_SEPARATOR = '-';
    private final String termFiles;
    private final boolean ignoreCase;
    private final String wrappedFilters;
    private CharArraySet protectedTerms;

    public ProtectedTermFilterFactory(Map<String, String> args) {
        super(args);
        this.termFiles = this.require(args, PROTECTED_TERMS);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        this.wrappedFilters = this.get(args, "wrappedFilters");
        if (this.wrappedFilters != null) {
            this.handleWrappedFilterArgs(args);
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public ProtectedTermFilterFactory() {
        throw ProtectedTermFilterFactory.defaultCtorException();
    }

    private void handleWrappedFilterArgs(Map<String, String> args) {
        LinkedHashMap<String, Map<String, String>> wrappedFilterArgs = new LinkedHashMap<String, Map<String, String>>();
        this.splitAt(',', this.wrappedFilters).forEach(filterName -> {
            if (wrappedFilterArgs.containsKey(filterName = filterName.trim().toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("wrappedFilters contains duplicate '" + filterName + "'. Add unique '-id' suffixes (stripped prior to SPI lookup).");
            }
            wrappedFilterArgs.put((String)filterName, new HashMap());
        });
        Iterator<Map.Entry<String, String>> iterator = args.entrySet().iterator();
        while (iterator.hasNext()) {
            String filterName2;
            Map.Entry<String, String> entry = iterator.next();
            String filterArgKey = entry.getKey();
            String argValue = entry.getValue();
            List splitKey = this.splitAt('.', filterArgKey);
            if (splitKey.size() != 2 || !wrappedFilterArgs.containsKey(filterName2 = ((String)splitKey.get(0)).toLowerCase(Locale.ROOT))) continue;
            Map filterArgs = wrappedFilterArgs.computeIfAbsent(filterName2, k -> new HashMap());
            String argKey = (String)splitKey.get(1);
            filterArgs.put(argKey, argValue);
            iterator.remove();
        }
        if (args.isEmpty()) {
            this.populateInnerFilters(wrappedFilterArgs);
        }
    }

    private void populateInnerFilters(LinkedHashMap<String, Map<String, String>> wrappedFilterArgs) {
        ArrayList<TokenFilterFactory> innerFilters = new ArrayList<TokenFilterFactory>();
        wrappedFilterArgs.forEach((filterName, filterArgs) -> {
            int idSuffixPos = filterName.indexOf(45);
            if (idSuffixPos != -1) {
                filterName = filterName.substring(0, idSuffixPos);
            }
            innerFilters.add(TokenFilterFactory.forName((String)filterName, (Map)filterArgs));
        });
        this.setInnerFilters(innerFilters);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getProtectedTerms() {
        return this.protectedTerms;
    }

    @Override
    protected ConditionalTokenFilter create(TokenStream input, Function<TokenStream, TokenStream> inner) {
        return new ProtectedTermFilter(this.protectedTerms, input, inner);
    }

    @Override
    public void doInform(ResourceLoader loader) throws IOException {
        this.protectedTerms = this.getWordSet(loader, this.termFiles, this.ignoreCase);
    }
}

