/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.validate.external.json;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaClient;
import org.json.JSONException;
import org.json.JSONLocation;
import org.json.JSONObject;
import org.json.JSONPointer;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.validate.external.api.ValidationSeverity;

public final class JSONValidationUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)JSONValidationUtil.class.getName());

    private JSONValidationUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static ro.sync.exml.validate.external.api.ValidationException createJsonSchemaException(String jsonPointerLocation, String message, boolean isError, String schemaSystemId, SchemaClient httpClient, JSONObject schemaJson) {
        int anchorIdx;
        if (jsonPointerLocation != null && (anchorIdx = JSONValidationUtil.getAnchorIndexFromLocation(jsonPointerLocation)) > 0) {
            schemaSystemId = JSONValidationUtil.getLocation(schemaSystemId, jsonPointerLocation.substring(0, anchorIdx));
            jsonPointerLocation = jsonPointerLocation.substring(anchorIdx);
            try {
                if (httpClient != null) {
                    schemaJson = new JSONObject(new JSONTokener(httpClient.get(schemaSystemId)), true, false);
                }
            }
            catch (JSONException e) {
                logger.debug(message, (Throwable)e);
            }
        }
        final String finalJsonPointerLocation = jsonPointerLocation;
        ValidationException cause = new ValidationException(message){
            private static final long serialVersionUID = -2942952231644207581L;

            @Override
            public String getPointerToViolation() {
                return finalJsonPointerLocation;
            }
        };
        ro.sync.exml.validate.external.api.ValidationException schemaException = new ro.sync.exml.validate.external.api.ValidationException(message, schemaSystemId, isError ? ValidationSeverity.ERROR : ValidationSeverity.WARNING, (Throwable)cause);
        if (schemaJson != null) {
            JSONValidationUtil.addLocation(schemaJson, jsonPointerLocation, schemaException);
        }
        return schemaException;
    }

    private static int getAnchorIndexFromLocation(String jsonPointerLocation) {
        int indexOf;
        int anchorIdx = jsonPointerLocation.indexOf(35);
        if (anchorIdx == -1 && (indexOf = jsonPointerLocation.indexOf(".json/")) != -1) {
            anchorIdx = indexOf + 5;
        }
        return anchorIdx;
    }

    static String getLocation(String systemId, String relativeLocation) {
        if (!relativeLocation.isEmpty()) {
            try {
                systemId = new URL(new URL(systemId), relativeLocation).toString();
            }
            catch (MalformedURLException e) {
                logger.debug("Cannot compute schema location from: {}", (Object)relativeLocation, (Object)e);
            }
        }
        return systemId;
    }

    static void setExceptionLocation(ro.sync.exml.validate.external.api.ValidationException e, JSONLocation location) {
        if (e != null && location != null) {
            e.setLineNumber(location.getLine());
            e.setColumnNumber(location.getColumn());
            e.setEndLineNumber(location.getEndLine());
            e.setEndColumnNumber(location.getEndColumn());
        }
    }

    static List<ro.sync.exml.validate.external.api.ValidationException> createValidationProblems(String systemID, Object instanceObject, ValidationException exception) {
        ArrayList<ro.sync.exml.validate.external.api.ValidationException> validationProblems = new ArrayList<ro.sync.exml.validate.external.api.ValidationException>();
        ArrayDeque<ValidationException> stack = new ArrayDeque<ValidationException>();
        stack.push(exception);
        while (!stack.isEmpty()) {
            ValidationException validationException = (ValidationException)stack.pop();
            List<ValidationException> causingExceptions = validationException.getCausingExceptions();
            if (!causingExceptions.isEmpty()) {
                stack.addAll(causingExceptions);
                continue;
            }
            ro.sync.exml.validate.external.api.ValidationException problem = new ro.sync.exml.validate.external.api.ValidationException(validationException.getMessage(), systemID, ValidationSeverity.ERROR, (Throwable)validationException);
            if (instanceObject != null) {
                JSONValidationUtil.addLocation(instanceObject, validationException.getPointerToViolation(), problem);
            }
            validationProblems.add(problem);
            int validationProblemsLimit = 1000;
            if (validationProblems.size() < 1000) continue;
            break;
        }
        return validationProblems;
    }

    private static void addLocation(Object instanceObject, String jsonPointer, ro.sync.exml.validate.external.api.ValidationException newException) {
        if (jsonPointer != null) {
            try {
                JSONLocation location = new JSONPointer(jsonPointer).queryLocationFrom(instanceObject);
                JSONValidationUtil.setExceptionLocation(newException, location);
            }
            catch (Exception exception) {
                logger.debug("Cannot locate error by pointer: {}", (Object)jsonPointer, (Object)exception);
            }
        }
    }

    public static Map<String, String> getIdReferences(JSONObject jsonSchema) {
        return JSONValidationUtil.getIdReferences("", jsonSchema);
    }

    private static Map<String, String> getIdReferences(String pointer, JSONObject jsonSchema) {
        HashMap<String, String> idReferences = new HashMap<String, String>();
        String definitionsKeyword = "definitions";
        JSONObject definitions = jsonSchema.optJSONObject(definitionsKeyword);
        if (definitions == null) {
            definitionsKeyword = "$defs";
            definitions = jsonSchema.optJSONObject(definitionsKeyword);
        }
        if (definitions != null) {
            for (String definition : definitions.keySet()) {
                JSONObject definitionObject = definitions.optJSONObject(definition);
                if (definitionObject == null) continue;
                if (definitionObject.keySet().stream().anyMatch("$id"::equals)) {
                    pointer = (String)pointer + "/" + definitionsKeyword + "/" + JSONPointer.escape((String)definition);
                    idReferences.put(definitionObject.optString("$id"), (String)pointer);
                }
                idReferences.putAll(JSONValidationUtil.getIdReferences((String)pointer, definitionObject));
            }
        }
        return idReferences;
    }
}

