/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader.internal;

import java.net.URI;
import java.net.URISyntaxException;

public final class ReferenceResolver {
    public static URI resolve(URI parentScope, String encounteredSegment) {
        String parentScopePath = null;
        if (parentScope != null && (parentScopePath = parentScope.toString()).length() > 0 && parentScopePath.endsWith("/")) {
            parentScopePath = parentScopePath.substring(0, parentScopePath.length() - 1);
        }
        try {
            return new URI(ReferenceResolver.resolve(parentScopePath, encounteredSegment));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String resolve(String parentScope, String encounteredSegment) {
        try {
            if (parentScope == null) {
                return encounteredSegment;
            }
            return new URI(parentScope).resolve(encounteredSegment).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private ReferenceResolver() {
    }
}

